/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.aio.workspace;

import com.adobe.aio.auth.Context;
import com.adobe.aio.auth.JwtContext;
import com.adobe.aio.auth.OAuthContext;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class Workspace {
    public static final String IMS_URL = "aio_ims_url";
    public static final String IMS_ORG_ID = "aio_ims_org_id";
    public static final String CONSUMER_ORG_ID = "aio_consumer_org_id";
    public static final String PROJECT_ID = "aio_project_id";
    public static final String WORKSPACE_ID = "aio_workspace_id";
    public static final String API_KEY = "aio_api_key";
    public static final String CREDENTIAL_ID = "aio_credential_id";
    private final String imsUrl;
    private final String imsOrgId;
    private final String apiKey;
    private final String consumerOrgId;
    private final String projectId;
    private final String workspaceId;
    private final String credentialId;
    private final Context authContext;

    private Workspace(String imsUrl, String imsOrgId, String apiKey, String consumerOrgId, String projectId, String workspaceId, String credentialId, Context authContext) {
        this.imsUrl = StringUtils.isEmpty((CharSequence)imsUrl) ? "https://ims-na1.adobelogin.com" : imsUrl;
        this.imsOrgId = imsOrgId;
        this.apiKey = apiKey;
        this.consumerOrgId = consumerOrgId;
        this.projectId = projectId;
        this.workspaceId = workspaceId;
        this.credentialId = credentialId;
        this.authContext = authContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void validateAll() {
        this.validateWorkspaceContext();
        if (!this.isAuthOAuth() && !this.isAuthJWT()) {
            throw new IllegalStateException("Missing auth configuration, set either jwt or oauth...");
        }
        this.authContext.validate();
    }

    public void validateWorkspaceContext() throws IllegalStateException {
        if (StringUtils.isEmpty((CharSequence)this.imsOrgId)) {
            throw new IllegalStateException("Your `Workspace` is missing an imsOrgId");
        }
        if (StringUtils.isEmpty((CharSequence)this.getConsumerOrgId())) {
            throw new IllegalStateException("Your `Workspace` is missing a consumerOrgId");
        }
        if (StringUtils.isEmpty((CharSequence)this.apiKey)) {
            throw new IllegalStateException("Your `Workspace` is missing an apiKey");
        }
        if (StringUtils.isEmpty((CharSequence)this.getProjectId())) {
            throw new IllegalStateException("Your `Workspace` is missing a projectId");
        }
        if (StringUtils.isEmpty((CharSequence)this.getWorkspaceId())) {
            throw new IllegalStateException("Your `Workspace` is missing a workspaceId");
        }
        if (this.authContext == null) {
            throw new IllegalStateException("Missing auth configuration ...");
        }
    }

    public String getProjectUrl() {
        if (!StringUtils.isEmpty((CharSequence)this.getConsumerOrgId()) && !StringUtils.isEmpty((CharSequence)this.getProjectId())) {
            return "https://developer.adobe.com/console/projects/" + this.getConsumerOrgId() + "/" + this.getProjectId() + "/overview";
        }
        return null;
    }

    public String getImsUrl() {
        return this.imsUrl;
    }

    public String getImsOrgId() {
        return this.imsOrgId;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getConsumerOrgId() {
        return this.consumerOrgId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public Context getAuthContext() {
        return this.authContext;
    }

    public boolean isAuthOAuth() {
        return this.authContext != null && this.authContext instanceof OAuthContext;
    }

    public boolean isAuthJWT() {
        return this.authContext != null && this.authContext instanceof JwtContext;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Workspace workspace = (Workspace)o;
        return Objects.equals(this.imsUrl, workspace.imsUrl) && Objects.equals(this.imsOrgId, workspace.imsOrgId) && Objects.equals(this.apiKey, workspace.apiKey) && Objects.equals(this.consumerOrgId, workspace.consumerOrgId) && Objects.equals(this.projectId, workspace.projectId) && Objects.equals(this.workspaceId, workspace.workspaceId) && Objects.equals(this.authContext, workspace.authContext);
    }

    public int hashCode() {
        return Objects.hash(this.imsUrl, this.imsOrgId, this.apiKey, this.consumerOrgId, this.projectId, this.workspaceId, this.authContext);
    }

    public String toString() {
        return "Workspace{imsUrl='" + this.imsUrl + '\'' + ", imsOrgId='" + this.imsOrgId + '\'' + ", apiKey='" + this.apiKey + '\'' + ", consumerOrgId='" + this.consumerOrgId + '\'' + ", projectId='" + this.projectId + '\'' + ", workspaceId='" + this.workspaceId + '\'' + ", authContext=" + this.authContext + '}';
    }

    public static class Builder {
        private String imsUrl;
        private String imsOrgId;
        private String apiKey;
        private String consumerOrgId;
        private String projectId;
        private String workspaceId;
        private String credentialId;
        private Map<String, String> workspaceProperties;
        private Context authContext;

        private Builder() {
        }

        public Builder imsUrl(String imsUrl) {
            this.imsUrl = imsUrl;
            return this;
        }

        public Builder imsOrgId(String imsOrgId) {
            this.imsOrgId = imsOrgId;
            return this;
        }

        public Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public Builder consumerOrgId(String consumerOrgId) {
            this.consumerOrgId = consumerOrgId;
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder credentialId(String credentialId) {
            this.credentialId = credentialId;
            return this;
        }

        public Builder authContext(Context authContext) {
            this.authContext = authContext;
            return this;
        }

        public Workspace build() {
            return new Workspace(this.imsUrl, this.imsOrgId, this.apiKey, this.consumerOrgId, this.projectId, this.workspaceId, this.credentialId, this.authContext);
        }
    }
}

