/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class HALLink
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String href;
    private Boolean templated;
    private String type;
    private URL deprecation;
    private String name;
    private URI profile;
    private String title;
    private String hreflang;
    private String seen;

    public HALLink() {
    }

    protected HALLink(Builder builder) {
        this.href = builder.href;
        this.templated = builder.templated;
        this.type = builder.type;
        this.deprecation = builder.deprecation;
        this.name = builder.name;
        this.profile = builder.profile;
        this.title = builder.title;
        this.hreflang = builder.hreflang;
        this.seen = builder.seen;
    }

    public String getHref() {
        return this.href;
    }

    public Boolean getTemplated() {
        return this.templated;
    }

    public String getType() {
        return this.type;
    }

    public URL getDeprecation() {
        return this.deprecation;
    }

    public String getName() {
        return this.name;
    }

    public URI getProfile() {
        return this.profile;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHreflang() {
        return this.hreflang;
    }

    public String getSeen() {
        return this.seen;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HALLink link = (HALLink)o;
        if (this.href != null ? !this.href.equals(link.href) : link.href != null) {
            return false;
        }
        if (this.templated != null ? !this.templated.equals(link.templated) : link.templated != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(link.type) : link.type != null) {
            return false;
        }
        if (this.deprecation != null ? !this.deprecation.equals(link.deprecation) : link.deprecation != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(link.name) : link.name != null) {
            return false;
        }
        if (this.profile != null ? !this.profile.equals(link.profile) : link.profile != null) {
            return false;
        }
        if (this.title != null ? !this.title.equals(link.title) : link.title != null) {
            return false;
        }
        return this.hreflang != null ? this.hreflang.equals(link.hreflang) : link.hreflang == null;
    }

    public int hashCode() {
        int result = this.href != null ? this.href.hashCode() : 0;
        result = 31 * result + (this.templated != null ? this.templated.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.deprecation != null ? this.deprecation.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.hreflang != null ? this.hreflang.hashCode() : 0);
        return result;
    }

    public static class Builder {
        private final String href;
        private Boolean templated;
        private String type;
        private URL deprecation;
        private String name;
        private URI profile;
        private String title;
        private String hreflang;
        private String seen;

        public Builder(String href) {
            this.href = href;
            this.templated = this.getTemplated(href);
        }

        public Builder(URI href) {
            this.href = href.toString();
        }

        public Builder templated(boolean templated) {
            this.templated = templated;
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            return this;
        }

        public Builder deprecation(URL deprecation) {
            this.deprecation = deprecation;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder profile(URI profile) {
            this.profile = profile;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder hreflang(String hreflang) {
            this.hreflang = hreflang;
            return this;
        }

        public Builder seen(String temporal) {
            ZonedDateTime dt = ZonedDateTime.parse(temporal, DateTimeFormatter.ISO_INSTANT);
            return this.seen(dt.toInstant());
        }

        public Builder seen(Instant temporal) {
            this.seen = temporal.toString();
            return this;
        }

        public HALLink build() {
            return new HALLink(this);
        }

        private Boolean getTemplated(String href) {
            return href.contains("{");
        }
    }
}

