/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.deser;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializer;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBase;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.openapitools.jackson.dataformat.hal.annotation.Curie;
import io.openapitools.jackson.dataformat.hal.annotation.Curies;
import io.openapitools.jackson.dataformat.hal.annotation.Resource;
import io.openapitools.jackson.dataformat.hal.deser.CurieMap;
import io.openapitools.jackson.dataformat.hal.deser.HALBeanDeserializer;
import io.openapitools.jackson.dataformat.hal.deser.ReservedProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class HALBeanDeserializerModifier
extends BeanDeserializerModifier {
    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        Resource ann = (Resource)beanDesc.getClassAnnotations().get(Resource.class);
        if (ann != null) {
            return new HALBeanDeserializer((BeanDeserializerBase)((BeanDeserializer)deserializer));
        }
        return deserializer;
    }

    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        Resource ann = (Resource)beanDesc.getClassAnnotations().get(Resource.class);
        if (ann != null) {
            CurieMap map = this.createCurieMap(beanDesc);
            ArrayList<BeanPropertyDefinition> modified = new ArrayList<BeanPropertyDefinition>();
            Iterator<BeanPropertyDefinition> properties = propDefs.iterator();
            while (properties.hasNext()) {
                BeanPropertyDefinition property = properties.next();
                for (ReservedProperty rp : ReservedProperty.values()) {
                    String alternateName = rp.alternateName(property, map);
                    if (property.getName().equals(alternateName)) continue;
                    modified.add(property.withName(new PropertyName(alternateName)));
                    properties.remove();
                }
            }
            propDefs.addAll(modified);
        }
        return propDefs;
    }

    private CurieMap createCurieMap(BeanDescription beanDesc) {
        Curies cs;
        ArrayList<CurieMap.Mapping> mappings = new ArrayList<CurieMap.Mapping>();
        Curie sc = (Curie)beanDesc.getClassAnnotations().get(Curie.class);
        if (sc != null) {
            mappings.add(new CurieMap.Mapping(sc));
        }
        if ((cs = (Curies)beanDesc.getClassAnnotations().get(Curies.class)) != null) {
            Arrays.stream(cs.value()).forEach(c -> mappings.add(new CurieMap.Mapping((Curie)c)));
        }
        return new CurieMap(mappings.toArray(new CurieMap.Mapping[0]));
    }
}

