/*
 * Decompiled with CFR 0.152.
 */
package io.openapitools.jackson.dataformat.hal.deser;

import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import io.openapitools.jackson.dataformat.hal.annotation.EmbeddedResource;
import io.openapitools.jackson.dataformat.hal.annotation.Link;
import io.openapitools.jackson.dataformat.hal.deser.CurieMap;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Optional;
import java.util.UUID;

public enum ReservedProperty {
    LINKS("_links", Link.class),
    EMBEDDED("_embedded", EmbeddedResource.class);

    private final String name;
    private final UUID prefix = UUID.randomUUID();
    private final Class<? extends Annotation> annotation;
    private final Method valueMethod;

    private ReservedProperty(String name, Class<? extends Annotation> annotation) {
        this.name = name;
        this.annotation = annotation;
        try {
            this.valueMethod = annotation.getDeclaredMethod("value", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public String getPropertyName() {
        return this.name;
    }

    public String alternateName(BeanPropertyDefinition bpd, CurieMap map) {
        String curiePrefix;
        String name;
        String originalName = bpd.getName();
        AnnotatedMember annotatedMember = ReservedProperty.firstNonNull(bpd.getField(), bpd.getSetter(), bpd.getGetter());
        if (annotatedMember == null) {
            return originalName;
        }
        Annotation o = annotatedMember.getAnnotation(this.annotation);
        if (o == null) {
            return originalName;
        }
        try {
            String alternateName = (String)this.valueMethod.invoke((Object)o, new Object[0]);
            name = alternateName.isEmpty() ? originalName : alternateName;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        if (o.annotationType() == Link.class && !(curiePrefix = ((Link)o).curie()).isEmpty()) {
            Optional<URI> resolved = map.resolve(curiePrefix + ":" + name);
            return this.alternateName(resolved.map(URI::toString).orElse(name));
        }
        return this.alternateName(name);
    }

    public String alternateName(String originalName) {
        return this.prefix.toString() + ":" + originalName;
    }

    @SafeVarargs
    static <T> T firstNonNull(T ... vals) {
        for (T v : vals) {
            if (v == null) continue;
            return v;
        }
        return null;
    }
}

