/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.security;

import flex.messaging.FlexContext;
import flex.messaging.security.AppServerLoginCommand;
import java.security.Principal;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import weblogic.security.SimpleCallbackHandler;
import weblogic.security.SubjectUtils;
import weblogic.security.services.Authentication;
import weblogic.servlet.security.ServletAuthentication;

public class WeblogicLoginCommand
extends AppServerLoginCommand {
    public Principal doAuthentication(String username, Object credentials) {
        Principal principal = null;
        String password = this.extractPassword(credentials);
        if (password != null) {
            HttpServletResponse response = FlexContext.getHttpResponse();
            if (response != null) {
                HttpServletRequest request = FlexContext.getHttpRequest();
                int result = 1;
                try {
                    result = ServletAuthentication.login((String)username, (String)password, (HttpServletRequest)request);
                }
                catch (LoginException e) {
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    result = ServletAuthentication.weak((String)username, (String)password, (HttpServletRequest)request);
                }
                if (result != 1) {
                    principal = this.getSubjectPrincipal(username, password);
                }
            } else {
                principal = this.getSubjectPrincipal(username, password);
            }
        }
        return principal;
    }

    private Principal getSubjectPrincipal(String username, String password) {
        SubjectPrincipal principal = null;
        SimpleCallbackHandler handler = new SimpleCallbackHandler(username, password);
        try {
            Subject subject = Authentication.login((CallbackHandler)handler);
            principal = new SubjectPrincipal(subject);
        }
        catch (LoginException e) {
            // empty catch block
        }
        return principal;
    }

    private boolean doSubjectGroupAuthorization(Principal principal, List roles) {
        boolean authorized = false;
        Subject subject = ((SubjectPrincipal)principal).getSubject();
        Iterator iter = roles.iterator();
        while (iter.hasNext()) {
            String role = (String)iter.next();
            if (!SubjectUtils.isUserInGroup((Subject)subject, (String)role)) continue;
            authorized = true;
            break;
        }
        return authorized;
    }

    public boolean doAuthorization(Principal principal, List roles) {
        if (principal == null) {
            return false;
        }
        boolean authorized = false;
        HttpServletResponse response = FlexContext.getHttpResponse();
        if (response != null) {
            HttpServletRequest request = FlexContext.getHttpRequest();
            authorized = this.doAuthorization(principal, roles, request);
            if (!authorized) {
                authorized = this.doSubjectGroupAuthorization(principal, roles);
            }
        } else {
            authorized = this.doSubjectGroupAuthorization(principal, roles);
        }
        return authorized;
    }

    public boolean logout(Principal principal) {
        HttpServletResponse response = FlexContext.getHttpResponse();
        if (response != null) {
            HttpServletRequest request = FlexContext.getHttpRequest();
            ServletAuthentication.logout((HttpServletRequest)request);
        }
        return true;
    }

    private class SubjectPrincipal
    implements Principal {
        private Subject subject;

        public SubjectPrincipal(Subject subject) {
            this.subject = subject;
        }

        public String getName() {
            return SubjectUtils.getUserPrincipal((Subject)this.subject).getName();
        }

        public Subject getSubject() {
            return this.subject;
        }
    }
}

