/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.virtual.catalog.admin.impl;

import com.adobe.cq.commerce.common.ValueMapDecorator;
import com.adobe.cq.commerce.virtual.catalog.data.CatalogIdentifierService;
import com.adobe.granite.ui.components.ds.DataSource;
import com.adobe.granite.ui.components.ds.EmptyDataSource;
import com.adobe.granite.ui.components.ds.SimpleDataSource;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={Servlet.class}, property={"sling.servlet.resourceTypes=commerce/gui/components/admin/products/bindproducttreewizard/catalogidentifierdatasource"})
public class CatalogIdentifierDatasource
extends SlingSafeMethodsServlet {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL, bind="bindCatalogIdentifierService", unbind="unbindCatalogIdentifierService")
    private volatile CatalogIdentifierService catalogIdentifierService;

    protected void bindCatalogIdentifierService(CatalogIdentifierService service, Map<String, String> props) {
        this.catalogIdentifierService = service;
    }

    protected void unbindCatalogIdentifierService(CatalogIdentifierService service) {
    }

    protected void doGet(@Nonnull SlingHttpServletRequest request, @Nonnull SlingHttpServletResponse response) throws ServletException, IOException {
        DataSource ds = this.catalogIdentifierService == null ? EmptyDataSource.instance() : this.buildValuesList(request.getResourceResolver());
        request.setAttribute(DataSource.class.getName(), (Object)ds);
    }

    private DataSource buildValuesList(ResourceResolver resourceResolver) {
        Map<String, Collection<String>> identifiersMap = this.catalogIdentifierService.getCatalogIdentifiersForAllCommerceProviders();
        List<String> providerIdentifiers = this.flattenMapToList(identifiersMap);
        List<Resource> syntheticResources = this.generateResources(resourceResolver, providerIdentifiers);
        return this.toDataSource(syntheticResources);
    }

    protected List<Resource> generateResources(ResourceResolver resolver, List<String> properties) {
        return properties.stream().map(property -> {
            HashMap<String, Object> resourceProperties = new HashMap<String, Object>(){
                {
                    this.put("text", property);
                    this.put("value", property);
                }
            };
            ValueMapResource syntheticResource = new ValueMapResource(resolver, new ResourceMetadata(), "", (ValueMap)new ValueMapDecorator((Map)resourceProperties));
            return syntheticResource;
        }).collect(Collectors.toList());
    }

    protected List<String> flattenMapToList(Map<String, Collection<String>> mapOfCollections) {
        ArrayList<String> flatList = new ArrayList<String>();
        mapOfCollections.forEach((provider, identifiers) -> identifiers.stream().forEach(identifier -> flatList.add(provider + ":" + identifier)));
        return flatList;
    }

    protected DataSource toDataSource(List<Resource> resources) {
        return resources.isEmpty() ? EmptyDataSource.instance() : new SimpleDataSource(resources.iterator());
    }
}

