/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.virtual.catalog.data.impl;

import com.adobe.cq.commerce.virtual.catalog.data.CatalogDataResourceProviderFactory;
import com.adobe.cq.commerce.virtual.catalog.data.CatalogDataResourceProviderManager;
import com.adobe.cq.commerce.virtual.catalog.data.Constants;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.caconfig.ConfigurationBuilder;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={CatalogDataResourceProviderManager.class}, immediate=true, property={"service.description=Manages the resource registrations for the Virtual Catalog Resource Provider Manager."})
public class CatalogDataResourceProviderManagerImpl
implements CatalogDataResourceProviderManager,
EventListener {
    private static final String VIRTUAL_PRODUCTS_SERVICE = "virtual-products-service";
    private static final String OBSERVATION_PATHS_DEFAULT = "/var/commerce/products";
    private static final String FINDALLQUERIES_DEFAULT = "JCR-SQL2|SELECT * FROM [sling:Folder] WHERE ISDESCENDANTNODE('/var/commerce/products') AND ([sling:Folder].'" + Constants.PN_CONF + "'] IS NOT NULL OR [sling:Folder].'" + "cq:catalogDataResourceProviderFactory" + "' IS NOT NULL)";
    private String[] findAllQueries = new String[]{FINDALLQUERIES_DEFAULT};
    private String[] observationPaths = new String[]{"/var/commerce/products", Constants.CONF_ROOT};
    private static final List<String> WATCHED_PROPERTIES = ImmutableList.of((Object)"magentoStore", (Object)Constants.PN_MAGENTO_ROOT_CATEGORY_ID, (Object)"cq:catalogIdentifier", (Object)Constants.PN_CATALOG_PROVIDER_FACTORY, (Object)"cq:graphqlClient");
    private EventListener[] observationEventListeners;
    private volatile List<Resource> dataRoots;
    @Reference(target="(subServiceName=virtual-products-service)")
    private ServiceUserMapped serviceUserMapped;
    private final Map<ResourceProvider, ServiceRegistration<?>> providerRegistrations = Collections.synchronizedMap(new IdentityHashMap());
    private ConcurrentMap<String, ResourceProvider<?>> providers = new ConcurrentHashMap();
    private final Map<String, CatalogDataResourceProviderFactory<?>> providerFactories = new ConcurrentHashMap();
    @Reference
    private ResourceResolverFactory resolverFactory = null;
    private ResourceResolver resolver;
    private BundleContext bundleContext;
    private static final Logger log = LoggerFactory.getLogger(CatalogDataResourceProviderManagerImpl.class);

    private List<Resource> findDataRoots(ResourceResolver resolver) {
        ArrayList<Resource> allResources = new ArrayList<Resource>();
        for (String queryString : this.findAllQueries) {
            if (!StringUtils.contains((CharSequence)queryString, (CharSequence)"|")) {
                throw new IllegalArgumentException("Query string does not contain query syntax seperated by '|': " + queryString);
            }
            String queryLanguage = StringUtils.substringBefore((String)queryString, (String)"|");
            String query = StringUtils.substringAfter((String)queryString, (String)"|");
            try {
                Session session = (Session)resolver.adaptTo(Session.class);
                Workspace workspace = session.getWorkspace();
                QueryManager qm = workspace.getQueryManager();
                Query jcrQuery = qm.createQuery(query, queryLanguage);
                QueryResult result = jcrQuery.execute();
                NodeIterator nodes = result.getNodes();
                while (nodes.hasNext()) {
                    Node node = nodes.nextNode();
                    Resource resource = resolver.getResource(node.getPath());
                    if (resource == null) continue;
                    allResources.add(resource);
                }
            }
            catch (RepositoryException x) {
                log.error("Error finding data roots", (Throwable)x);
            }
        }
        this.dataRoots = allResources;
        return allResources;
    }

    private void registerDataRoots() {
        log.debug("Start registering all virtual catalog trees...");
        long start = System.currentTimeMillis();
        long countSuccess = 0L;
        long countFailed = 0L;
        List<Resource> existingVirtualCatalogs = this.findDataRoots(this.resolver);
        for (Resource virtualCatalogRootResource : existingVirtualCatalogs) {
            boolean success = this.registerDataRoot(virtualCatalogRootResource);
            if (success) {
                ++countSuccess;
                continue;
            }
            ++countFailed;
        }
        long time = System.currentTimeMillis() - start;
        log.info("Registered {} virtual catalog data resource providers(s) in {} ms, skipping {} invalid one(s).", new Object[]{countSuccess, time, countFailed});
    }

    private boolean registerDataRoot(Resource root) {
        log.debug("Registering data root at {}", (Object)root.getPath());
        log.debug("This catalog manager has {} factories registered...", (Object)this.providerFactories.size());
        String rootPath = root.getPath();
        String providerId = this.getJcrStringProperty(rootPath, "cq:catalogDataResourceProviderFactory");
        String cqConf = this.getJcrStringProperty(rootPath, "cq:conf");
        boolean valid = true;
        CatalogDataResourceProviderFactory<?> factory = null;
        if (StringUtils.isNotEmpty((CharSequence)cqConf)) {
            log.debug("Found cq:conf property pointing at {}", (Object)cqConf);
            ConfigurationBuilder cfgBuilder = (ConfigurationBuilder)root.adaptTo(ConfigurationBuilder.class);
            ValueMap properties = cfgBuilder.name(Constants.CONFIGURATION_NAME).asValueMap();
            providerId = (String)properties.get("cq:catalogDataResourceProviderFactory", String.class);
            if (providerId == null) {
                log.warn("No {} configured, nothing to register here", (Object)"cq:catalogDataResourceProviderFactory");
                return false;
            }
            log.debug("Configured provider id is {}", (Object)providerId);
            factory = this.providerFactories.get(providerId);
            if (factory == null) {
                log.warn("No factory for provider id {}, nothing to do here", (Object)providerId);
                return false;
            }
        } else {
            if (StringUtils.isBlank((CharSequence)rootPath)) {
                log.error("Root path is empty. Registering this data root will fail");
                valid = false;
            }
            if (StringUtils.isBlank((CharSequence)providerId)) {
                log.error("No providerId property found on node {}. Registering this data root will fail", (Object)rootPath);
                valid = false;
            }
            if ((factory = this.providerFactories.get(providerId)) == null) {
                log.error("No factory found for provider id {}. Registering this data root will fail", (Object)providerId);
                valid = false;
            }
        }
        log.debug("Factory retrieved... {}", (Object)(factory != null ? 1 : 0));
        if (valid) {
            ResourceProvider<?> oldProvider;
            ResourceProvider<?> provider = factory.createResourceProvider(root);
            ResourceProvider<?> resourceProvider = oldProvider = provider == null ? (ResourceProvider<?>)this.providers.remove(rootPath) : this.providers.put(rootPath, provider);
            if (provider == null && oldProvider != null) {
                this.unregisterService(oldProvider);
            } else {
                if (provider != null && oldProvider == null) {
                    this.registerService(rootPath, provider);
                    return true;
                }
                if (provider != null && !provider.equals(oldProvider)) {
                    log.debug("(Re-)registering resource provider {}.", (Object)rootPath);
                    this.unregisterService(oldProvider);
                    this.registerService(rootPath, provider);
                    return true;
                }
                log.debug("Skipped re-registering resource provider {} because there were no relevant changes.", (Object)rootPath);
            }
        } else {
            ResourceProvider oldProvider = (ResourceProvider)this.providers.remove(rootPath);
            if (oldProvider != null) {
                log.debug("Unregistering resource provider {}.", (Object)rootPath);
                this.unregisterService(oldProvider);
            }
            log.warn("Virtual catalog data definition at '{}' is invalid.", (Object)rootPath);
        }
        return false;
    }

    private String getJcrStringProperty(String pNodePath, String pPropertName) {
        String absolutePropertyPath = pNodePath + "/" + pPropertName;
        Session session = (Session)this.resolver.adaptTo(Session.class);
        try {
            if (!session.itemExists(absolutePropertyPath)) {
                return null;
            }
            return session.getProperty(absolutePropertyPath).getString();
        }
        catch (RepositoryException ex) {
            return null;
        }
    }

    @Activate
    protected synchronized void activate(ComponentContext ctx) throws LoginException, RepositoryException {
        if (this.resolver == null) {
            this.bundleContext = ctx.getBundleContext();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("sling.service.subservice", VIRTUAL_PRODUCTS_SERVICE);
            this.resolver = this.resolverFactory.getServiceResourceResolver(map);
            Session session = (Session)this.resolver.adaptTo(Session.class);
            if (session != null) {
                this.observationEventListeners = new EventListener[this.observationPaths.length];
                for (int i = 0; i < this.observationPaths.length; ++i) {
                    this.observationEventListeners[i] = new EventListener(){

                        public void onEvent(EventIterator events) {
                            CatalogDataResourceProviderManagerImpl.this.onEvent(events);
                        }
                    };
                    session.getWorkspace().getObservationManager().addEventListener(this.observationEventListeners[i], 31, this.observationPaths[i], true, null, null, true);
                }
            }
            this.registerDataRoots();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deactivate
    protected synchronized void deactivate(ComponentContext ctx) throws RepositoryException {
        try {
            Session session;
            if (this.resolver != null && (session = (Session)this.resolver.adaptTo(Session.class)) != null && this.observationEventListeners != null) {
                for (EventListener eventListener : this.observationEventListeners) {
                    session.getWorkspace().getObservationManager().removeEventListener(eventListener);
                }
            }
            for (ResourceProvider provider : this.providers.values()) {
                this.unregisterService(provider);
            }
        }
        finally {
            if (this.resolver != null) {
                this.resolver.close();
                this.resolver = null;
            }
            this.providers.clear();
            this.providerFactories.clear();
            if (!this.providerRegistrations.isEmpty()) {
                IdentityHashMap map = new IdentityHashMap(this.providerRegistrations);
                for (ResourceProvider provider : map.keySet()) {
                    this.unregisterService(provider);
                }
            }
        }
    }

    public void onEvent(EventIterator events) {
        try {
            HashMap<String, Boolean> actions = new HashMap<String, Boolean>();
            boolean nodeAdded = false;
            boolean nodeRemoved = false;
            while (events.hasNext()) {
                Event event = events.nextEvent();
                String path = event.getPath();
                int eventType = event.getType();
                if (eventType == 1) {
                    nodeAdded = true;
                    Session session = (Session)this.resolver.adaptTo(Session.class);
                    Node node = session.getNode(path);
                    if ((node == null || !node.isNodeType("sling:Folder") || !node.hasProperty("cq:catalogDataResourceProviderFactory")) && !node.hasProperty(Constants.CONF_ROOT)) continue;
                    actions.put(path, true);
                    continue;
                }
                if (eventType == 2 && this.providers.containsKey(path)) {
                    nodeRemoved = true;
                    actions.put(path, false);
                    continue;
                }
                if (eventType != 16 && eventType != 4 && eventType != 8 || !this.isRelevantPath(path)) continue;
                nodeAdded = true;
                nodeRemoved = true;
            }
            for (Map.Entry action : actions.entrySet()) {
                if (((Boolean)action.getValue()).booleanValue()) {
                    Resource rootResource = this.resolver.getResource((String)action.getKey());
                    if (rootResource == null) continue;
                    this.registerDataRoot(rootResource);
                    continue;
                }
                ResourceProvider provider = (ResourceProvider)this.providers.remove(action.getKey());
                if (provider == null) continue;
                this.unregisterService(provider);
            }
            if (nodeAdded && nodeRemoved) {
                this.registerDataRoots();
            }
        }
        catch (RepositoryException e) {
            log.error("Unexpected repository exception during event processing.", (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isRelevantPath(String path) {
        if (path.startsWith(Constants.CONF_ROOT)) {
            if (WATCHED_PROPERTIES.stream().anyMatch(path::endsWith)) {
                return true;
            }
        }
        boolean bl = false;
        boolean isRelevant = bl;
        if (isRelevant) return true;
        if (!this.findDataRoots(this.resolver).stream().map(Resource::getPath).anyMatch(path::startsWith)) return false;
        return true;
    }

    @Reference(service=CatalogDataResourceProviderFactory.class, bind="bindFactory", unbind="unbindFactory", cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    void bindFactory(CatalogDataResourceProviderFactory factory, Map<String, String> properties) {
        log.debug("Binding provider factory {}", (Object)factory.getClass().getName());
        this.providerFactories.put(properties.get("catalogDataResourceProviderFactory"), factory);
        if (this.resolver != null) {
            this.registerDataRoots();
        }
    }

    void unbindFactory(CatalogDataResourceProviderFactory factory, Map<String, String> properties) {
        log.debug("Unbinding provider factory {}", (Object)factory.getClass().getName());
        this.providerFactories.remove(properties.get("catalogDataResourceProviderFactory"));
        if (this.resolver != null) {
            this.registerDataRoots();
        }
    }

    @Override
    public Map<String, CatalogDataResourceProviderFactory<?>> getProviderFactories() {
        HashMap ret = new HashMap();
        ret.putAll(this.providerFactories);
        return ret;
    }

    @Override
    public List<Resource> getDataRoots() {
        return this.dataRoots != null ? this.dataRoots : this.findDataRoots(this.resolver);
    }

    private void registerService(String rootPath, ResourceProvider provider) {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("service.description", "Provider of virtual catalog data resources");
        ((Dictionary)props).put("service.vendor", "Adobe");
        ((Dictionary)props).put("provider.root", new String[]{rootPath});
        ServiceRegistration registration = this.bundleContext.registerService(ResourceProvider.class, (Object)provider, props);
        this.providerRegistrations.put(provider, registration);
        log.info("Registered {}", (Object)provider);
    }

    private void unregisterService(ResourceProvider provider) {
        ServiceRegistration<?> registration = this.providerRegistrations.remove(provider);
        if (registration != null) {
            registration.unregister();
            log.info("Unregistered {}", (Object)provider);
        }
    }
}

