/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.commerce.virtual.catalog.data.impl;

import com.adobe.cq.commerce.virtual.catalog.data.Constants;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.LoginException;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.serviceusermapping.ServiceUserMapped;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={ResourceChangeListener.class}, property={"resource.paths=glob:/conf/**/*", "resource.change.types=REMOVED", "resource.change.types=ADDED"})
public class ProductBindingCreator
implements ResourceChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ProductBindingCreator.class);
    private static final String PRODUCT_BINDING_SERVICE = "product-binding-service";
    private static final String BINDINGS_PARENT_PATH = "/var/commerce/products";
    private ResourceResolver resolver;
    @Reference(target="(subServiceName=product-binding-service)")
    private ServiceUserMapped serviceUserMapped;
    @Reference
    private ResourceResolverFactory resolverFactory = null;

    protected void activate(ComponentContext context) throws LoginException {
        LOG.debug("Activating the component");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sling.service.subservice", PRODUCT_BINDING_SERVICE);
        this.resolver = this.resolverFactory.getServiceResourceResolver(map);
        LOG.debug("Do we have a resolver? {}", (Object)(this.resolver != null ? 1 : 0));
    }

    protected void deactivate() {
        this.resolver.close();
    }

    public void onChange(List<ResourceChange> list) {
        LOG.debug("Change detected somewhere...");
        list.stream().filter(change -> {
            String path = change.getPath();
            LOG.debug("Processing path {}", (Object)path);
            return !path.endsWith("jcr:content") && path.contains(Constants.COMMERCE_BUCKET_PATH);
        }).forEach(change -> {
            if (change.getType() == ResourceChange.ChangeType.ADDED) {
                this.processAddition((ResourceChange)change);
            }
            if (change.getType() == ResourceChange.ChangeType.REMOVED) {
                this.processDeletion((ResourceChange)change);
            }
        });
    }

    private void processDeletion(ResourceChange change) {
        String path = change.getPath();
        LOG.debug("Process resource deletion at path {}", (Object)path);
        Resource parent = this.resolver.getResource(BINDINGS_PARENT_PATH);
        Iterator resourceIterator = parent.listChildren();
        Stream<Resource> targetStream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(resourceIterator, 16), false);
        targetStream.filter(res -> {
            ValueMap properties = res.getValueMap();
            LOG.debug("Checking the binding at {}", (Object)res.getPath());
            String cqConf = (String)properties.get(Constants.PN_CONF, (Object)"");
            if (StringUtils.isEmpty((CharSequence)cqConf)) {
                return false;
            }
            return path.equals(cqConf + "/" + Constants.COMMERCE_BUCKET_PATH);
        }).findFirst().ifPresent(res -> {
            LOG.debug("Found a binding at {} that uses {}, we'll delete it", (Object)res.getPath(), (Object)path);
            this.deleteJcrNode((Resource)res);
        });
    }

    private void deleteJcrNode(Resource res) {
        Session session = (Session)this.resolver.adaptTo(Session.class);
        try {
            session.removeItem(res.getPath());
            session.save();
        }
        catch (RepositoryException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void processAddition(ResourceChange change) {
        this.resolver.refresh();
        String path = change.getPath();
        LOG.debug("Process resource addition at path {}", (Object)path);
        Resource changedResource = this.resolver.getResource(path);
        if (changedResource == null) {
            LOG.warn("Cannot retrieve resource at {}. Does the user have the require privileges?", (Object)path);
            return;
        }
        Resource contentResource = changedResource.getChild("jcr:content");
        ValueMap properties = contentResource != null ? contentResource.getValueMap() : changedResource.getValueMap();
        String storeView = (String)properties.get("magentoStore", (Object)"");
        if (StringUtils.isEmpty((CharSequence)storeView)) {
            LOG.warn("The configuration at path {} doesn't have a '{}' property", (Object)path, (Object)"magentoStore");
            return;
        }
        String configRoot = path.substring(0, path.indexOf(Constants.COMMERCE_BUCKET_PATH) - 1);
        String configName = configRoot.substring(configRoot.lastIndexOf("/") + 1);
        String bindingName = configName + "-" + storeView;
        LOG.debug("New binding name: {}", (Object)bindingName);
        HashMap<String, String> mappingProperties = new HashMap<String, String>();
        mappingProperties.put("jcr:primaryType", "sling:Folder");
        mappingProperties.put("jcr:title", bindingName);
        mappingProperties.put(Constants.PN_CONF, configRoot);
        Resource parent = this.resolver.getResource(BINDINGS_PARENT_PATH);
        if (parent == null) {
            LOG.warn("Binding parent path not found at {}. Nothing to do here...", (Object)BINDINGS_PARENT_PATH);
            return;
        }
        String bindingPath = parent.getPath() + "/" + bindingName;
        LOG.debug("Check if we already have a binding at {}", (Object)bindingPath);
        try {
            LOG.debug("Creating a new resource at {}", (Object)(parent.getPath() + "/" + bindingName));
            ResourceUtil.getOrCreateResource((ResourceResolver)this.resolver, (String)bindingPath, mappingProperties, (String)"", (boolean)true);
        }
        catch (PersistenceException e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }
}

