/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.graphql.support;

import com.shopify.graphql.support.CustomFieldQuery;
import com.shopify.graphql.support.CustomFieldQueryDefinition;

public abstract class AbstractQuery<T extends AbstractQuery> {
    public static final String ALIAS_SUFFIX_SEPARATOR = "__";
    private static final String BAD_ALIAS_SEPARATOR = "-";
    private static final String ALIAS_DELIMITER = ":";
    public static final String CUSTOM_FIELD_LABEL = "_custom_";
    protected final StringBuilder _queryBuilder;
    private boolean firstSelection = true;
    private String aliasSuffix = null;

    protected AbstractQuery(StringBuilder queryBuilder) {
        this._queryBuilder = queryBuilder;
    }

    public static void appendQuotedString(StringBuilder query, String string) {
        query.append('\"');
        block5: for (char c : string.toCharArray()) {
            switch (c) {
                case '\"': 
                case '\\': {
                    query.append('\\');
                    query.append(c);
                    continue block5;
                }
                case '\r': {
                    query.append("\\r");
                    continue block5;
                }
                case '\n': {
                    query.append("\\n");
                    continue block5;
                }
                default: {
                    if (c < ' ') {
                        query.append(String.format("\\u%04x", c));
                        continue block5;
                    }
                    query.append(c);
                }
            }
        }
        query.append('\"');
    }

    private void startSelection() {
        if (this.firstSelection) {
            this.firstSelection = false;
        } else {
            this._queryBuilder.append(',');
        }
    }

    protected void startInlineFragment(String typeName) {
        if (this.aliasSuffix != null) {
            throw new IllegalStateException("An alias cannot be specified on inline fragments");
        }
        this.startSelection();
        this._queryBuilder.append("... on ");
        this._queryBuilder.append(typeName);
        this._queryBuilder.append('{');
    }

    protected void startField(String fieldName) {
        this.startSelection();
        this._queryBuilder.append(fieldName);
        if (this.aliasSuffix != null) {
            this._queryBuilder.append(ALIAS_SUFFIX_SEPARATOR);
            this._queryBuilder.append(this.aliasSuffix);
            this._queryBuilder.append(ALIAS_DELIMITER);
            this._queryBuilder.append(fieldName);
            this.aliasSuffix = null;
        }
    }

    public T withAlias(String aliasSuffix) {
        if (this.aliasSuffix != null) {
            throw new IllegalStateException("Can only define a single alias for a field");
        }
        if (aliasSuffix == null || aliasSuffix.isEmpty()) {
            throw new IllegalArgumentException("Can't specify an empty alias");
        }
        if (aliasSuffix.contains(ALIAS_SUFFIX_SEPARATOR)) {
            throw new IllegalArgumentException("Alias must not contain __");
        }
        if (aliasSuffix.contains(BAD_ALIAS_SEPARATOR)) {
            throw new IllegalArgumentException("Alias must not contain -");
        }
        this.aliasSuffix = aliasSuffix;
        return (T)this;
    }

    public T addCustomSimpleField(String fieldName) {
        this.startField(fieldName + CUSTOM_FIELD_LABEL + ALIAS_DELIMITER + fieldName);
        return (T)this;
    }

    public T addCustomObjectField(String fieldName, CustomFieldQueryDefinition queryDef) {
        this.startField(fieldName + CUSTOM_FIELD_LABEL + ALIAS_DELIMITER + fieldName);
        this._queryBuilder.append('{');
        queryDef.define(new CustomFieldQuery(this._queryBuilder));
        this._queryBuilder.append('}');
        return (T)this;
    }
}

