/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.graphql.support;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopify.graphql.support.Node;
import com.shopify.graphql.support.SchemaViolationError;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;

public abstract class AbstractResponse<T extends AbstractResponse>
implements Serializable {
    public final HashMap<String, Object> responseData = new HashMap();
    public final HashMap<String, Object> optimisticData = new HashMap();
    private String aliasSuffix = null;

    public T withAlias(String aliasSuffix) {
        if (this.aliasSuffix != null) {
            throw new IllegalStateException("Can only define a single alias for a field");
        }
        if (aliasSuffix == null || aliasSuffix.isEmpty()) {
            throw new IllegalArgumentException("Can't specify an empty alias");
        }
        if (aliasSuffix.contains("__")) {
            throw new IllegalArgumentException("Alias must not contain __");
        }
        this.aliasSuffix = aliasSuffix;
        return (T)this;
    }

    public Object get(String field) {
        String key = this.getKey(field);
        if (this.optimisticData.containsKey(key)) {
            return this.optimisticData.get(key);
        }
        return this.responseData.get(key);
    }

    private <R> BiFunction<JsonElement, String, R> converterWrapper(BiFunctionWithException<JsonElement, String, R> converter) {
        return (t, u) -> {
            try {
                return converter.apply((JsonElement)t, (String)u);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    private <R> R getAs(String field, BiFunction<JsonElement, String, R> converter) {
        String key = this.getKey(field);
        if (this.optimisticData.containsKey(key)) {
            return converter.apply((JsonElement)this.optimisticData.get(key), key);
        }
        return converter.apply((JsonElement)this.responseData.get(key), key);
    }

    public String getAsString(String field) throws SchemaViolationError {
        BiFunction<JsonElement, String, String> converter = this.converterWrapper(this::jsonAsString);
        return this.getAs(field, converter);
    }

    public Integer getAsInteger(String field) throws SchemaViolationError {
        BiFunction<JsonElement, String, Integer> converter = this.converterWrapper(this::jsonAsInteger);
        return this.getAs(field, converter);
    }

    public Double getAsDouble(String field) throws SchemaViolationError {
        BiFunction<JsonElement, String, Double> converter = this.converterWrapper(this::jsonAsDouble);
        return this.getAs(field, converter);
    }

    public Boolean getAsBoolean(String field) throws SchemaViolationError {
        BiFunction<JsonElement, String, Boolean> converter = this.converterWrapper(this::jsonAsBoolean);
        return this.getAs(field, converter);
    }

    public JsonArray getAsArray(String field) throws SchemaViolationError {
        BiFunction<JsonElement, String, JsonArray> converter = this.converterWrapper(this::jsonAsArray);
        return this.getAs(field, converter);
    }

    protected void readCustomField(String fieldName, JsonElement element) throws SchemaViolationError {
        if (!fieldName.endsWith("_custom_")) {
            throw new SchemaViolationError(this, fieldName, element);
        }
        int end = fieldName.lastIndexOf("_custom_");
        this.responseData.put(fieldName.substring(0, end), element);
    }

    protected String getFieldName(String key) {
        int i = key.lastIndexOf("__");
        if (i > 1) {
            key = key.substring(0, i);
        }
        return key;
    }

    protected String getKey(String field) {
        if (this.aliasSuffix != null) {
            field = field + "__" + this.aliasSuffix;
            this.aliasSuffix = null;
        }
        return field;
    }

    protected String jsonAsString(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isString()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonPrimitive().getAsString();
    }

    protected Integer jsonAsInteger(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber() && !element.getAsJsonPrimitive().isString()) {
            throw new SchemaViolationError(this, field, element);
        }
        try {
            return element.getAsJsonPrimitive().getAsInt();
        }
        catch (NumberFormatException exc) {
            throw new SchemaViolationError(this, field, element);
        }
    }

    protected Double jsonAsDouble(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isNumber() && !element.getAsJsonPrimitive().isString()) {
            throw new SchemaViolationError(this, field, element);
        }
        try {
            return element.getAsJsonPrimitive().getAsDouble();
        }
        catch (NumberFormatException exc) {
            throw new SchemaViolationError(this, field, element);
        }
    }

    protected Boolean jsonAsBoolean(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonPrimitive() || !element.getAsJsonPrimitive().isBoolean() && !element.getAsJsonPrimitive().isString()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonPrimitive().getAsBoolean();
    }

    protected JsonObject jsonAsObject(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonObject()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonObject();
    }

    protected JsonArray jsonAsArray(JsonElement element, String field) throws SchemaViolationError {
        if (!element.isJsonArray()) {
            throw new SchemaViolationError(this, field, element);
        }
        return element.getAsJsonArray();
    }

    public List<Node> collectNodes() {
        ArrayList<Node> children = new ArrayList<Node>();
        AbstractResponse.collectNodes(this, children);
        return children;
    }

    private static void collectNodes(Object o, List<Node> collection) {
        block4: {
            block3: {
                if (!(o instanceof AbstractResponse)) break block3;
                AbstractResponse response = (AbstractResponse)o;
                if (response instanceof Node) {
                    collection.add((Node)((Object)response));
                }
                for (String key : response.responseData.keySet()) {
                    AbstractResponse.collectNodes(response.get(key), collection);
                }
                break block4;
            }
            if (!(o instanceof List)) break block4;
            for (Object element : (List)o) {
                AbstractResponse.collectNodes(element, collection);
            }
        }
    }

    public abstract boolean unwrapsToObject(String var1);

    @FunctionalInterface
    private static interface BiFunctionWithException<T, U, R> {
        public R apply(T var1, U var2) throws SchemaViolationError;
    }
}

