/*
 * Decompiled with CFR 0.152.
 */
package com.shopify.graphql.support;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopify.graphql.support.Error;
import com.shopify.graphql.support.InvalidGraphQLException;
import java.util.ArrayList;
import java.util.List;

public class TopLevelResponse {
    private static final String DATA_KEY = "data";
    private static final String ERRORS_KEY = "errors";
    private JsonObject data = null;
    private final List<Error> errors = new ArrayList<Error>();

    public TopLevelResponse(JsonObject fields) throws InvalidGraphQLException {
        JsonElement errorsElement = fields.get(ERRORS_KEY);
        JsonElement dataElement = fields.get(DATA_KEY);
        if (dataElement != null && dataElement.isJsonNull()) {
            dataElement = null;
        }
        if (errorsElement == null && dataElement == null) {
            throw new InvalidGraphQLException("Response must contain a top-level 'data' or 'errors' entry");
        }
        if (dataElement != null) {
            if (!dataElement.isJsonObject()) {
                throw new InvalidGraphQLException("'data' entry in response must be a map");
            }
            this.data = dataElement.getAsJsonObject();
        }
        if (errorsElement != null) {
            if (!errorsElement.isJsonArray()) {
                throw new InvalidGraphQLException("'errors' entry in response must be an array");
            }
            for (JsonElement error : errorsElement.getAsJsonArray()) {
                this.errors.add(new Error(error.isJsonObject() ? error.getAsJsonObject() : new JsonObject()));
            }
        }
    }

    public JsonObject getData() {
        return this.data;
    }

    public List<Error> getErrors() {
        return this.errors;
    }
}

