/*******************************************************************************
 *
 *    Copyright 2020 Adobe. All rights reserved.
 *    This file is licensed to you under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License. You may obtain a copy
 *    of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software distributed under
 *    the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 *    OF ANY KIND, either express or implied. See the License for the specific language
 *    governing permissions and limitations under the License.
 *
 ******************************************************************************/

package com.adobe.cq.commerce.magento.graphql;

import java.util.Map;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.shopify.graphql.support.AbstractResponse;
import com.shopify.graphql.support.ID;
import com.shopify.graphql.support.SchemaViolationError;

/**
 * ConfigurableAttributeOption contains the value_index (and other related information) assigned to a
 * configurable product option
 */
public class ConfigurableAttributeOption extends AbstractResponse<ConfigurableAttributeOption> {
    public ConfigurableAttributeOption() {}

    public ConfigurableAttributeOption(JsonObject fields) throws SchemaViolationError {
        for (Map.Entry<String, JsonElement> field : fields.entrySet()) {
            String key = field.getKey();
            String fieldName = getFieldName(key);
            switch (fieldName) {
                case "code": {
                    String optional1 = null;
                    if (!field.getValue().isJsonNull()) {
                        optional1 = jsonAsString(field.getValue(), key);
                    }

                    responseData.put(key, optional1);

                    break;
                }

                case "label": {
                    String optional1 = null;
                    if (!field.getValue().isJsonNull()) {
                        optional1 = jsonAsString(field.getValue(), key);
                    }

                    responseData.put(key, optional1);

                    break;
                }

                case "uid": {
                    responseData.put(key, new ID(jsonAsString(field.getValue(), key)));

                    break;
                }

                case "value_index": {
                    Integer optional1 = null;
                    if (!field.getValue().isJsonNull()) {
                        optional1 = jsonAsInteger(field.getValue(), key);
                    }

                    responseData.put(key, optional1);

                    break;
                }

                case "__typename": {
                    responseData.put(key, jsonAsString(field.getValue(), key));
                    break;
                }

                default: {
                    readCustomField(fieldName, field.getValue());
                }
            }
        }
    }

    public String getGraphQlTypeName() {
        return "ConfigurableAttributeOption";
    }

    /**
     * The ID assigned to the attribute
     */
    public String getCode() {
        return (String) get("code");
    }

    public ConfigurableAttributeOption setCode(String arg) {
        optimisticData.put(getKey("code"), arg);
        return this;
    }

    /**
     * A string that describes the configurable attribute option
     */
    public String getLabel() {
        return (String) get("label");
    }

    public ConfigurableAttributeOption setLabel(String arg) {
        optimisticData.put(getKey("label"), arg);
        return this;
    }

    /**
     * The unique ID for a `ConfigurableAttributeOption` object
     */
    public ID getUid() {
        return (ID) get("uid");
    }

    public ConfigurableAttributeOption setUid(ID arg) {
        optimisticData.put(getKey("uid"), arg);
        return this;
    }

    /**
     * A unique index number assigned to the configurable product option
     */
    public Integer getValueIndex() {
        return (Integer) get("value_index");
    }

    public ConfigurableAttributeOption setValueIndex(Integer arg) {
        optimisticData.put(getKey("value_index"), arg);
        return this;
    }

    public boolean unwrapsToObject(String key) {
        switch (getFieldName(key)) {
            case "code":
                return false;

            case "label":
                return false;

            case "uid":
                return false;

            case "value_index":
                return false;

            default:
                return false;
        }
    }
}
