/*******************************************************************************
 *
 *    Copyright 2020 Adobe. All rights reserved.
 *    This file is licensed to you under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License. You may obtain a copy
 *    of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software distributed under
 *    the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 *    OF ANY KIND, either express or implied. See the License for the specific language
 *    governing permissions and limitations under the License.
 *
 ******************************************************************************/

package com.adobe.cq.commerce.magento.graphql;

/**
 * The list of countries codes
 */
public enum CountryCodeEnum {
    /**
     * Andorra
     */
    AD,

    /**
     * United Arab Emirates
     */
    AE,

    /**
     * Afghanistan
     */
    AF,

    /**
     * Antigua &amp; Barbuda
     */
    AG,

    /**
     * Anguilla
     */
    AI,

    /**
     * Albania
     */
    AL,

    /**
     * Armenia
     */
    AM,

    /**
     * Netherlands Antilles
     */
    AN,

    /**
     * Angola
     */
    AO,

    /**
     * Antarctica
     */
    AQ,

    /**
     * Argentina
     */
    AR,

    /**
     * American Samoa
     */
    AS,

    /**
     * Austria
     */
    AT,

    /**
     * Australia
     */
    AU,

    /**
     * Aruba
     */
    AW,

    /**
     * Åland Islands
     */
    AX,

    /**
     * Azerbaijan
     */
    AZ,

    /**
     * Bosnia &amp; Herzegovina
     */
    BA,

    /**
     * Barbados
     */
    BB,

    /**
     * Bangladesh
     */
    BD,

    /**
     * Belgium
     */
    BE,

    /**
     * Burkina Faso
     */
    BF,

    /**
     * Bulgaria
     */
    BG,

    /**
     * Bahrain
     */
    BH,

    /**
     * Burundi
     */
    BI,

    /**
     * Benin
     */
    BJ,

    /**
     * St. Barthélemy
     */
    BL,

    /**
     * Bermuda
     */
    BM,

    /**
     * Brunei
     */
    BN,

    /**
     * Bolivia
     */
    BO,

    /**
     * Brazil
     */
    BR,

    /**
     * Bahamas
     */
    BS,

    /**
     * Bhutan
     */
    BT,

    /**
     * Bouvet Island
     */
    BV,

    /**
     * Botswana
     */
    BW,

    /**
     * Belarus
     */
    BY,

    /**
     * Belize
     */
    BZ,

    /**
     * Canada
     */
    CA,

    /**
     * Cocos (Keeling) Islands
     */
    CC,

    /**
     * Congo-Kinshasa
     */
    CD,

    /**
     * Central African Republic
     */
    CF,

    /**
     * Congo-Brazzaville
     */
    CG,

    /**
     * Switzerland
     */
    CH,

    /**
     * Côte d’Ivoire
     */
    CI,

    /**
     * Cook Islands
     */
    CK,

    /**
     * Chile
     */
    CL,

    /**
     * Cameroon
     */
    CM,

    /**
     * China
     */
    CN,

    /**
     * Colombia
     */
    CO,

    /**
     * Costa Rica
     */
    CR,

    /**
     * Cuba
     */
    CU,

    /**
     * Cape Verde
     */
    CV,

    /**
     * Christmas Island
     */
    CX,

    /**
     * Cyprus
     */
    CY,

    /**
     * Czech Republic
     */
    CZ,

    /**
     * Germany
     */
    DE,

    /**
     * Djibouti
     */
    DJ,

    /**
     * Denmark
     */
    DK,

    /**
     * Dominica
     */
    DM,

    /**
     * Dominican Republic
     */
    DO,

    /**
     * Algeria
     */
    DZ,

    /**
     * Ecuador
     */
    EC,

    /**
     * Estonia
     */
    EE,

    /**
     * Egypt
     */
    EG,

    /**
     * Western Sahara
     */
    EH,

    /**
     * Eritrea
     */
    ER,

    /**
     * Spain
     */
    ES,

    /**
     * Ethiopia
     */
    ET,

    /**
     * Finland
     */
    FI,

    /**
     * Fiji
     */
    FJ,

    /**
     * Falkland Islands
     */
    FK,

    /**
     * Micronesia
     */
    FM,

    /**
     * Faroe Islands
     */
    FO,

    /**
     * France
     */
    FR,

    /**
     * Gabon
     */
    GA,

    /**
     * United Kingdom
     */
    GB,

    /**
     * Grenada
     */
    GD,

    /**
     * Georgia
     */
    GE,

    /**
     * French Guiana
     */
    GF,

    /**
     * Guernsey
     */
    GG,

    /**
     * Ghana
     */
    GH,

    /**
     * Gibraltar
     */
    GI,

    /**
     * Greenland
     */
    GL,

    /**
     * Gambia
     */
    GM,

    /**
     * Guinea
     */
    GN,

    /**
     * Guadeloupe
     */
    GP,

    /**
     * Equatorial Guinea
     */
    GQ,

    /**
     * Greece
     */
    GR,

    /**
     * South Georgia &amp; South Sandwich Islands
     */
    GS,

    /**
     * Guatemala
     */
    GT,

    /**
     * Guam
     */
    GU,

    /**
     * Guinea-Bissau
     */
    GW,

    /**
     * Guyana
     */
    GY,

    /**
     * Hong Kong SAR China
     */
    HK,

    /**
     * Heard &amp;amp; McDonald Islands
     */
    HM,

    /**
     * Honduras
     */
    HN,

    /**
     * Croatia
     */
    HR,

    /**
     * Haiti
     */
    HT,

    /**
     * Hungary
     */
    HU,

    /**
     * Indonesia
     */
    ID,

    /**
     * Ireland
     */
    IE,

    /**
     * Israel
     */
    IL,

    /**
     * Isle of Man
     */
    IM,

    /**
     * India
     */
    IN,

    /**
     * British Indian Ocean Territory
     */
    IO,

    /**
     * Iraq
     */
    IQ,

    /**
     * Iran
     */
    IR,

    /**
     * Iceland
     */
    IS,

    /**
     * Italy
     */
    IT,

    /**
     * Jersey
     */
    JE,

    /**
     * Jamaica
     */
    JM,

    /**
     * Jordan
     */
    JO,

    /**
     * Japan
     */
    JP,

    /**
     * Kenya
     */
    KE,

    /**
     * Kyrgyzstan
     */
    KG,

    /**
     * Cambodia
     */
    KH,

    /**
     * Kiribati
     */
    KI,

    /**
     * Comoros
     */
    KM,

    /**
     * St. Kitts &amp; Nevis
     */
    KN,

    /**
     * North Korea
     */
    KP,

    /**
     * South Korea
     */
    KR,

    /**
     * Kuwait
     */
    KW,

    /**
     * Cayman Islands
     */
    KY,

    /**
     * Kazakhstan
     */
    KZ,

    /**
     * Laos
     */
    LA,

    /**
     * Lebanon
     */
    LB,

    /**
     * St. Lucia
     */
    LC,

    /**
     * Liechtenstein
     */
    LI,

    /**
     * Sri Lanka
     */
    LK,

    /**
     * Liberia
     */
    LR,

    /**
     * Lesotho
     */
    LS,

    /**
     * Lithuania
     */
    LT,

    /**
     * Luxembourg
     */
    LU,

    /**
     * Latvia
     */
    LV,

    /**
     * Libya
     */
    LY,

    /**
     * Morocco
     */
    MA,

    /**
     * Monaco
     */
    MC,

    /**
     * Moldova
     */
    MD,

    /**
     * Montenegro
     */
    ME,

    /**
     * St. Martin
     */
    MF,

    /**
     * Madagascar
     */
    MG,

    /**
     * Marshall Islands
     */
    MH,

    /**
     * Macedonia
     */
    MK,

    /**
     * Mali
     */
    ML,

    /**
     * Myanmar (Burma)
     */
    MM,

    /**
     * Mongolia
     */
    MN,

    /**
     * Macau SAR China
     */
    MO,

    /**
     * Northern Mariana Islands
     */
    MP,

    /**
     * Martinique
     */
    MQ,

    /**
     * Mauritania
     */
    MR,

    /**
     * Montserrat
     */
    MS,

    /**
     * Malta
     */
    MT,

    /**
     * Mauritius
     */
    MU,

    /**
     * Maldives
     */
    MV,

    /**
     * Malawi
     */
    MW,

    /**
     * Mexico
     */
    MX,

    /**
     * Malaysia
     */
    MY,

    /**
     * Mozambique
     */
    MZ,

    /**
     * Namibia
     */
    NA,

    /**
     * New Caledonia
     */
    NC,

    /**
     * Niger
     */
    NE,

    /**
     * Norfolk Island
     */
    NF,

    /**
     * Nigeria
     */
    NG,

    /**
     * Nicaragua
     */
    NI,

    /**
     * Netherlands
     */
    NL,

    /**
     * Norway
     */
    NO,

    /**
     * Nepal
     */
    NP,

    /**
     * Nauru
     */
    NR,

    /**
     * Niue
     */
    NU,

    /**
     * New Zealand
     */
    NZ,

    /**
     * Oman
     */
    OM,

    /**
     * Panama
     */
    PA,

    /**
     * Peru
     */
    PE,

    /**
     * French Polynesia
     */
    PF,

    /**
     * Papua New Guinea
     */
    PG,

    /**
     * Philippines
     */
    PH,

    /**
     * Pakistan
     */
    PK,

    /**
     * Poland
     */
    PL,

    /**
     * St. Pierre &amp; Miquelon
     */
    PM,

    /**
     * Pitcairn Islands
     */
    PN,

    /**
     * Palestinian Territories
     */
    PS,

    /**
     * Portugal
     */
    PT,

    /**
     * Palau
     */
    PW,

    /**
     * Paraguay
     */
    PY,

    /**
     * Qatar
     */
    QA,

    /**
     * Réunion
     */
    RE,

    /**
     * Romania
     */
    RO,

    /**
     * Serbia
     */
    RS,

    /**
     * Russia
     */
    RU,

    /**
     * Rwanda
     */
    RW,

    /**
     * Saudi Arabia
     */
    SA,

    /**
     * Solomon Islands
     */
    SB,

    /**
     * Seychelles
     */
    SC,

    /**
     * Sudan
     */
    SD,

    /**
     * Sweden
     */
    SE,

    /**
     * Singapore
     */
    SG,

    /**
     * St. Helena
     */
    SH,

    /**
     * Slovenia
     */
    SI,

    /**
     * Svalbard &amp; Jan Mayen
     */
    SJ,

    /**
     * Slovakia
     */
    SK,

    /**
     * Sierra Leone
     */
    SL,

    /**
     * San Marino
     */
    SM,

    /**
     * Senegal
     */
    SN,

    /**
     * Somalia
     */
    SO,

    /**
     * Suriname
     */
    SR,

    /**
     * São Tomé &amp; Príncipe
     */
    ST,

    /**
     * El Salvador
     */
    SV,

    /**
     * Syria
     */
    SY,

    /**
     * Swaziland
     */
    SZ,

    /**
     * Turks &amp; Caicos Islands
     */
    TC,

    /**
     * Chad
     */
    TD,

    /**
     * French Southern Territories
     */
    TF,

    /**
     * Togo
     */
    TG,

    /**
     * Thailand
     */
    TH,

    /**
     * Tajikistan
     */
    TJ,

    /**
     * Tokelau
     */
    TK,

    /**
     * Timor-Leste
     */
    TL,

    /**
     * Turkmenistan
     */
    TM,

    /**
     * Tunisia
     */
    TN,

    /**
     * Tonga
     */
    TO,

    /**
     * Turkey
     */
    TR,

    /**
     * Trinidad &amp; Tobago
     */
    TT,

    /**
     * Tuvalu
     */
    TV,

    /**
     * Taiwan
     */
    TW,

    /**
     * Tanzania
     */
    TZ,

    /**
     * Ukraine
     */
    UA,

    /**
     * Uganda
     */
    UG,

    /**
     * U.S. Outlying Islands
     */
    UM,

    /**
     * United States
     */
    US,

    /**
     * Uruguay
     */
    UY,

    /**
     * Uzbekistan
     */
    UZ,

    /**
     * Vatican City
     */
    VA,

    /**
     * St. Vincent &amp; Grenadines
     */
    VC,

    /**
     * Venezuela
     */
    VE,

    /**
     * British Virgin Islands
     */
    VG,

    /**
     * U.S. Virgin Islands
     */
    VI,

    /**
     * Vietnam
     */
    VN,

    /**
     * Vanuatu
     */
    VU,

    /**
     * Wallis &amp; Futuna
     */
    WF,

    /**
     * Samoa
     */
    WS,

    /**
     * Yemen
     */
    YE,

    /**
     * Mayotte
     */
    YT,

    /**
     * South Africa
     */
    ZA,

    /**
     * Zambia
     */
    ZM,

    /**
     * Zimbabwe
     */
    ZW,

    UNKNOWN_VALUE;

    public static CountryCodeEnum fromGraphQl(String value) {
        if (value == null) {
            return null;
        }

        switch (value) {
            case "AD": {
                return AD;
            }

            case "AE": {
                return AE;
            }

            case "AF": {
                return AF;
            }

            case "AG": {
                return AG;
            }

            case "AI": {
                return AI;
            }

            case "AL": {
                return AL;
            }

            case "AM": {
                return AM;
            }

            case "AN": {
                return AN;
            }

            case "AO": {
                return AO;
            }

            case "AQ": {
                return AQ;
            }

            case "AR": {
                return AR;
            }

            case "AS": {
                return AS;
            }

            case "AT": {
                return AT;
            }

            case "AU": {
                return AU;
            }

            case "AW": {
                return AW;
            }

            case "AX": {
                return AX;
            }

            case "AZ": {
                return AZ;
            }

            case "BA": {
                return BA;
            }

            case "BB": {
                return BB;
            }

            case "BD": {
                return BD;
            }

            case "BE": {
                return BE;
            }

            case "BF": {
                return BF;
            }

            case "BG": {
                return BG;
            }

            case "BH": {
                return BH;
            }

            case "BI": {
                return BI;
            }

            case "BJ": {
                return BJ;
            }

            case "BL": {
                return BL;
            }

            case "BM": {
                return BM;
            }

            case "BN": {
                return BN;
            }

            case "BO": {
                return BO;
            }

            case "BR": {
                return BR;
            }

            case "BS": {
                return BS;
            }

            case "BT": {
                return BT;
            }

            case "BV": {
                return BV;
            }

            case "BW": {
                return BW;
            }

            case "BY": {
                return BY;
            }

            case "BZ": {
                return BZ;
            }

            case "CA": {
                return CA;
            }

            case "CC": {
                return CC;
            }

            case "CD": {
                return CD;
            }

            case "CF": {
                return CF;
            }

            case "CG": {
                return CG;
            }

            case "CH": {
                return CH;
            }

            case "CI": {
                return CI;
            }

            case "CK": {
                return CK;
            }

            case "CL": {
                return CL;
            }

            case "CM": {
                return CM;
            }

            case "CN": {
                return CN;
            }

            case "CO": {
                return CO;
            }

            case "CR": {
                return CR;
            }

            case "CU": {
                return CU;
            }

            case "CV": {
                return CV;
            }

            case "CX": {
                return CX;
            }

            case "CY": {
                return CY;
            }

            case "CZ": {
                return CZ;
            }

            case "DE": {
                return DE;
            }

            case "DJ": {
                return DJ;
            }

            case "DK": {
                return DK;
            }

            case "DM": {
                return DM;
            }

            case "DO": {
                return DO;
            }

            case "DZ": {
                return DZ;
            }

            case "EC": {
                return EC;
            }

            case "EE": {
                return EE;
            }

            case "EG": {
                return EG;
            }

            case "EH": {
                return EH;
            }

            case "ER": {
                return ER;
            }

            case "ES": {
                return ES;
            }

            case "ET": {
                return ET;
            }

            case "FI": {
                return FI;
            }

            case "FJ": {
                return FJ;
            }

            case "FK": {
                return FK;
            }

            case "FM": {
                return FM;
            }

            case "FO": {
                return FO;
            }

            case "FR": {
                return FR;
            }

            case "GA": {
                return GA;
            }

            case "GB": {
                return GB;
            }

            case "GD": {
                return GD;
            }

            case "GE": {
                return GE;
            }

            case "GF": {
                return GF;
            }

            case "GG": {
                return GG;
            }

            case "GH": {
                return GH;
            }

            case "GI": {
                return GI;
            }

            case "GL": {
                return GL;
            }

            case "GM": {
                return GM;
            }

            case "GN": {
                return GN;
            }

            case "GP": {
                return GP;
            }

            case "GQ": {
                return GQ;
            }

            case "GR": {
                return GR;
            }

            case "GS": {
                return GS;
            }

            case "GT": {
                return GT;
            }

            case "GU": {
                return GU;
            }

            case "GW": {
                return GW;
            }

            case "GY": {
                return GY;
            }

            case "HK": {
                return HK;
            }

            case "HM": {
                return HM;
            }

            case "HN": {
                return HN;
            }

            case "HR": {
                return HR;
            }

            case "HT": {
                return HT;
            }

            case "HU": {
                return HU;
            }

            case "ID": {
                return ID;
            }

            case "IE": {
                return IE;
            }

            case "IL": {
                return IL;
            }

            case "IM": {
                return IM;
            }

            case "IN": {
                return IN;
            }

            case "IO": {
                return IO;
            }

            case "IQ": {
                return IQ;
            }

            case "IR": {
                return IR;
            }

            case "IS": {
                return IS;
            }

            case "IT": {
                return IT;
            }

            case "JE": {
                return JE;
            }

            case "JM": {
                return JM;
            }

            case "JO": {
                return JO;
            }

            case "JP": {
                return JP;
            }

            case "KE": {
                return KE;
            }

            case "KG": {
                return KG;
            }

            case "KH": {
                return KH;
            }

            case "KI": {
                return KI;
            }

            case "KM": {
                return KM;
            }

            case "KN": {
                return KN;
            }

            case "KP": {
                return KP;
            }

            case "KR": {
                return KR;
            }

            case "KW": {
                return KW;
            }

            case "KY": {
                return KY;
            }

            case "KZ": {
                return KZ;
            }

            case "LA": {
                return LA;
            }

            case "LB": {
                return LB;
            }

            case "LC": {
                return LC;
            }

            case "LI": {
                return LI;
            }

            case "LK": {
                return LK;
            }

            case "LR": {
                return LR;
            }

            case "LS": {
                return LS;
            }

            case "LT": {
                return LT;
            }

            case "LU": {
                return LU;
            }

            case "LV": {
                return LV;
            }

            case "LY": {
                return LY;
            }

            case "MA": {
                return MA;
            }

            case "MC": {
                return MC;
            }

            case "MD": {
                return MD;
            }

            case "ME": {
                return ME;
            }

            case "MF": {
                return MF;
            }

            case "MG": {
                return MG;
            }

            case "MH": {
                return MH;
            }

            case "MK": {
                return MK;
            }

            case "ML": {
                return ML;
            }

            case "MM": {
                return MM;
            }

            case "MN": {
                return MN;
            }

            case "MO": {
                return MO;
            }

            case "MP": {
                return MP;
            }

            case "MQ": {
                return MQ;
            }

            case "MR": {
                return MR;
            }

            case "MS": {
                return MS;
            }

            case "MT": {
                return MT;
            }

            case "MU": {
                return MU;
            }

            case "MV": {
                return MV;
            }

            case "MW": {
                return MW;
            }

            case "MX": {
                return MX;
            }

            case "MY": {
                return MY;
            }

            case "MZ": {
                return MZ;
            }

            case "NA": {
                return NA;
            }

            case "NC": {
                return NC;
            }

            case "NE": {
                return NE;
            }

            case "NF": {
                return NF;
            }

            case "NG": {
                return NG;
            }

            case "NI": {
                return NI;
            }

            case "NL": {
                return NL;
            }

            case "NO": {
                return NO;
            }

            case "NP": {
                return NP;
            }

            case "NR": {
                return NR;
            }

            case "NU": {
                return NU;
            }

            case "NZ": {
                return NZ;
            }

            case "OM": {
                return OM;
            }

            case "PA": {
                return PA;
            }

            case "PE": {
                return PE;
            }

            case "PF": {
                return PF;
            }

            case "PG": {
                return PG;
            }

            case "PH": {
                return PH;
            }

            case "PK": {
                return PK;
            }

            case "PL": {
                return PL;
            }

            case "PM": {
                return PM;
            }

            case "PN": {
                return PN;
            }

            case "PS": {
                return PS;
            }

            case "PT": {
                return PT;
            }

            case "PW": {
                return PW;
            }

            case "PY": {
                return PY;
            }

            case "QA": {
                return QA;
            }

            case "RE": {
                return RE;
            }

            case "RO": {
                return RO;
            }

            case "RS": {
                return RS;
            }

            case "RU": {
                return RU;
            }

            case "RW": {
                return RW;
            }

            case "SA": {
                return SA;
            }

            case "SB": {
                return SB;
            }

            case "SC": {
                return SC;
            }

            case "SD": {
                return SD;
            }

            case "SE": {
                return SE;
            }

            case "SG": {
                return SG;
            }

            case "SH": {
                return SH;
            }

            case "SI": {
                return SI;
            }

            case "SJ": {
                return SJ;
            }

            case "SK": {
                return SK;
            }

            case "SL": {
                return SL;
            }

            case "SM": {
                return SM;
            }

            case "SN": {
                return SN;
            }

            case "SO": {
                return SO;
            }

            case "SR": {
                return SR;
            }

            case "ST": {
                return ST;
            }

            case "SV": {
                return SV;
            }

            case "SY": {
                return SY;
            }

            case "SZ": {
                return SZ;
            }

            case "TC": {
                return TC;
            }

            case "TD": {
                return TD;
            }

            case "TF": {
                return TF;
            }

            case "TG": {
                return TG;
            }

            case "TH": {
                return TH;
            }

            case "TJ": {
                return TJ;
            }

            case "TK": {
                return TK;
            }

            case "TL": {
                return TL;
            }

            case "TM": {
                return TM;
            }

            case "TN": {
                return TN;
            }

            case "TO": {
                return TO;
            }

            case "TR": {
                return TR;
            }

            case "TT": {
                return TT;
            }

            case "TV": {
                return TV;
            }

            case "TW": {
                return TW;
            }

            case "TZ": {
                return TZ;
            }

            case "UA": {
                return UA;
            }

            case "UG": {
                return UG;
            }

            case "UM": {
                return UM;
            }

            case "US": {
                return US;
            }

            case "UY": {
                return UY;
            }

            case "UZ": {
                return UZ;
            }

            case "VA": {
                return VA;
            }

            case "VC": {
                return VC;
            }

            case "VE": {
                return VE;
            }

            case "VG": {
                return VG;
            }

            case "VI": {
                return VI;
            }

            case "VN": {
                return VN;
            }

            case "VU": {
                return VU;
            }

            case "WF": {
                return WF;
            }

            case "WS": {
                return WS;
            }

            case "YE": {
                return YE;
            }

            case "YT": {
                return YT;
            }

            case "ZA": {
                return ZA;
            }

            case "ZM": {
                return ZM;
            }

            case "ZW": {
                return ZW;
            }

            default: {
                return UNKNOWN_VALUE;
            }
        }
    }

    public String toString() {
        switch (this) {
            case AD: {
                return "AD";
            }

            case AE: {
                return "AE";
            }

            case AF: {
                return "AF";
            }

            case AG: {
                return "AG";
            }

            case AI: {
                return "AI";
            }

            case AL: {
                return "AL";
            }

            case AM: {
                return "AM";
            }

            case AN: {
                return "AN";
            }

            case AO: {
                return "AO";
            }

            case AQ: {
                return "AQ";
            }

            case AR: {
                return "AR";
            }

            case AS: {
                return "AS";
            }

            case AT: {
                return "AT";
            }

            case AU: {
                return "AU";
            }

            case AW: {
                return "AW";
            }

            case AX: {
                return "AX";
            }

            case AZ: {
                return "AZ";
            }

            case BA: {
                return "BA";
            }

            case BB: {
                return "BB";
            }

            case BD: {
                return "BD";
            }

            case BE: {
                return "BE";
            }

            case BF: {
                return "BF";
            }

            case BG: {
                return "BG";
            }

            case BH: {
                return "BH";
            }

            case BI: {
                return "BI";
            }

            case BJ: {
                return "BJ";
            }

            case BL: {
                return "BL";
            }

            case BM: {
                return "BM";
            }

            case BN: {
                return "BN";
            }

            case BO: {
                return "BO";
            }

            case BR: {
                return "BR";
            }

            case BS: {
                return "BS";
            }

            case BT: {
                return "BT";
            }

            case BV: {
                return "BV";
            }

            case BW: {
                return "BW";
            }

            case BY: {
                return "BY";
            }

            case BZ: {
                return "BZ";
            }

            case CA: {
                return "CA";
            }

            case CC: {
                return "CC";
            }

            case CD: {
                return "CD";
            }

            case CF: {
                return "CF";
            }

            case CG: {
                return "CG";
            }

            case CH: {
                return "CH";
            }

            case CI: {
                return "CI";
            }

            case CK: {
                return "CK";
            }

            case CL: {
                return "CL";
            }

            case CM: {
                return "CM";
            }

            case CN: {
                return "CN";
            }

            case CO: {
                return "CO";
            }

            case CR: {
                return "CR";
            }

            case CU: {
                return "CU";
            }

            case CV: {
                return "CV";
            }

            case CX: {
                return "CX";
            }

            case CY: {
                return "CY";
            }

            case CZ: {
                return "CZ";
            }

            case DE: {
                return "DE";
            }

            case DJ: {
                return "DJ";
            }

            case DK: {
                return "DK";
            }

            case DM: {
                return "DM";
            }

            case DO: {
                return "DO";
            }

            case DZ: {
                return "DZ";
            }

            case EC: {
                return "EC";
            }

            case EE: {
                return "EE";
            }

            case EG: {
                return "EG";
            }

            case EH: {
                return "EH";
            }

            case ER: {
                return "ER";
            }

            case ES: {
                return "ES";
            }

            case ET: {
                return "ET";
            }

            case FI: {
                return "FI";
            }

            case FJ: {
                return "FJ";
            }

            case FK: {
                return "FK";
            }

            case FM: {
                return "FM";
            }

            case FO: {
                return "FO";
            }

            case FR: {
                return "FR";
            }

            case GA: {
                return "GA";
            }

            case GB: {
                return "GB";
            }

            case GD: {
                return "GD";
            }

            case GE: {
                return "GE";
            }

            case GF: {
                return "GF";
            }

            case GG: {
                return "GG";
            }

            case GH: {
                return "GH";
            }

            case GI: {
                return "GI";
            }

            case GL: {
                return "GL";
            }

            case GM: {
                return "GM";
            }

            case GN: {
                return "GN";
            }

            case GP: {
                return "GP";
            }

            case GQ: {
                return "GQ";
            }

            case GR: {
                return "GR";
            }

            case GS: {
                return "GS";
            }

            case GT: {
                return "GT";
            }

            case GU: {
                return "GU";
            }

            case GW: {
                return "GW";
            }

            case GY: {
                return "GY";
            }

            case HK: {
                return "HK";
            }

            case HM: {
                return "HM";
            }

            case HN: {
                return "HN";
            }

            case HR: {
                return "HR";
            }

            case HT: {
                return "HT";
            }

            case HU: {
                return "HU";
            }

            case ID: {
                return "ID";
            }

            case IE: {
                return "IE";
            }

            case IL: {
                return "IL";
            }

            case IM: {
                return "IM";
            }

            case IN: {
                return "IN";
            }

            case IO: {
                return "IO";
            }

            case IQ: {
                return "IQ";
            }

            case IR: {
                return "IR";
            }

            case IS: {
                return "IS";
            }

            case IT: {
                return "IT";
            }

            case JE: {
                return "JE";
            }

            case JM: {
                return "JM";
            }

            case JO: {
                return "JO";
            }

            case JP: {
                return "JP";
            }

            case KE: {
                return "KE";
            }

            case KG: {
                return "KG";
            }

            case KH: {
                return "KH";
            }

            case KI: {
                return "KI";
            }

            case KM: {
                return "KM";
            }

            case KN: {
                return "KN";
            }

            case KP: {
                return "KP";
            }

            case KR: {
                return "KR";
            }

            case KW: {
                return "KW";
            }

            case KY: {
                return "KY";
            }

            case KZ: {
                return "KZ";
            }

            case LA: {
                return "LA";
            }

            case LB: {
                return "LB";
            }

            case LC: {
                return "LC";
            }

            case LI: {
                return "LI";
            }

            case LK: {
                return "LK";
            }

            case LR: {
                return "LR";
            }

            case LS: {
                return "LS";
            }

            case LT: {
                return "LT";
            }

            case LU: {
                return "LU";
            }

            case LV: {
                return "LV";
            }

            case LY: {
                return "LY";
            }

            case MA: {
                return "MA";
            }

            case MC: {
                return "MC";
            }

            case MD: {
                return "MD";
            }

            case ME: {
                return "ME";
            }

            case MF: {
                return "MF";
            }

            case MG: {
                return "MG";
            }

            case MH: {
                return "MH";
            }

            case MK: {
                return "MK";
            }

            case ML: {
                return "ML";
            }

            case MM: {
                return "MM";
            }

            case MN: {
                return "MN";
            }

            case MO: {
                return "MO";
            }

            case MP: {
                return "MP";
            }

            case MQ: {
                return "MQ";
            }

            case MR: {
                return "MR";
            }

            case MS: {
                return "MS";
            }

            case MT: {
                return "MT";
            }

            case MU: {
                return "MU";
            }

            case MV: {
                return "MV";
            }

            case MW: {
                return "MW";
            }

            case MX: {
                return "MX";
            }

            case MY: {
                return "MY";
            }

            case MZ: {
                return "MZ";
            }

            case NA: {
                return "NA";
            }

            case NC: {
                return "NC";
            }

            case NE: {
                return "NE";
            }

            case NF: {
                return "NF";
            }

            case NG: {
                return "NG";
            }

            case NI: {
                return "NI";
            }

            case NL: {
                return "NL";
            }

            case NO: {
                return "NO";
            }

            case NP: {
                return "NP";
            }

            case NR: {
                return "NR";
            }

            case NU: {
                return "NU";
            }

            case NZ: {
                return "NZ";
            }

            case OM: {
                return "OM";
            }

            case PA: {
                return "PA";
            }

            case PE: {
                return "PE";
            }

            case PF: {
                return "PF";
            }

            case PG: {
                return "PG";
            }

            case PH: {
                return "PH";
            }

            case PK: {
                return "PK";
            }

            case PL: {
                return "PL";
            }

            case PM: {
                return "PM";
            }

            case PN: {
                return "PN";
            }

            case PS: {
                return "PS";
            }

            case PT: {
                return "PT";
            }

            case PW: {
                return "PW";
            }

            case PY: {
                return "PY";
            }

            case QA: {
                return "QA";
            }

            case RE: {
                return "RE";
            }

            case RO: {
                return "RO";
            }

            case RS: {
                return "RS";
            }

            case RU: {
                return "RU";
            }

            case RW: {
                return "RW";
            }

            case SA: {
                return "SA";
            }

            case SB: {
                return "SB";
            }

            case SC: {
                return "SC";
            }

            case SD: {
                return "SD";
            }

            case SE: {
                return "SE";
            }

            case SG: {
                return "SG";
            }

            case SH: {
                return "SH";
            }

            case SI: {
                return "SI";
            }

            case SJ: {
                return "SJ";
            }

            case SK: {
                return "SK";
            }

            case SL: {
                return "SL";
            }

            case SM: {
                return "SM";
            }

            case SN: {
                return "SN";
            }

            case SO: {
                return "SO";
            }

            case SR: {
                return "SR";
            }

            case ST: {
                return "ST";
            }

            case SV: {
                return "SV";
            }

            case SY: {
                return "SY";
            }

            case SZ: {
                return "SZ";
            }

            case TC: {
                return "TC";
            }

            case TD: {
                return "TD";
            }

            case TF: {
                return "TF";
            }

            case TG: {
                return "TG";
            }

            case TH: {
                return "TH";
            }

            case TJ: {
                return "TJ";
            }

            case TK: {
                return "TK";
            }

            case TL: {
                return "TL";
            }

            case TM: {
                return "TM";
            }

            case TN: {
                return "TN";
            }

            case TO: {
                return "TO";
            }

            case TR: {
                return "TR";
            }

            case TT: {
                return "TT";
            }

            case TV: {
                return "TV";
            }

            case TW: {
                return "TW";
            }

            case TZ: {
                return "TZ";
            }

            case UA: {
                return "UA";
            }

            case UG: {
                return "UG";
            }

            case UM: {
                return "UM";
            }

            case US: {
                return "US";
            }

            case UY: {
                return "UY";
            }

            case UZ: {
                return "UZ";
            }

            case VA: {
                return "VA";
            }

            case VC: {
                return "VC";
            }

            case VE: {
                return "VE";
            }

            case VG: {
                return "VG";
            }

            case VI: {
                return "VI";
            }

            case VN: {
                return "VN";
            }

            case VU: {
                return "VU";
            }

            case WF: {
                return "WF";
            }

            case WS: {
                return "WS";
            }

            case YE: {
                return "YE";
            }

            case YT: {
                return "YT";
            }

            case ZA: {
                return "ZA";
            }

            case ZM: {
                return "ZM";
            }

            case ZW: {
                return "ZW";
            }

            default: {
                return "";
            }
        }
    }
}
