/*******************************************************************************
 *
 *    Copyright 2020 Adobe. All rights reserved.
 *    This file is licensed to you under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License. You may obtain a copy
 *    of the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 *    Unless required by applicable law or agreed to in writing, software distributed under
 *    the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR REPRESENTATIONS
 *    OF ANY KIND, either express or implied. See the License for the specific language
 *    governing permissions and limitations under the License.
 *
 ******************************************************************************/

package com.adobe.cq.commerce.magento.graphql;

import com.shopify.graphql.support.AbstractQuery;
import com.shopify.graphql.support.Fragment;

/**
 * The CustomizableOptionInterface contains basic information about a customizable option. It can be
 * implemented by several types of configurable options.
 */
public class CustomizableOptionInterfaceQuery extends AbstractQuery<CustomizableOptionInterfaceQuery> {
    CustomizableOptionInterfaceQuery(StringBuilder _queryBuilder) {
        this(_queryBuilder, true);
    }

    CustomizableOptionInterfaceQuery(StringBuilder _queryBuilder, boolean addTypename) {
        super(_queryBuilder);
        if (addTypename) {
            startField("__typename");
        }
    }

    /**
     * Option ID.
     *
     * @deprecated Use `uid` instead
     */
    @Deprecated
    public CustomizableOptionInterfaceQuery optionId() {
        startField("option_id");

        return this;
    }

    /**
     * Indicates whether the option is required.
     */
    public CustomizableOptionInterfaceQuery required() {
        startField("required");

        return this;
    }

    /**
     * The order in which the option is displayed.
     */
    public CustomizableOptionInterfaceQuery sortOrder() {
        startField("sort_order");

        return this;
    }

    /**
     * The display name for this option.
     */
    public CustomizableOptionInterfaceQuery title() {
        startField("title");

        return this;
    }

    /**
     * The unique ID for a `CustomizableOptionInterface` object.
     */
    public CustomizableOptionInterfaceQuery uid() {
        startField("uid");

        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableAreaOption(CustomizableAreaOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableAreaOption");
        queryDef.define(new CustomizableAreaOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableCheckboxOption(CustomizableCheckboxOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableCheckboxOption");
        queryDef.define(new CustomizableCheckboxOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableDateOption(CustomizableDateOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableDateOption");
        queryDef.define(new CustomizableDateOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableDropDownOption(CustomizableDropDownOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableDropDownOption");
        queryDef.define(new CustomizableDropDownOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableFieldOption(CustomizableFieldOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableFieldOption");
        queryDef.define(new CustomizableFieldOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableFileOption(CustomizableFileOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableFileOption");
        queryDef.define(new CustomizableFileOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableMultipleOption(CustomizableMultipleOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableMultipleOption");
        queryDef.define(new CustomizableMultipleOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    public CustomizableOptionInterfaceQuery onCustomizableRadioOption(CustomizableRadioOptionQueryDefinition queryDef) {
        startInlineFragment("CustomizableRadioOption");
        queryDef.define(new CustomizableRadioOptionQuery(_queryBuilder));
        _queryBuilder.append('}');
        return this;
    }

    /**
     * Creates a GraphQL "named" fragment with the specified query type definition.
     * The generics nature of fragments ensures that a fragment can only be used at the right place in the GraphQL request.
     * 
     * @param name The name of the fragment, must be unique for a given GraphQL request.
     * @param queryDef The fragment definition.
     * @return The fragment of a given generics type.
     */
    public static Fragment<CustomizableOptionInterfaceQuery> createFragment(String name,
        CustomizableOptionInterfaceQueryDefinition queryDef) {
        StringBuilder sb = new StringBuilder();
        queryDef.define(new CustomizableOptionInterfaceQuery(sb, false));
        return new Fragment<>(name, "CustomizableOptionInterface", sb.toString());
    }

    /**
     * Adds a <code>CustomizableOptionInterfaceQuery</code> fragment reference at the current position of the query.
     * For example for a fragment named <code>test</code>, calling this method will add the
     * reference <code>...test</code> in the query. For GraphQL types implementing an interface, there
     * will be some similar methods using the Query type of each implemented interface.
     * 
     * @param fragment The fragment to reference.
     */
    public CustomizableOptionInterfaceQuery addFragmentReference(Fragment<CustomizableOptionInterfaceQuery> fragment) {
        startField("..." + fragment.getName());
        return this;
    }
}
