/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.tagging.Tag;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.URLParameterBuilder;
import org.codehaus.jackson.JsonNode;

public class TagClient
extends CQClient {
    public static final String TAG_COMMAND_PATH = "/bin/tagcommand";
    private static final String TAG_COMMAND_CAN_CREATE = "canCreateTag";
    private static final String TAG_COMMAND_CAN_CREATE_BY_TITLE = "canCreateTagByTitle";
    private static final String TAG_COMMAND_CREATE = "createTag";
    private static final String TAG_COMMAND_CREATE_BY_TITLE = "createTagByTitle";
    private static final String TAG_COMMAND_DELETE = "deleteTag";
    private static final String TAG_COMMAND_LIST = "list";
    private static final String TAG_COMMAND_MOVE = "moveTag";
    private static final String TAG_COMMAND_MERGE = "mergeTag";
    private static final String TAG_COMMAND_ACTIVATE = "activateTag";
    private static final String TAG_COMMAND_DEACTIVATE = "deactivateTag";
    private static final String TAG_COMMAND_RUN_GC = "gc";
    public static final String TAG_RESOURCE_PATH = ".tag";
    private static String TAG_GARBAGE_COLLECTOR_CONFIG_PATH = "/system/console/configMgr/com.day.cq.tagging.impl.TagGarbageCollector";
    public static String TAG_GARBAGE_COLLECTOR_DEFAULT_CRON_EXPRESSION = "0 0 12 * * ?";
    public static String TAG_GARBAGE_COLLECTOR_CRON_EXPRESSION_PROP = "scheduler.expression";

    public TagClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public TagClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse addTagCloudComponent(String pageHandle, int ... expectedStatus) throws ClientException {
        String postPath = pageHandle + "/jcr:content/par/";
        UrlEncodedFormEntity feb = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter("./sling:resourceType", "cq/tagging/components/tagcloud").addParameter(":nameHint", "tagcloud").addParameter("parentResourceType", "foundation/components/parsys").build();
        return this.doPost(postPath, (HttpEntity)feb, HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
    }

    public SlingHttpResponse editTagCloudComponent(String componentPath, boolean showAsLink, String path, String display, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("./sling:resourceType", "cq/tagging/components/tagcloud");
        form.addParameter("_charset_", "utf-8");
        form.addParameter("./display", display);
        if (!showAsLink) {
            form.addParameter("./noLinks", "true");
            form.addParameter("./noLinks@Delete", "true");
        } else {
            form.addParameter("./noLinks@Delete", "true");
        }
        form.addParameter("./path", path);
        return this.doPost(componentPath, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
    }

    public SlingHttpResponse canCreateTag(String tagId, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("cmd", TAG_COMMAND_CAN_CREATE);
        form.addParameter("_charset_", "utf-8");
        form.addParameter("tag", tagId);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse canCreateTagByTitle(String tagId, String locale, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("cmd", TAG_COMMAND_CAN_CREATE_BY_TITLE);
        form.addParameter("_charset_", "utf-8");
        form.addParameter("tag", tagId);
        form.addParameter("locale", locale);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse createTag(String tagTitle, String tagId, String tagDescr, String parentTagId, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("cmd", TAG_COMMAND_CREATE);
        form.addParameter("_charset_", "utf-8");
        form.addParameter("tag", tagId);
        form.addParameter("jcr:title", tagTitle);
        if (tagDescr != null) {
            form.addParameter("jcr:description", tagDescr);
        }
        if (parentTagId != null) {
            form.addParameter("parentTagID", parentTagId);
        }
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse createTagByTitle(String tagId, String tagTitle, String locale, String tagDescr, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("cmd", TAG_COMMAND_CREATE_BY_TITLE);
        form.addParameter("tag", tagId);
        if (locale != null) {
            form.addParameter("locale", locale);
        }
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deleteTag(String tagPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = this.createCmdFormEntityBuilder(TAG_COMMAND_DELETE, tagPath);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse activateTag(String path, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = this.createCmdFormEntityBuilder(TAG_COMMAND_ACTIVATE, path);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deactivateTag(String path, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("cmd", TAG_COMMAND_DEACTIVATE);
        form.addParameter("_charset_", "utf-8");
        form.addParameter("path", path);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse setTagProperty(Tag tag, String propName, String propValue, int ... expectedStatus) throws ClientException {
        ArrayList<String[]> list = new ArrayList<String[]>();
        list.add(new String[]{propName, propValue});
        return this.setTagProperties(tag, list, expectedStatus);
    }

    public SlingHttpResponse setTagProperties(Tag tag, List<String[]> props, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        for (String[] prop : props) {
            formEntry.addParameter(prop[0], prop[1]);
        }
        String tagPath = tag.getPath().substring(0, tag.getPath().length() - 1);
        return this.doPost(tagPath, (HttpEntity)formEntry.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse getRefList2(Tag tag) throws ClientException {
        return this.getRefList(tag, new int[0]);
    }

    public SlingHttpResponse getRefList(Tag tag, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        formEntry.addParameter("cmd", TAG_COMMAND_LIST);
        String tagPath = tag.getPath().substring(0, tag.getPath().length() - 1);
        formEntry.addParameter("path", tagPath);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)formEntry.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse listTag(String tagPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        formEntry.addParameter("cmd", TAG_COMMAND_LIST);
        formEntry.addParameter("path", tagPath);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)formEntry.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse getTag(String tagPath, int ... expectedStatus) throws ClientException {
        return this.doGet(tagPath + TAG_RESOURCE_PATH + ".json", HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public JsonNode getTags(String nodePath, int ... expectedStatus) throws ClientException {
        JsonNode assetNode = this.doGetJson(nodePath, -1, new int[0]);
        return assetNode.get("cq:tags");
    }

    public SlingHttpResponse listTags(String resourcePath, String titleSuggestion, String nameSuggestion, boolean ignoreCase, boolean matchWordStart, String locale, Boolean count, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create();
        params.add("_charset_", "utf-8");
        if (count != null) {
            params.add("count", count.toString());
        }
        if (locale != null) {
            params.add("locale", locale);
        }
        if (nameSuggestion != null) {
            params.add("suggestByName", nameSuggestion);
        }
        if (titleSuggestion != null) {
            params.add("suggestByTitle", titleSuggestion);
        }
        if (!ignoreCase) {
            params.add("ignoreCase", "false");
        }
        if (matchWordStart) {
            params.add("matchWordStart", "true");
        }
        return this.doGet(resourcePath + ".tags.json", params.getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public void setTag(String page, String tagHandle, int ... expectedStatus) throws ClientException {
        ArrayList<String> list = new ArrayList<String>();
        list.add(tagHandle);
        this.setTags(page, list, expectedStatus);
    }

    public SlingHttpResponse setTags(String page, List<String> tags, int ... expectedStatus) throws ClientException {
        ArrayList<NameValuePair> props = new ArrayList<NameValuePair>();
        for (String tag : tags) {
            props.add((NameValuePair)new BasicNameValuePair("./cq:tags", tag));
        }
        props.add((NameValuePair)new BasicNameValuePair("./cq:tags@TypeHint", "String[]"));
        props.add((NameValuePair)new BasicNameValuePair("./cq:tags@Patch", "true"));
        return this.setPageProperties(page, props, expectedStatus);
    }

    public SlingHttpResponse moveTag(String from, String to, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = this.createCmdFormEntityBuilder(TAG_COMMAND_MOVE, from);
        form.addParameter("dest", to);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse mergeTag(String path, String destPath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("cmd", TAG_COMMAND_MERGE);
        form.addParameter("_charset_", "utf-8");
        form.addParameter("path", path);
        form.addParameter("dest", destPath);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse searchTags(Boolean count, String locale, String query, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create();
        params.add("_charset_", "utf-8");
        params.add("count", count.toString());
        params.add("locale", locale);
        params.add("suggestByTitle", query);
        return this.doGet("/content/cq:tags.tags.json", params.getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse setTagGarbageCollectorCronExpression(String cronExpression, int ... expectedStatus) throws ClientException {
        if (cronExpression == null) {
            this.deletePath(TAG_GARBAGE_COLLECTOR_CONFIG_PATH, new int[0]);
            return null;
        }
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("apply", "true").addTextBody("action", "ajaxConfigManager").addTextBody("propertylist", TAG_GARBAGE_COLLECTOR_CRON_EXPRESSION_PROP).addTextBody(TAG_GARBAGE_COLLECTOR_CRON_EXPRESSION_PROP, cronExpression).build();
        return this.doPost(TAG_GARBAGE_COLLECTOR_CONFIG_PATH, entity, expectedStatus);
    }

    public JsonNode getTagGarbageCollectorConfig(int ... expectedStatus) throws ClientException {
        List<BasicHeader> headers = Collections.singletonList(new BasicHeader("Accept", "application/json"));
        SlingHttpResponse exec = this.doPost(TAG_GARBAGE_COLLECTOR_CONFIG_PATH, null, headers, expectedStatus);
        return JsonUtils.getJsonNodeFromString((String)exec.getContent());
    }

    public SlingHttpResponse runGc(int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create();
        form.addParameter("cmd", TAG_COMMAND_RUN_GC);
        return this.doPost(TAG_COMMAND_PATH, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    private FormEntityBuilder createCmdFormEntityBuilder(String command, String path) {
        return FormEntityBuilder.create().addParameter("cmd", command).addParameter("_charset_", "utf-8").addParameter("path", path);
    }
}

