/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.AbstractAuthorizable;
import com.adobe.cq.testing.client.security.UserProfile;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class User
extends AbstractAuthorizable {
    private static final Logger LOG = LoggerFactory.getLogger(User.class);
    public static final String ROOT_PATH = "/home/users";
    public static final int MAX_ASYNC_WAIT_MILLIS = Integer.getInteger("granite.it.maxasync", 6000);
    protected UserProfile profile;

    public <T extends SecurityClient> User(T client, String authorizableId) throws ClientException, InterruptedException {
        super(client, authorizableId);
    }

    @Override
    public String getRootPath() {
        return ROOT_PATH;
    }

    public <T extends User> SlingHttpResponse addImpersonators(T[] authorizables, int ... expectedStatus) throws ClientException, InterruptedException {
        if (authorizables == null) {
            throw new IllegalArgumentException("List of authorizables may not be null!");
        }
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        for (T authorizable : authorizables) {
            formEntry.addParameter("addImpersonators", User.encodeURI(((AbstractAuthorizable)authorizable).getId()));
        }
        class PostPolling
        extends Polling {
            private final FormEntityBuilder entity;
            private final int[] expectedStatus;
            private SlingHttpResponse response;

            public PostPolling(FormEntityBuilder entity, int ... expectedStatus) {
                this.entity = entity;
                this.expectedStatus = expectedStatus;
            }

            public Boolean call() throws Exception {
                this.response = User.this.doPost(this.entity, this.expectedStatus);
                return true;
            }

            public SlingHttpResponse getResponse() {
                return this.response;
            }
        }
        PostPolling polling = new PostPolling(formEntry, expectedStatus);
        try {
            polling.poll(MAX_ASYNC_WAIT_MILLIS, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to add impersonators.", (Throwable)e);
        }
        return polling.getResponse();
    }

    public <T extends User> SlingHttpResponse removeImpersonators(T[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            throw new IllegalArgumentException("List of authorizables may not be null!");
        }
        FormEntityBuilder formEntry = FormEntityBuilder.create();
        formEntry.addParameter("_charset_", "utf-8");
        for (T authorizable : authorizables) {
            formEntry.addParameter("removeImpersonators", User.encodeURI(((AbstractAuthorizable)authorizable).getId()));
        }
        return this.doPost(formEntry, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public UserProfile getUserProfile() throws ClientException {
        if (this.profile == null) {
            this.initProfile();
        }
        return this.profile;
    }

    protected void initProfile() throws ClientException {
        this.profile = new UserProfile(this);
    }

    public static <T extends SecurityClient> User createUser(T client, String userId, String password, String intermediatePath, Map<String, String> profileMap, int ... expectedStatus) throws ClientException, InterruptedException {
        if (client == null || userId == null) {
            throw new IllegalArgumentException("Client and userId may not be null!");
        }
        if (password == null) {
            password = userId;
        }
        FormEntityBuilder feb = FormEntityBuilder.create();
        feb.addParameter("_charset_", "utf-8");
        feb.addParameter("createUser", "1");
        feb.addParameter("authorizableId", userId);
        feb.addParameter("rep:password", password);
        if (intermediatePath != null) {
            feb.addParameter("intermediatePath", intermediatePath);
        }
        if (profileMap != null) {
            Set<String> profileProps = profileMap.keySet();
            for (String propName : profileProps) {
                String propValue = profileMap.get(propName);
                if (propValue == null) continue;
                feb.addParameter("./profile/" + propName, propValue);
            }
        }
        String createUserPath = client.getManager().doPost(feb, HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus)).getSlingPath();
        LOG.info("Created user at {}", (Object)createUserPath);
        return new User(client, userId);
    }

    @Deprecated
    public static <T extends SecurityClient> User createUser(T client, String userId, String password, String intermediatePath, Map<String, String> profileMap, boolean waitForIndex, int ... expectedStatus) throws ClientException, InterruptedException {
        return User.createUser(client, userId, password, intermediatePath, profileMap, expectedStatus);
    }
}

