/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.assertion;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.junit.Assert;

public class HttpAssert {
    public static void assertContentTypeEquals(HttpResponse response) {
        Header contentType = response.getFirstHeader("Content-Type");
        Assert.assertEquals((String)"Response Header 'Content-Type' is not properly set!", (Object)"text/html;charset=utf-8", (Object)contentType.getValue().replace(" ", "").toLowerCase());
    }

    public static URL parseURL(String pathOrURL) {
        try {
            return new URL(pathOrURL);
        }
        catch (MalformedURLException e) {
            try {
                return new URL(new URL("http://localhost"), pathOrURL);
            }
            catch (MalformedURLException e1) {
                Assert.fail((String)("URL is malformed: " + pathOrURL));
                return null;
            }
        }
    }

    public static String extractPath(String pathOrURL) {
        URL parsedUrl = HttpAssert.parseURL(pathOrURL);
        if (parsedUrl != null) {
            return parsedUrl.getPath();
        }
        return null;
    }

    public static void assertURLPathEquals(String expected, String loc) throws MalformedURLException {
        Assert.assertEquals((String)"Redirect target of Form Authentication response is wrong!", (Object)HttpAssert.extractPath(expected), (Object)HttpAssert.extractPath(loc));
    }

    public static Map<String, String> parseParameters(String query) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (query == null) {
            return parameters;
        }
        for (String paramAndValue : query.split("&")) {
            String[] pair = paramAndValue.split("=");
            if (pair.length != 2) continue;
            parameters.put(pair[0], pair[1]);
        }
        return parameters;
    }

    public static void assertParameter(String pathOrURL, String parameter, String value) {
        URL url = HttpAssert.parseURL(pathOrURL);
        Map<String, String> params = HttpAssert.parseParameters(url != null ? url.getQuery() : null);
        Assert.assertTrue((boolean)params.get(parameter).matches(value));
    }
}

