/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util;

import com.adobe.cq.testing.junit.assertion.GraniteAssert;
import com.adobe.cq.testing.util.TestUtil;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.XSSUtils;
import org.apache.taglibs.standard.functions.Functions;
import org.junit.Assert;

public class CQXSSUtils
extends XSSUtils {
    public static final String XSS_ATTACK_SIMPLE = "';!--\"<XSS>=&{()}";
    public static final String XSS_ATTACK_JS_SIMPLE = "'\"></title></script><script>alert('XSS');</script>";
    public static final String XSS_ATTACK_JS_SIMPLE2 = "\"});});alert(23);</script>";
    public static final String XSS_ATTACK_JS_CASE_INSENSITIVE = "<IMG SRC=\"JaVaScRiPt:alert('XSS');\">";
    public static final String XSS_ATTACK_HERF_SIMPLE = "XSSHERF%22%20onclick=alert(23)%3E";

    public static String escapeXmlJSTL(String xmlString) {
        return Functions.escapeXml((String)xmlString);
    }

    public static String replaceSpecialCharsForRegexp(String regexp) {
        return TestUtil.replaceSpecialCharsForRegexp(regexp);
    }

    public static void assertTitleTagIsNotVulnerable(SlingHttpResponse response, String expectedTitle) throws IOException {
        Assert.assertTrue((boolean)response.getContent().contains("<title>"));
        String content = response.getContent();
        GraniteAssert.assertRegExFind("Title tag is not properly sanitized: " + content, content, Pattern.compile("<title>[^<]*" + CQXSSUtils.replaceSpecialCharsForRegexp(expectedTitle) + "[^<]*</title>", 10));
    }
}

