/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQSecurityClient;
import com.adobe.cq.testing.client.security.CQPermissions;
import com.adobe.cq.testing.util.CSRFUtils;
import java.io.IOException;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.JsonUtils;

public final class CQConfigManagerClient
extends CQClient {
    private static final String PARAM_TITLE = "configTitle";
    private static final String PARAM_NAME = "configName";
    private static final String PARAM_PARENT = "configParent";
    private static final String PARAM_CONFIG_CAPABILITIES = "configCapabilities";
    private static final String CREATE_ENDPOINT = "/conf.createconf.json";
    private static final String DEFAULT_ROOT_PATH = "/conf";
    private static final String CFM_RELATIVE_PATH = "/settings/dam/cfm";
    private static final String CFM_TEMPLATES_RELATIVE_PATH = "/settings/dam/cfm/templates";
    private static final String PARAM_APPLY_TO = ":applyTo";
    private static final String PROP_JCR_TITLE = "./jcr:title";
    private static final long DEFAULT_RETRY_DELAY = Duration.ofSeconds(1L).toMillis();
    private static final long DEFAULT_TIMEOUT = Duration.ofSeconds(30L).toMillis();
    private static final String GROUPID_TEMPLATE_AUTHORS = "template-authors";
    private static final String GROUPID_CONTENT_AUTHORS = "content-authors";
    private static final String GROUPID_EVERYONE = "everyone";

    public CQConfigManagerClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public CQConfigManagerClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public CQConfig create(String configTitle, CQConfigCapability ... capabilities) throws ClientException {
        return this.create(DEFAULT_ROOT_PATH, configTitle, configTitle, capabilities);
    }

    public CQConfig create(String parentPath, String configTitle, CQConfigCapability ... capabilities) throws ClientException {
        return this.create(parentPath, configTitle, configTitle, capabilities);
    }

    public CQConfig create(String parentPath, String configTitle, String configName, CQConfigCapability ... capabilities) throws ClientException {
        FormEntityBuilder formEntry = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter(PARAM_TITLE, configTitle).addParameter(PARAM_NAME, configName).addParameter(PARAM_PARENT, parentPath);
        Arrays.stream(capabilities).forEach(c -> formEntry.addParameter(PARAM_CONFIG_CAPABILITIES, c.getTitle()));
        this.doPost(CREATE_ENDPOINT, (HttpEntity)formEntry.build(), new int[]{200});
        return new CQConfig(this, parentPath + "/" + configTitle);
    }

    public static enum CQConfigCapability {
        CLOUD("Cloud Configurations"),
        CONTEXT_HUB("ContextHub segments"),
        CONTENT_FRAGMENT_MODEL("Content Fragment Models"),
        EDITABLE_TEMPLATES("Editable Templates"),
        GRAPHQL("GraphQL Persistent Queries");

        private final String capabilityTitle;

        private CQConfigCapability(String s) {
            this.capabilityTitle = s;
        }

        public String getTitle() {
            return this.capabilityTitle;
        }
    }

    public static final class CQConfig {
        private static final String DELETE_ENDPOINT_SUFFIX = ".deleteconf.json";
        private static final String UPDATE_ENDPOINT_SUFFIX = ".updateconf.json";
        private final CQClient client;
        private final String configPath;

        protected CQConfig(CQClient client, String path) {
            this.client = client;
            this.configPath = path;
        }

        public String getPath() {
            return this.configPath;
        }

        public void delete() throws ClientException {
            FormEntityBuilder formEntry = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter(CQConfigManagerClient.PARAM_APPLY_TO, this.configPath);
            this.client.doPost(this.configPath + DELETE_ENDPOINT_SUFFIX, (HttpEntity)formEntry.build(), new int[]{200});
        }

        public void updateTitle(String newTitle) throws ClientException, IOException {
            FormEntityBuilder formEntry = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter(CQConfigManagerClient.PROP_JCR_TITLE, newTitle).addParameter(":cq_csrf_token", CSRFUtils.createCSRFToken(this.client)).addParameter(CQConfigManagerClient.PARAM_APPLY_TO, this.configPath);
            this.client.doPost(this.configPath + UPDATE_ENDPOINT_SUFFIX, (HttpEntity)formEntry.build(), new int[]{200});
        }

        public String importContentFragmentTemplate(String jsonString) throws ClientException, InterruptedException {
            if (!this.client.exists(this.configPath + CQConfigManagerClient.CFM_TEMPLATES_RELATIVE_PATH)) {
                this.client.createPageWithRetry("templates", "Templates", this.configPath + CQConfigManagerClient.CFM_RELATIVE_PATH, null, DEFAULT_TIMEOUT, DEFAULT_RETRY_DELAY, new int[0]);
            }
            return this.client.importJson(this.configPath + CQConfigManagerClient.CFM_TEMPLATES_RELATIVE_PATH, JsonUtils.getJsonNodeFromString((String)jsonString), new int[]{201}).getSlingPath();
        }

        public void setWcmTemplatesPermissions() throws ClientException {
            CQSecurityClient sClient = (CQSecurityClient)this.client.adaptTo(CQSecurityClient.class);
            CQPermissions cqPermissions = new CQPermissions(sClient);
            String templatePath = this.configPath + "/settings/wcm/templates";
            cqPermissions.changePermissions(CQConfigManagerClient.GROUPID_EVERYONE, templatePath, true, false, false, false, false, false, false, 200);
            cqPermissions.changePermissions(CQConfigManagerClient.GROUPID_CONTENT_AUTHORS, templatePath, true, false, false, false, false, false, true, 200);
            cqPermissions.changePermissions(CQConfigManagerClient.GROUPID_TEMPLATE_AUTHORS, templatePath, true, true, true, true, false, false, true, 200);
            cqPermissions.changePermissions("version-manager-service", templatePath, true, true, true, true, false, false, false, 200);
            String policiesPath = this.configPath + "/settings/wcm/policies";
            cqPermissions.changePermissions(CQConfigManagerClient.GROUPID_EVERYONE, policiesPath, true, false, false, false, false, false, false, 200);
            cqPermissions.changePermissions(CQConfigManagerClient.GROUPID_CONTENT_AUTHORS, policiesPath, true, false, false, false, false, false, true, 200);
            cqPermissions.changePermissions(CQConfigManagerClient.GROUPID_TEMPLATE_AUTHORS, policiesPath, true, true, true, true, false, false, true, 200);
            String templateTypesPath = this.configPath + "/settings/wcm/template-types";
            cqPermissions.changePermissions(CQConfigManagerClient.GROUPID_TEMPLATE_AUTHORS, templateTypesPath, true, false, false, false, false, false, false, 200);
        }
    }
}

