/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.URLParameterBuilder;

public class ExperienceFragmentsClient
extends CQClient {
    private static final Gson GSON = new Gson();
    private static final Type LIST_STRING_TYPE = new TypeToken<List<String>>(){}.getType();
    private static final String WEB_TEMPLATE_PATH = "/libs/settings/experience-fragments/templates/experience-fragment-template";
    private static final String FACEBOOK_TEMPLATE_PATH = "/libs/settings/experience-fragments/templates/experience-fragment-template-facebook";
    private static final String PINTEREST_TEMPLATE_PATH = "/libs/settings/experience-fragments/templates/experience-fragment-template-pinterest";
    private static final String EXPERIENCE_FRAGMENTS_TAG = "experience-fragments:";
    private static final String VARIATION_TAG = "experience-fragments:variation";
    private static final String WEB_TAG_ID = "experience-fragments:variation/web";
    private static final String FACEBOOK_TAG_ID = "experience-fragments:variation/facebook";
    private static final String PINTEREST_TAG_ID = "experience-fragments:variation/pinterest";
    private static final String WEB_XF_VARIANT_TYPE = "web";
    private static final String FACEBOOK_XF_VARIANT_TYPE = "facebook";
    private static final String PINTEREST_XF_VARIANT_TYPE = "pinterest";
    private static final String CUSTOM_XF_VARIANT_TYPE = "custom";
    private static final String PROPERTIES_PATH_PREFIX = "/mnt/overlay/wcm/core/content/sites/properties.html";
    public static final String DEFAULT_XF_PARENT_PATH = "/content/experience-fragments";
    private static final String REFERENCES_SERVLET = "/libs/cq/experience-fragments/content/commons/reference.json";
    private static final String CONFIGURATOR = "/libs/cq/experience-fragments/content/dialogs/configdialog/configurator.html";
    private static final String XF_CREATE_WIZARD = "/libs/cq/experience-fragments/content/v2/experience-fragments/createxfwizard/_jcr_content";
    private static final String XF_VARIANT_CREATE_WIZARD = "/libs/cq/experience-fragments/content/dialogs/createvariation/creator";
    private static final String CONVERT_TO_XF = "/libs/cq/experience-fragments/content/v2/conversion/converter";
    public static final String TITLE_PROP = "jcr:title";
    private static final String TAGS_PROP = "cq:tags";
    private static final String FACEBOOK_SPACE_PROP = "facebookspace";
    private static final String PINTEREST_SPACE_PROP = "pinterestspace";

    public ExperienceFragmentsClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public ExperienceFragmentsClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public ExperienceFragmentBuilder experienceFragmentBuilder(String xfTitle, String variantTitle, String variantTemplate) {
        return new ExperienceFragmentBuilder(this, xfTitle, variantTitle, variantTemplate);
    }

    public ExperienceFragmentBuilder experienceFragmentBuilder(String xfTitle, String variantTitle, XF_TEMPLATE variantTemplate) {
        return this.experienceFragmentBuilder(xfTitle, variantTitle, variantTemplate.path());
    }

    public SlingHttpResponse createExperienceFragment(String xfTitle, String variantTitle, String variantTemplate, int ... expectedStatus) throws ClientException {
        return new ExperienceFragmentBuilder(this, xfTitle, variantTitle, variantTemplate).create(expectedStatus);
    }

    public SlingHttpResponse createExperienceFragment(String xfTitle, String variantTitle, XF_TEMPLATE variantTemplate, int ... expectedStatus) throws ClientException {
        return this.createExperienceFragment(xfTitle, variantTitle, variantTemplate.path(), expectedStatus);
    }

    public ExperienceFragmentVariantBuilder xfVariantBuilder(String parentPath, String template, String title) {
        return new ExperienceFragmentVariantBuilder(this, parentPath, template, title);
    }

    public ExperienceFragmentVariantBuilder xfVariantBuilder(String parentPath, XF_TEMPLATE template, String title) {
        return this.xfVariantBuilder(parentPath, template.path(), title);
    }

    public SlingHttpResponse createXfVariant(String parentPath, String template, String title, int ... expectedStatus) throws ClientException {
        return new ExperienceFragmentVariantBuilder(this, parentPath, template, title).create(expectedStatus);
    }

    public SlingHttpResponse createXfVariant(String parentPath, XF_TEMPLATE template, String title, int ... expectedStatus) throws ClientException {
        return this.createXfVariant(parentPath, template.path(), title, expectedStatus);
    }

    public SlingHttpResponse createVariationAsLiveCopy(String sourceVariantPath, String title, String name, String[] rolloutConfigs, int ... expectedStatus) throws ClientException {
        return this.wcmCommands.createLiveCopy(name, title, ExperienceFragmentsClient.getParentXFPath(sourceVariantPath), sourceVariantPath, true, rolloutConfigs, null, true, expectedStatus);
    }

    public SlingHttpResponse deleteExperienceFragment(String path, int ... expectedStatus) throws ClientException {
        return this.deleteExperienceFragment(path, true, expectedStatus);
    }

    public SlingHttpResponse deleteExperienceFragment(String path, boolean force, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("cmd", "deletePage").addParameter("path", path).addParameter("force", String.valueOf(force)).addParameter("checkChildren", String.valueOf(true)).build();
        return this.doPost("/bin/wcmcommand", (HttpEntity)entity, expectedStatus);
    }

    public SlingHttpResponse deleteXfVariant(String variantPath, int ... expectedStatus) throws ClientException {
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("variationPath", variantPath).build();
        return this.doPost(ExperienceFragmentsClient.getParentXFPath(variantPath) + "/jcr:content.deletevariation.json", (HttpEntity)entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public ExperienceFragment getExperienceFragment(String xfPath) throws ClientException {
        return new ExperienceFragment(this, xfPath);
    }

    public ExperienceFragmentVariant getXFVariant(String variantPath) throws ClientException {
        return new ExperienceFragmentVariant(this, variantPath);
    }

    public SlingHttpResponse getPlainHtmlRendering(String variantPath, int ... expectedStatus) throws ClientException {
        return this.doGet(variantPath + ".plain.html", HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse getSocialUrls(String variantPath, int ... expectedStatus) throws ClientException {
        return this.doGet(variantPath + ".socialurls.json", HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public ConvertToXFAction convertToXF() {
        return new ConvertToXFAction(this);
    }

    public SlingHttpResponse getXFPropertiesPageHTHML(String xfPath, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create().add("item", xfPath);
        return this.doGet(PROPERTIES_PATH_PREFIX, params.getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse getVariantProperitesPageHTML(String variantPath, int ... expectedStatus) throws ClientException {
        URLParameterBuilder params = URLParameterBuilder.create().add("item", variantPath);
        return this.doGet(PROPERTIES_PATH_PREFIX, params.getList(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public ExperienceFragmentsConfiguration getCurrentConfiguration() throws ClientException {
        return new ExperienceFragmentsConfiguration(this);
    }

    public ExperienceFragementsConfigurationBuilder configurationBuilder() throws ClientException {
        return new ExperienceFragementsConfigurationBuilder(this);
    }

    private List<String> getPageReferences(String pagePath) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("path", pagePath);
        SlingHttpResponse content = this.doPost(REFERENCES_SERVLET, (HttpEntity)form.build(), new int[]{200});
        ArrayList<String> paths = new ArrayList<String>();
        JsonArray references = ((JsonObject)GSON.fromJson(content.getContent(), JsonObject.class)).get("assets").getAsJsonArray();
        for (JsonElement reference : references) {
            paths.add(((JsonObject)reference).get("path").getAsString());
        }
        return paths;
    }

    private SlingHttpResponse replicate(String cmd, String pagePath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("cmd", cmd).addParameter("path", pagePath);
        List<String> references = this.getPageReferences(pagePath);
        for (String reference : references) {
            form.addParameter("path", reference);
        }
        return this.doPost("/bin/replicate", (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    private SlingHttpResponse publish(String pagePath, int ... expectedStatus) throws ClientException {
        return this.replicate("Activate", pagePath, new int[0]);
    }

    public SlingHttpResponse unpublish(String pagePath, int ... expectedStatus) throws ClientException {
        return this.replicate("Deactivate", pagePath, new int[0]);
    }

    public SlingHttpResponse publishXFVariant(String variantPath, int ... expectedStatus) throws ClientException {
        return this.publish(variantPath, expectedStatus);
    }

    public SlingHttpResponse publishXF(String xfPath, int ... expectedStatus) throws ClientException {
        return this.publish(xfPath, expectedStatus);
    }

    public SlingHttpResponse unpublishXFVariant(String variantPath, int ... expectedStatus) throws ClientException {
        return this.unpublish(variantPath, expectedStatus);
    }

    public SlingHttpResponse unblishXF(String xfPath, int ... expectedStatus) throws ClientException {
        return this.unpublish(xfPath, expectedStatus);
    }

    public static String getParentXFPath(String variantPath) {
        return variantPath.substring(0, variantPath.lastIndexOf("/"));
    }

    public <T extends VariantComponents> T getComponents(String variantPath, XF_TEMPLATE template) throws Exception {
        return template.getComponents(this, variantPath);
    }

    public static class ExperienceFragementsConfigurationBuilder {
        private static final String ALLOWED_TEMPLATES_PARAM = "cq:allowedTemplates";
        private ExperienceFragmentsClient client;
        private ExperienceFragmentsConfiguration configuration;
        private List<String> allowedTemplates;

        public ExperienceFragementsConfigurationBuilder(ExperienceFragmentsClient client) throws ClientException {
            this.client = client;
            this.configuration = new ExperienceFragmentsConfiguration(client);
        }

        public ExperienceFragementsConfigurationBuilder withAllowedTemplates(List<String> allowedTemplates) {
            this.allowedTemplates = allowedTemplates;
            return this;
        }

        public ExperienceFragmentsConfiguration configure() throws ClientException {
            FormEntityBuilder feb = FormEntityBuilder.create();
            List<String> allowedTemplatesResolved = this.allowedTemplates != null ? this.allowedTemplates : this.configuration.getAllowedTemplates();
            for (String allowedTemplate : allowedTemplatesResolved) {
                feb.addParameter(ALLOWED_TEMPLATES_PARAM, allowedTemplate);
            }
            this.client.doPost(ExperienceFragmentsClient.CONFIGURATOR, (HttpEntity)feb.build(), new int[]{200});
            return new ExperienceFragmentsConfiguration(this.client);
        }
    }

    public static class ExperienceFragmentsConfiguration {
        private static final String ALLOWED_TEMPLATES_PROP = "cq:allowedTemplates";
        private ExperienceFragmentsClient client;
        private List<String> allowedTemplates;

        public ExperienceFragmentsConfiguration(ExperienceFragmentsClient client) throws ClientException {
            this.client = client;
            this.buildConfiguration();
        }

        private void buildConfiguration() throws ClientException {
            SlingHttpResponse response = this.client.doGet("/content/experience-fragments.json", new int[0]);
            JsonObject folderProperties = (JsonObject)GSON.fromJson(response.getContent(), JsonObject.class);
            JsonArray allowedTemplatesJson = folderProperties.get(ALLOWED_TEMPLATES_PROP).getAsJsonArray();
            this.allowedTemplates = new ArrayList<String>();
            for (JsonElement allowedTemplateJson : allowedTemplatesJson) {
                this.allowedTemplates.add(allowedTemplateJson.getAsString());
            }
        }

        public List<String> getAllowedTemplates() {
            return this.allowedTemplates;
        }

        public void update() throws ClientException {
            this.buildConfiguration();
        }
    }

    public static class ExperienceFragmentVariant {
        public static final String DESCRIPTION_PROP = "jcr:description";
        public static final String MASTER_VARIATION_PROP = "cq:xfMasterVariation";
        public static final String SOCIAL_VARIATION_PROP = "cq:xfSocialVariation";
        public static final String SHOW_IN_EDITOR_PROP = "showInEditor";
        public static final String TEMPLATE_PROP = "cq:template";
        public static final String RESOURCE_TYPE_PROP = "sling:resourceType";
        private static final String MIXIN_TYPES_PROP = "jcr:mixinTypes";
        private static final String LIVE_RELATIONSHIP = "cq:LiveRelationship";
        private static final String LIVE_SYNC = "cq:LiveSync";
        private static final String XF_VARIANT_TYPE = "cq:xfVariantType";
        private ExperienceFragmentsClient client;
        private JsonObject variantProperties;
        private boolean masterVariant;
        private boolean socialVariant;
        private boolean showInEditor;
        private boolean liveCopy;
        private String variantType;
        private String variantPath;
        private String templatePath;
        private XF_TEMPLATE templateType;
        private String resourceType;
        private String title;
        private String name;
        private String description;
        private List<String> tags;
        private String facebookSpace;
        private String pinterestSpace;

        public ExperienceFragmentVariant(ExperienceFragmentsClient xfClient, String variantPath) throws ClientException {
            this.client = xfClient;
            this.variantPath = StringUtils.stripEnd((String)variantPath, (String)"/");
            this.buildVariant();
        }

        private void buildVariant() throws ClientException {
            SlingHttpResponse response = this.client.doGet(this.variantPath + "/jcr:content.json", new int[]{200});
            this.variantProperties = (JsonObject)GSON.fromJson(response.getContent(), JsonObject.class);
            this.variantType = this.variantProperties.get(XF_VARIANT_TYPE) != null ? this.variantProperties.get(XF_VARIANT_TYPE).getAsString() : ExperienceFragmentsClient.CUSTOM_XF_VARIANT_TYPE;
            this.masterVariant = this.variantProperties.get(MASTER_VARIATION_PROP) != null && this.variantProperties.get(MASTER_VARIATION_PROP).getAsBoolean();
            this.socialVariant = this.variantProperties.get(SOCIAL_VARIATION_PROP) != null && this.variantProperties.get(SOCIAL_VARIATION_PROP).getAsBoolean();
            this.showInEditor = this.variantProperties.get(SHOW_IN_EDITOR_PROP) != null && this.variantProperties.get(SHOW_IN_EDITOR_PROP).getAsBoolean();
            this.templatePath = this.variantProperties.get(TEMPLATE_PROP).getAsString();
            this.resourceType = this.variantProperties.get(RESOURCE_TYPE_PROP).getAsString();
            this.title = this.variantProperties.get(ExperienceFragmentsClient.TITLE_PROP).getAsString();
            this.description = this.variantProperties.get(DESCRIPTION_PROP) != null ? this.variantProperties.get(DESCRIPTION_PROP).getAsString() : null;
            this.tags = this.variantProperties.get(ExperienceFragmentsClient.TAGS_PROP) != null ? (List)GSON.fromJson(this.variantProperties.get(ExperienceFragmentsClient.TAGS_PROP).getAsJsonArray().toString(), LIST_STRING_TYPE) : null;
            this.facebookSpace = this.variantProperties.get(ExperienceFragmentsClient.FACEBOOK_SPACE_PROP) != null ? this.variantProperties.get(ExperienceFragmentsClient.FACEBOOK_SPACE_PROP).getAsString() : null;
            this.pinterestSpace = this.variantProperties.get(ExperienceFragmentsClient.PINTEREST_SPACE_PROP) != null ? this.variantProperties.get(ExperienceFragmentsClient.PINTEREST_SPACE_PROP).getAsString() : null;
            ArrayList mixins = this.variantProperties.get(MIXIN_TYPES_PROP) != null ? (List)GSON.fromJson((JsonElement)this.variantProperties.get(MIXIN_TYPES_PROP).getAsJsonArray(), LIST_STRING_TYPE) : new ArrayList();
            this.liveCopy = mixins.contains(LIVE_RELATIONSHIP) && mixins.contains(LIVE_SYNC);
            String[] pathComponents = this.variantPath.split("/");
            this.name = pathComponents[pathComponents.length - 1];
            this.templateType = XF_TEMPLATE.CUSTOM;
            for (XF_TEMPLATE template : XF_TEMPLATE.values()) {
                if (template == XF_TEMPLATE.CUSTOM || !template.path().equals(this.templatePath)) continue;
                this.templateType = template;
                break;
            }
        }

        public boolean isMasterVariant() {
            return this.masterVariant;
        }

        public boolean isSocialVariant() {
            return this.socialVariant;
        }

        public boolean isLiveCopy() {
            return this.liveCopy;
        }

        public XF_TEMPLATE getTemplateType() {
            return this.templateType;
        }

        public String getTemplatePath() {
            return this.templateType != XF_TEMPLATE.CUSTOM ? this.templateType.path() : this.templatePath;
        }

        public String getVariantType() {
            return this.variantType;
        }

        public String getPath() {
            return this.variantPath;
        }

        public String getResourceType() {
            return this.resourceType;
        }

        public boolean showInEditor() {
            return this.showInEditor;
        }

        public String getParentXFPath() {
            return ExperienceFragmentsClient.getParentXFPath(this.variantPath);
        }

        public String getTitle() {
            return this.title;
        }

        public String getName() {
            return this.name;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        @Nullable
        public List<String> getTags() {
            return this.tags;
        }

        @Nullable
        public String getFacebookSpace() {
            return this.facebookSpace;
        }

        @Nullable
        public String getPinterestSpace() {
            return this.pinterestSpace;
        }

        public JsonElement getProperty(String propertyName) {
            return this.variantProperties.get(propertyName);
        }

        public <T extends VariantComponents> T getComponents() {
            return this.templateType.getComponents(this.client, this.variantPath);
        }

        public void update() throws ClientException {
            this.buildVariant();
        }

        public void setFacebookSpace(String facebookSpace) throws ClientException {
            if (this.templateType != XF_TEMPLATE.FACEBOOK) {
                throw new UnsupportedOperationException("Cannot set the Facebook Space for a non Facebook variant");
            }
            UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("./facebookspace", facebookSpace).build();
            this.client.doPost(this.variantPath + "/jcr:content", (HttpEntity)entity, new int[]{200});
            this.update();
        }

        public void setPinterestSpace(String pinterestSpace) throws ClientException {
            if (this.templateType != XF_TEMPLATE.PINTEREST) {
                throw new UnsupportedOperationException("Cannot set the Facebook Space for a non Pinterest variant");
            }
            UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("./pinterestspace", pinterestSpace).build();
            this.client.doPost(this.variantPath + "/jcr:content", (HttpEntity)entity, new int[]{200});
            this.update();
        }

        public SlingHttpResponse publish(int ... expectedStatus) throws ClientException {
            return this.client.publishXFVariant(this.variantPath, expectedStatus);
        }

        public SlingHttpResponse unpublish(int ... expectedStatus) throws ClientException {
            return this.client.unpublishXFVariant(this.variantPath, expectedStatus);
        }
    }

    public static class ExperienceFragment {
        public static final String DESCRIPTION_PROP = "jcr:description";
        private ExperienceFragmentsClient client;
        private JsonObject xfProperties;
        private String xfPath;
        private String title;
        private String name;
        private List<String> tags;
        private String description;
        private List<ExperienceFragmentVariant> variants;
        private String facebookSpace;
        private String pinterestSpace;

        public ExperienceFragment(ExperienceFragmentsClient client, String xfPath) throws ClientException {
            this.client = client;
            this.xfPath = StringUtils.stripEnd((String)xfPath, (String)"/");
            this.buildXF();
        }

        private void buildXF() throws ClientException {
            JsonObject experienceFragment = (JsonObject)GSON.fromJson(this.client.doGet(this.xfPath + ".1.json", new int[]{200}).getContent(), JsonObject.class);
            this.xfProperties = experienceFragment.getAsJsonObject("jcr:content");
            this.title = this.xfProperties.get(ExperienceFragmentsClient.TITLE_PROP).getAsString();
            this.description = this.xfProperties.get(DESCRIPTION_PROP) != null ? this.xfProperties.get(DESCRIPTION_PROP).getAsString() : null;
            this.tags = this.xfProperties.get(ExperienceFragmentsClient.TAGS_PROP) != null ? (List)GSON.fromJson(this.xfProperties.get(ExperienceFragmentsClient.TAGS_PROP).getAsJsonArray().toString(), LIST_STRING_TYPE) : null;
            this.facebookSpace = this.xfProperties.get(ExperienceFragmentsClient.FACEBOOK_SPACE_PROP) != null ? this.xfProperties.get(ExperienceFragmentsClient.FACEBOOK_SPACE_PROP).getAsString() : null;
            this.pinterestSpace = this.xfProperties.get(ExperienceFragmentsClient.PINTEREST_SPACE_PROP) != null ? this.xfProperties.get(ExperienceFragmentsClient.PINTEREST_SPACE_PROP).getAsString() : null;
            String[] pathComponents = this.xfPath.split("/");
            this.name = pathComponents[pathComponents.length - 1];
            this.variants = new ArrayList<ExperienceFragmentVariant>();
            for (Map.Entry property : experienceFragment.entrySet()) {
                if (!((JsonElement)property.getValue()).isJsonObject() || ((String)property.getKey()).equals("jcr:content")) continue;
                this.variants.add(new ExperienceFragmentVariant(this.client, this.xfPath + "/" + (String)property.getKey()));
            }
        }

        public void update() throws ClientException {
            this.buildXF();
        }

        public String getTitle() {
            return this.title;
        }

        public String getName() {
            return this.name;
        }

        public String getPath() {
            return this.xfPath;
        }

        @Nullable
        public List<String> getTags() {
            return this.tags;
        }

        @Nullable
        public String getDescription() {
            return this.description;
        }

        public List<ExperienceFragmentVariant> getVariants() {
            return this.variants;
        }

        @Nullable
        public String getFacebookSpace() {
            return this.facebookSpace;
        }

        @Nullable
        public String getPinterestSpace() {
            return this.pinterestSpace;
        }

        public JsonElement getProperty(String property) {
            return this.xfProperties.get(property);
        }

        public void setFacebookSpace(String facebookSpace) throws ClientException {
            UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("./facebookspace", facebookSpace).build();
            this.client.doPost(this.xfPath + "/jcr:content", (HttpEntity)entity, new int[]{200});
            this.update();
        }

        public void setPinterestSpace(String pinterestSpace) throws ClientException {
            UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("./pinterestspace", pinterestSpace).build();
            this.client.doPost(this.xfPath + "/jcr:content", (HttpEntity)entity, new int[]{200});
            this.update();
        }

        public SlingHttpResponse publish(int ... expectedStatus) throws ClientException {
            return this.client.publishXF(this.xfPath, expectedStatus);
        }

        public SlingHttpResponse unpublish(int ... expectedStatus) throws ClientException {
            return this.client.unblishXF(this.xfPath, expectedStatus);
        }
    }

    public static class ContentFragmentComponent
    extends Component {
        private static final String CONTENT_FRAGMENT_PATH_SUFIX = "/jcr:content/root/contentfragment";
        private final String contentFragmentComponentPath;

        public ContentFragmentComponent(ExperienceFragmentsClient client, String variantPath) {
            this(client, variantPath, null);
        }

        public ContentFragmentComponent(ExperienceFragmentsClient client, String variantPath, String pathSuffix) {
            super(client, variantPath);
            this.contentFragmentComponentPath = variantPath + (StringUtils.isBlank((CharSequence)pathSuffix) ? CONTENT_FRAGMENT_PATH_SUFIX : pathSuffix);
        }

        @Override
        public String getPath() {
            return this.contentFragmentComponentPath;
        }
    }

    public static class TextComponent
    extends Component {
        private static final String TEXT_COMPONENT_PATH_SUFIX = "/jcr:content/root/text";
        private final String textComponentPath;

        public TextComponent(ExperienceFragmentsClient client, String variantPath) {
            this(client, variantPath, null);
        }

        public TextComponent(ExperienceFragmentsClient client, String variantPath, String pathSuffix) {
            super(client, variantPath);
            this.textComponentPath = variantPath + (StringUtils.isBlank((CharSequence)pathSuffix) ? TEXT_COMPONENT_PATH_SUFIX : pathSuffix);
        }

        public SlingHttpResponse setText(String text, int ... expectedStatus) throws ClientException {
            FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./text", text).addParameter("./textIsRich", "true");
            return this.client.doPost(this.textComponentPath, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        }

        public String getText() throws ClientException {
            SlingHttpResponse response = this.client.doGet(this.textComponentPath + ".json", new int[]{200});
            JsonObject jsonResponse = (JsonObject)GSON.fromJson(response.getContent(), JsonObject.class);
            return jsonResponse.get("text").getAsString();
        }

        public boolean isRich() throws ClientException {
            SlingHttpResponse response = this.client.doGet(this.textComponentPath + ".json", new int[]{200});
            JsonObject jsonResponse = (JsonObject)GSON.fromJson(response.getContent(), JsonObject.class);
            return jsonResponse.get("textIsRich").getAsBoolean();
        }

        @Override
        public String getPath() {
            return this.textComponentPath;
        }
    }

    public static class ImageComponent
    extends Component {
        private static final String IMAGE_COMPONENT_PATH_SUFIX = "/jcr:content/root/image";
        private final String imageComponentPath;

        public ImageComponent(ExperienceFragmentsClient client, String variantPath) {
            this(client, variantPath, null);
        }

        public ImageComponent(ExperienceFragmentsClient client, String variantPath, String pathSuffix) {
            super(client, variantPath);
            this.imageComponentPath = variantPath + (StringUtils.isBlank((CharSequence)pathSuffix) ? IMAGE_COMPONENT_PATH_SUFIX : pathSuffix);
        }

        public SlingHttpResponse setImageReference(String imagePath, int ... expectedStatus) throws ClientException {
            FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "UTF-8").addParameter("./fileReference", imagePath);
            return this.client.doPost(this.imageComponentPath, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        }

        public String getImageReference() throws ClientException {
            SlingHttpResponse response = this.client.doGet(this.imageComponentPath + ".json", new int[]{200});
            JsonObject jsonResponse = (JsonObject)GSON.fromJson(response.getContent(), JsonObject.class);
            return jsonResponse.get("fileReference").getAsString();
        }

        @Override
        public String getPath() {
            return this.imageComponentPath;
        }
    }

    private static abstract class Component {
        protected ExperienceFragmentsClient client;
        protected String variantPath;

        public Component(ExperienceFragmentsClient client, String variantPath) {
            this.client = client;
            this.variantPath = variantPath;
        }

        public abstract String getPath();
    }

    public static class ConvertToXFAction {
        ExperienceFragmentsClient client;

        public ConvertToXFAction(ExperienceFragmentsClient client) {
            this.client = client;
        }

        public SlingHttpResponse createNewExperienceFragment(String componentPath, @Nullable String parentPath, String xfTitle, @Nullable List<String> xfTags, String variantTitle, String variantTemplate, @Nullable List<String> variantTags, int ... expectedStatus) throws ClientException {
            FormEntityBuilder entityBuilder = FormEntityBuilder.create().addParameter("action", "createXf").addParameter("componentPath", componentPath).addParameter("xfParentPath", parentPath != null ? parentPath : ExperienceFragmentsClient.DEFAULT_XF_PARENT_PATH).addParameter("pageTitle", xfTitle).addParameter("variantTemplate", variantTemplate).addParameter("variantTitle", variantTitle);
            if (xfTags != null) {
                for (String xfTag : xfTags) {
                    entityBuilder.addParameter(ExperienceFragmentsClient.TAGS_PROP, xfTag);
                }
            }
            if (variantTags != null) {
                for (String variantTag : variantTags) {
                    entityBuilder.addParameter("variantTags", variantTag);
                }
            }
            return this.client.doPost(ExperienceFragmentsClient.CONVERT_TO_XF, (HttpEntity)entityBuilder.build(), HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        }

        public SlingHttpResponse createNewExperienceFragment(String componentPath, String parentPath, String xfTitle, List<String> xfTags, String variantTitle, XF_TEMPLATE variantTemplate, List<String> variantTags, int ... expectedStatus) throws ClientException {
            return this.createNewExperienceFragment(componentPath, parentPath, xfTitle, xfTags, variantTitle, variantTemplate.path(), variantTags, expectedStatus);
        }

        public SlingHttpResponse addToAnExistingXF(String componentPath, String parentXFPath, String variantTitle, String variantTemplate, @Nullable List<String> variantTags, int ... expectedStatus) throws ClientException {
            FormEntityBuilder entityBuilder = FormEntityBuilder.create().addParameter("action", "createVariation").addParameter("componentPath", componentPath).addParameter("variantTemplate", variantTemplate).addParameter("variationParentPath", parentXFPath).addParameter("variantTitle", variantTitle);
            if (variantTags != null) {
                for (String tag : variantTags) {
                    entityBuilder.addParameter("variantTags", tag);
                }
            }
            return this.client.doPost(ExperienceFragmentsClient.CONVERT_TO_XF, (HttpEntity)entityBuilder.build(), HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        }

        public SlingHttpResponse addToAnExistingXF(String componentPath, String parentXFPath, String variantTitle, XF_TEMPLATE variantTemplate, @Nullable List<String> variantTags, int ... expectedStatus) throws ClientException {
            return this.addToAnExistingXF(componentPath, parentXFPath, variantTitle, variantTemplate.path(), variantTags, expectedStatus);
        }
    }

    public static class ExperienceFragmentVariantBuilder {
        private ExperienceFragmentsClient client;
        private String parentPath;
        private String template;
        private String title;
        private String name;
        private List<String> tags = new ArrayList<String>();
        private String description;

        public ExperienceFragmentVariantBuilder(ExperienceFragmentsClient client, String parentPath, String template, String title) {
            this.client = client;
            this.parentPath = parentPath;
            this.template = template;
            this.title = title;
        }

        public ExperienceFragmentVariantBuilder withName(String name) {
            this.name = name;
            return this;
        }

        public ExperienceFragmentVariantBuilder withDescription(String description) {
            this.description = description;
            return this;
        }

        public ExperienceFragmentVariantBuilder addTag(String tag) {
            this.tags.add(tag);
            return this;
        }

        public ExperienceFragmentVariantBuilder addTags(List<String> tags) {
            this.tags.addAll(tags);
            return this;
        }

        public SlingHttpResponse create(int ... expectedStatus) throws ClientException {
            FormEntityBuilder entityBuilder = FormEntityBuilder.create().addParameter("parentPath", this.parentPath).addParameter("template", this.template).addParameter("pageName", this.name).addParameter("./jcr:title", this.title).addParameter("./jcr:description", this.description);
            for (String tag : this.tags) {
                entityBuilder.addParameter("./cq:tags", tag);
            }
            return this.client.doPost(ExperienceFragmentsClient.XF_VARIANT_CREATE_WIZARD, (HttpEntity)entityBuilder.build(), HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        }
    }

    public class ExperienceFragmentBuilder {
        private ExperienceFragmentsClient xfClient;
        private String variantTemplate;
        private String parentPath = "/content/experience-fragments";
        private String xfName;
        private String xfTitle;
        private String xfDescription;
        private List<String> xfTags = new ArrayList<String>();
        private String variantName;
        private String variantTitle;
        private List<String> variantTags = new ArrayList<String>();

        public ExperienceFragmentBuilder(ExperienceFragmentsClient client, String xfTitle, String variantTitle, String variantTemplate) {
            this.xfTitle = xfTitle;
            this.variantTitle = variantTitle;
            this.variantTemplate = variantTemplate;
            this.xfClient = client;
        }

        public ExperienceFragmentBuilder withParentPath(String parentPath) {
            this.parentPath = parentPath;
            return this;
        }

        public ExperienceFragmentBuilder withXFName(String xfName) {
            this.xfName = xfName;
            return this;
        }

        public ExperienceFragmentBuilder withXFDescription(String description) {
            this.xfDescription = description;
            return this;
        }

        public ExperienceFragmentBuilder addXFTag(String xfTag) {
            this.xfTags.add(xfTag);
            return this;
        }

        public ExperienceFragmentBuilder addXFTags(List<String> xfTags) {
            this.xfTags.addAll(xfTags);
            return this;
        }

        public ExperienceFragmentBuilder withVariantName(String variantName) {
            this.variantName = variantName;
            return this;
        }

        public ExperienceFragmentBuilder addVariantTag(String variantTag) {
            this.variantTags.add(variantTag);
            return this;
        }

        public ExperienceFragmentBuilder addVariantTags(List<String> variantTags) {
            this.variantTags.addAll(variantTags);
            return this;
        }

        public SlingHttpResponse create(int ... expectedStatus) throws ClientException {
            FormEntityBuilder entityBuilder = FormEntityBuilder.create().addParameter("parentPath", this.parentPath).addParameter("pageTitle", this.xfTitle).addParameter("pageName", this.xfName).addParameter("./jcr:description", this.xfDescription).addParameter("variantTitle", this.variantTitle).addParameter("variantName", this.variantName).addParameter("variantTemplate", this.variantTemplate);
            for (String xfTag : this.xfTags) {
                entityBuilder.addParameter("./cq:tags", xfTag);
            }
            for (String variantTag : this.variantTags) {
                entityBuilder.addParameter("variantTags", variantTag);
            }
            return this.xfClient.doPost(ExperienceFragmentsClient.XF_CREATE_WIZARD, (HttpEntity)entityBuilder.build(), HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        }
    }

    public static enum XF_TEMPLATE implements XFTemplate
    {
        WEB{

            @Override
            public String path() {
                return ExperienceFragmentsClient.WEB_TEMPLATE_PATH;
            }

            @Override
            public <T extends VariantComponents> T getComponents(ExperienceFragmentsClient xfClient, String variantPath) {
                throw new UnsupportedOperationException("Cannot determine components for " + WEB);
            }

            @Override
            public boolean isSocialTemplate() {
                return false;
            }

            @Override
            public List<String> tags() {
                return Collections.singletonList(XF_TAG.WEB.tagID());
            }

            @Override
            public String variantType() {
                return ExperienceFragmentsClient.WEB_XF_VARIANT_TYPE;
            }
        }
        ,
        FACEBOOK{

            @Override
            public String path() {
                return ExperienceFragmentsClient.FACEBOOK_TEMPLATE_PATH;
            }

            @Override
            public <T extends VariantComponents> T getComponents(ExperienceFragmentsClient xfClient, String variantPath) {
                return (T)new FacebookVariantComponents(xfClient, variantPath);
            }

            @Override
            public boolean isSocialTemplate() {
                return true;
            }

            @Override
            public List<String> tags() {
                return Collections.singletonList(XF_TAG.FACEBOOK.tagID());
            }

            @Override
            public String variantType() {
                return ExperienceFragmentsClient.FACEBOOK_XF_VARIANT_TYPE;
            }
        }
        ,
        PINTEREST{

            @Override
            public String path() {
                return ExperienceFragmentsClient.PINTEREST_TEMPLATE_PATH;
            }

            @Override
            public <T extends VariantComponents> T getComponents(ExperienceFragmentsClient xfClient, String variantPath) {
                return (T)new PinterestVariantComponents(xfClient, variantPath);
            }

            @Override
            public boolean isSocialTemplate() {
                return true;
            }

            @Override
            public List<String> tags() {
                return Collections.singletonList(XF_TAG.PINTEREST.tagID());
            }

            @Override
            public String variantType() {
                return ExperienceFragmentsClient.PINTEREST_XF_VARIANT_TYPE;
            }
        }
        ,
        CUSTOM{

            @Override
            public String path() {
                throw new UnsupportedOperationException("Cannot determine path for custom templates through Enum");
            }

            @Override
            public <T extends VariantComponents> T getComponents(ExperienceFragmentsClient xfClient, String variantPath) {
                throw new UnsupportedOperationException("Cannot determine components for custom templates");
            }

            @Override
            public boolean isSocialTemplate() {
                return false;
            }

            @Override
            public List<String> tags() {
                throw new UnsupportedOperationException("Cannot determine tags for custom templates");
            }

            @Override
            public String variantType() {
                return ExperienceFragmentsClient.CUSTOM_XF_VARIANT_TYPE;
            }
        };

    }

    public static enum XF_TAG implements XFTag
    {
        EXPERIENCE_FRAGMENTS{

            @Override
            public String tagID() {
                return ExperienceFragmentsClient.EXPERIENCE_FRAGMENTS_TAG;
            }
        }
        ,
        VARIATION{

            @Override
            public String tagID() {
                return ExperienceFragmentsClient.VARIATION_TAG;
            }
        }
        ,
        WEB{

            @Override
            public String tagID() {
                return ExperienceFragmentsClient.WEB_TAG_ID;
            }
        }
        ,
        FACEBOOK{

            @Override
            public String tagID() {
                return ExperienceFragmentsClient.FACEBOOK_TAG_ID;
            }
        }
        ,
        PINTEREST{

            @Override
            public String tagID() {
                return ExperienceFragmentsClient.PINTEREST_TAG_ID;
            }
        };

    }

    public static class FacebookVariantComponents
    extends VariantComponents
    implements TextVariantComponents,
    ImageVariantComponents,
    ContentFragmentVariantCompoents {
        private ImageComponent imageComponent;
        private TextComponent textComponent;
        private ContentFragmentComponent contentFragmentComponent;

        public FacebookVariantComponents(ExperienceFragmentsClient xfClient, String variantPath) {
            super(xfClient, variantPath);
            this.imageComponent = new ImageComponent(xfClient, variantPath);
            this.textComponent = new TextComponent(xfClient, variantPath);
            this.contentFragmentComponent = new ContentFragmentComponent(xfClient, variantPath);
        }

        @Override
        public ContentFragmentComponent getContentFragment() {
            return this.contentFragmentComponent;
        }

        @Override
        public ImageComponent getImageComponent() {
            return this.imageComponent;
        }

        @Override
        public TextComponent getTextComponent() {
            return this.textComponent;
        }
    }

    public static class PinterestVariantComponents
    extends VariantComponents
    implements TextVariantComponents,
    ImageVariantComponents,
    ContentFragmentVariantCompoents {
        private ImageComponent imageComponent;
        private TextComponent textComponent;
        private ContentFragmentComponent contentFragmentComponent;

        public PinterestVariantComponents(ExperienceFragmentsClient xfClient, String variantPath) {
            super(xfClient, variantPath);
            this.imageComponent = new ImageComponent(xfClient, variantPath);
            this.textComponent = new TextComponent(xfClient, variantPath);
            this.contentFragmentComponent = new ContentFragmentComponent(xfClient, variantPath);
        }

        @Override
        public ContentFragmentComponent getContentFragment() {
            return this.contentFragmentComponent;
        }

        @Override
        public ImageComponent getImageComponent() {
            return this.imageComponent;
        }

        @Override
        public TextComponent getTextComponent() {
            return this.textComponent;
        }
    }

    public static class POSVariantComponents
    extends VariantComponents
    implements TextVariantComponents,
    ContentFragmentVariantCompoents {
        private ContentFragmentComponent contentFragmentComponent;
        private TextComponent textComponent;

        public POSVariantComponents(ExperienceFragmentsClient xfClient, String variantPath) {
            super(xfClient, variantPath);
            this.contentFragmentComponent = new ContentFragmentComponent(xfClient, variantPath);
            this.textComponent = new TextComponent(xfClient, variantPath);
        }

        @Override
        public ContentFragmentComponent getContentFragment() {
            return this.contentFragmentComponent;
        }

        @Override
        public TextComponent getTextComponent() {
            return this.textComponent;
        }
    }

    public static interface ContentFragmentVariantCompoents {
        public ContentFragmentComponent getContentFragment();
    }

    public static interface ImageVariantComponents {
        public ImageComponent getImageComponent();
    }

    public static interface TextVariantComponents {
        public TextComponent getTextComponent();
    }

    public static class VariantComponents {
        protected String variantPath;
        protected ExperienceFragmentsClient xfClient;

        public VariantComponents(ExperienceFragmentsClient xfClient, String variantPath) {
            this.xfClient = xfClient;
            this.variantPath = variantPath;
        }
    }

    public static interface XFTag {
        public String tagID();
    }

    public static interface XFTemplate {
        public String path();

        public <T extends VariantComponents> T getComponents(ExperienceFragmentsClient var1, String var2);

        public boolean isSocialTemplate();

        public List<String> tags();

        public String variantType();
    }
}

