/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.components.collab;

import com.fasterxml.jackson.databind.JsonNode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Rating {
    public static final String RESOURCE_TYPE = "collab/commons/components/ratings/rating";
    public static final String PRIMARY_TYPE = "cq:Rating";
    private Date added;
    private int rating;
    private String description;
    private String url;
    private String userAgent;
    private String email;
    private boolean approved;
    private String userIdentifier;
    private String createdBy;

    public Rating(Date added, int rating, String description, String url, String userAgent, String email, boolean approved, String userIdentifier, String createdBy) {
        this.added = added;
        this.rating = rating;
        this.description = description;
        this.url = url;
        this.userAgent = userAgent;
        this.email = email;
        this.approved = approved;
        this.userIdentifier = userIdentifier;
        this.createdBy = createdBy;
    }

    public Rating(JsonNode node) {
        try {
            SimpleDateFormat format = new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss");
            this.added = format.parse(node.get("added").textValue());
        }
        catch (ParseException e) {
            this.added = null;
        }
        this.rating = node.get("rating").intValue();
        this.description = node.get("jcr:description").textValue();
        this.url = node.get("url").textValue();
        this.userAgent = node.get("userAgent").textValue();
        this.email = node.get("email").textValue();
        this.approved = node.get("approved") != null && node.get("approved").booleanValue();
        this.userIdentifier = node.get("userIdentifier").textValue();
        this.createdBy = node.get("jcr:createdBy").textValue();
    }

    public Date getAdded() {
        return this.added;
    }

    public void setAdded(Date added) {
        this.added = added;
    }

    public int getRating() {
        return this.rating;
    }

    public void setRating(int rating) {
        this.rating = rating;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public void setApproved(boolean approved) {
        this.approved = approved;
    }

    public String getUserIdentifier() {
        return this.userIdentifier;
    }

    public void setUserIdentifier(String userIdentifier) {
        this.userIdentifier = userIdentifier;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public static String getResourceType() {
        return RESOURCE_TYPE;
    }

    public static String getPrimaryType() {
        return PRIMARY_TYPE;
    }
}

