/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.security.AbstractAuthorizable;
import com.adobe.cq.testing.client.security.Profile;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.apache.sling.testing.clients.ClientException;

public class AbstractProfile
implements Profile {
    public static final String NODE_PROFILE = "profile";
    protected AbstractAuthorizable authorizable;
    protected LinkedHashMap<String, String> profileProps = new LinkedHashMap();

    public <T extends AbstractAuthorizable> AbstractProfile(T authorizable) throws ClientException {
        if (authorizable == null) {
            throw new IllegalArgumentException("Authorizable has to exist and therefore may not be null!");
        }
        this.authorizable = authorizable;
        this.loadProperties();
    }

    public JsonNode getProfileNode() throws ClientException {
        return this.authorizable.getProfile();
    }

    @Override
    public HashMap<String, String> getProperties() {
        return this.profileProps;
    }

    @Override
    public void setProperties(HashMap<String, String> propertiesMap) {
        if (propertiesMap == null) {
            throw new IllegalArgumentException("Properties map for profile may not be empty!");
        }
        this.profileProps.putAll(propertiesMap);
    }

    private void loadProperties() throws ClientException {
        JsonNode profileNode = this.getProfileNode();
        if (profileNode != null) {
            Iterator fieldNames = profileNode.fieldNames();
            while (fieldNames.hasNext()) {
                String fieldName = (String)fieldNames.next();
                this.profileProps.put(fieldName, profileNode.get(fieldName).textValue());
            }
        }
    }
}

