/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.indexing.IndexingClient;
import org.apache.sling.testing.clients.interceptors.FormBasedAuthInterceptor;
import org.apache.sling.testing.clients.interceptors.HttpRequestResponseInterceptor;
import org.apache.sling.testing.junit.rules.instance.BuilderCustomizer;
import org.apache.sling.testing.junit.rules.instance.ExistingInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableInstance
extends ExistingInstance {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableInstance.class);
    public static final String LOGIN_TOKEN_AUTH = "it.logintokenauth";
    private static final String DETECT_INDEXING_LANES = "it.detectIndexingLanes";
    private final boolean useLoginToken;
    private static final String[] DEFAULT_INDEXING_LANES = new String[]{"async", "fulltext-async"};
    private final boolean detectIndexLanes;

    public ConfigurableInstance(boolean forceBasicAuth) {
        this(forceBasicAuth, false);
    }

    public ConfigurableInstance(boolean forceBasicAuth, boolean forceIndexLaneDetection) {
        this.useLoginToken = !forceBasicAuth && ConfigurableInstance.loginTokenAuth();
        this.detectIndexLanes = forceIndexLaneDetection || ConfigurableInstance.shouldDetectIndexingLanes();
        LOG.info("Using instances with config: [authentication method: {}, indexing lanes detection: {}]", (Object)(this.useLoginToken ? "LoginToken" : "Basic"), (Object)this.detectIndexLanes);
    }

    public <T extends SlingClient> T newClient(Class<T> clientClass, String user, String pass, BuilderCustomizer ... customizers) {
        return (T)this.injectLaneNames(super.newClient(clientClass, user, pass, customizers));
    }

    public <T extends SlingClient.InternalBuilder> T customize(T builder) {
        if (this.useLoginToken) {
            Registry authSchemeRegistry = RegistryBuilder.create().build();
            builder.httpClientBuilder().setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
            builder.setPreemptiveAuth(false).addInterceptorFirst((HttpRequestResponseInterceptor)new FormBasedAuthInterceptor("login-token"));
            return builder;
        }
        return (T)super.customize(builder);
    }

    private static boolean shouldDetectIndexingLanes() {
        return Boolean.getBoolean(DETECT_INDEXING_LANES);
    }

    private <T extends SlingClient> T injectLaneNames(T in) {
        if (in != null && !this.detectIndexLanes) {
            try {
                IndexingClient client = (IndexingClient)in.adaptTo(IndexingClient.class);
                client.setLaneNames(DEFAULT_INDEXING_LANES);
            }
            catch (ClientException ce) {
                LOG.error("Error occurred while configuring indexing lanes. Returning null", (Throwable)ce);
                in = null;
            }
        }
        return in;
    }

    private static boolean loginTokenAuth() {
        if (System.getProperties().contains(LOGIN_TOKEN_AUTH)) {
            return Boolean.getBoolean(LOGIN_TOKEN_AUTH);
        }
        return true;
    }
}

