/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules.logfile;

import com.adobe.cq.testing.junit.rules.logfile.LogFileRuleConfig;
import com.adobe.cq.testing.junit.rules.logfile.LogFileRuleStatement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class LogFileRule
implements MethodRule {
    private List<String> errors = new ArrayList<String>();
    private LogFileRuleConfig ruleConfig;

    public Statement apply(Statement baseStatement, FrameworkMethod frameworkMethod, Object o) {
        LogFileRuleConfig ruleConfig = (LogFileRuleConfig)frameworkMethod.getAnnotation(LogFileRuleConfig.class);
        if (ruleConfig != null) {
            this.ruleConfig = ruleConfig;
            return new LogFileRuleStatement(this, baseStatement);
        }
        this.ruleConfig = null;
        return baseStatement;
    }

    public void setErrors(List<String> errors) {
        this.errors = errors;
    }

    public List<String> getErrors() {
        return this.errors;
    }

    public LogFileRuleConfig getRuleConfig() {
        return this.ruleConfig;
    }

    public String getEndMarkerForLogFile(String logFileName) {
        String endMarker = null;
        for (String currentEndMarker : this.ruleConfig.endMarkers()) {
            String[] parts = currentEndMarker.split(";");
            if (parts.length != 2) {
                throw new IllegalArgumentException("end marker not valid, must be of form <logfileName>;<endMarkerString>");
            }
            String currentLogFileName = parts[0];
            if (StringUtils.isBlank((CharSequence)currentLogFileName)) {
                throw new IllegalArgumentException("logfileName must not be blank");
            }
            if (!currentLogFileName.equals(logFileName)) continue;
            endMarker = parts[1];
            break;
        }
        if (StringUtils.isBlank(endMarker)) {
            throw new IllegalArgumentException("end marker must not be blank");
        }
        return endMarker;
    }
}

