/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util.instanceconfig;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.TopologyClient;
import com.adobe.cq.testing.client.offloading.OffloadingBrowserClient;
import com.adobe.cq.testing.client.offloading.OffloadingInstanceConfiguration;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;

public class TopicInstanceConfig
implements InstanceConfig {
    private final OffloadingBrowserClient obClient;
    private final String slingId;
    private final String topic;
    private boolean enabled;

    public <T extends CQClient> TopicInstanceConfig(T client, String topic) throws ClientException, InstanceConfigException {
        this.topic = topic;
        this.obClient = (OffloadingBrowserClient)client.adaptTo(OffloadingBrowserClient.class);
        TopologyClient tClient = (TopologyClient)this.obClient.adaptTo(TopologyClient.class);
        this.slingId = tClient.getSlingId();
        this.save();
    }

    public InstanceConfig save() throws InstanceConfigException {
        String slingId;
        try {
            TopologyClient tClient = (TopologyClient)this.obClient.adaptTo(TopologyClient.class);
            slingId = tClient.getSlingId();
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Could not get sling id", (Throwable)e);
        }
        try {
            OffloadingInstanceConfiguration instance = this.obClient.getInstance(slingId);
            this.enabled = instance.topics.contains(this.topic);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Could not save configuration", (Throwable)e);
        }
        return this;
    }

    public InstanceConfig restore() throws InstanceConfigException {
        try {
            this.obClient.enableDisableTopicWithWait(this.slingId, this.topic, this.enabled, 30L);
        }
        catch (ClientException e) {
            throw new InstanceConfigException("Could not restore configuration", (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new InstanceConfigException("Restoring configuration was interrupted", (Throwable)e);
        }
        return this;
    }
}

