/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules.toggles;

import com.adobe.cq.testing.client.TogglesClient;
import com.adobe.cq.testing.junit.rules.toggles.RunIfToggleEnabled;
import com.adobe.cq.testing.junit.rules.toggles.SkipIfToggleEnabled;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.junit.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TogglesAwareTestRule
implements TestRule {
    private static final Logger LOG = LoggerFactory.getLogger(TogglesAwareTestRule.class);
    private final Supplier<SlingClient> clientSupplier;

    public TogglesAwareTestRule(Supplier<SlingClient> clientSupplier) {
        this.clientSupplier = clientSupplier;
    }

    public Statement apply(Statement base, Description description) {
        if (this.shouldRunTest(description)) {
            return base;
        }
        return this.emptyStatement(description.getDisplayName());
    }

    protected boolean shouldRunTest(Description description) {
        Optional<String> runIfToggle = this.getRunIfToggle(description);
        Optional<String> skipIfToggle = this.getSkipIfToggle(description);
        if (!runIfToggle.isPresent() && !skipIfToggle.isPresent()) {
            return true;
        }
        AtomicReference enabledToggles = new AtomicReference();
        try {
            new Polling(() -> {
                enabledToggles.set(((TogglesClient)this.clientSupplier.get().adaptTo(TogglesClient.class)).getEnabledToggles());
                return true;
            }).poll(TimeUnit.SECONDS.toMillis(30L), TimeUnit.SECONDS.toMillis(1L));
        }
        catch (TimeoutException e) {
            LOG.warn("Failed to retrieve toggles", (Throwable)e);
            return true;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
        if (runIfToggle.filter(s -> !((List)enabledToggles.get()).contains(s)).isPresent()) {
            return false;
        }
        return !skipIfToggle.filter(s -> ((List)enabledToggles.get()).contains(s)).isPresent();
    }

    private Optional<String> getRunIfToggle(Description description) {
        RunIfToggleEnabled annotation = (RunIfToggleEnabled)description.getAnnotation(RunIfToggleEnabled.class);
        return Optional.ofNullable(annotation).map(RunIfToggleEnabled::value);
    }

    private Optional<String> getSkipIfToggle(Description description) {
        SkipIfToggleEnabled annotation = (SkipIfToggleEnabled)description.getAnnotation(SkipIfToggleEnabled.class);
        return Optional.ofNullable(annotation).map(SkipIfToggleEnabled::value);
    }

    private Statement emptyStatement(final String testName) {
        return new Statement(){

            public void evaluate() {
                throw new AssumptionViolatedException("Test " + testName + " was ignored by TogglesAwareTestRule");
            }
        };
    }
}

