/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.workflow;

import com.adobe.cq.testing.client.WorkflowClient;
import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class WorkItem {
    private JsonNode rootNode = null;

    public WorkItem(JsonNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getId() {
        if (this.rootNode.get("id") == null) {
            return null;
        }
        return this.rootNode.get("id").asText();
    }

    public String getInstanceURI() {
        if (this.rootNode.get("instance") == null) {
            return null;
        }
        return this.rootNode.get("instance").asText();
    }

    public String getModelId() {
        if (this.rootNode.get("model") == null) {
            return null;
        }
        return this.rootNode.get("model").asText();
    }

    public String getNodeId() {
        if (this.rootNode.get("node") == null) {
            return null;
        }
        return this.rootNode.get("node").asText();
    }

    public Date getStartDate() {
        if (this.rootNode.get("startTime") == null) {
            return null;
        }
        return WorkflowClient.parseJSONDate(this.rootNode.get("startTime").asText());
    }

    public String getPayloadType() {
        if (this.rootNode.get("payloadType") == null) {
            return null;
        }
        return this.rootNode.get("payloadType").asText();
    }

    public String getPayLoad() {
        if (this.rootNode.get("payload") == null) {
            return null;
        }
        return this.rootNode.get("payload").asText();
    }

    public Map getProperties() {
        if (this.rootNode.get("properties") == null) {
            return null;
        }
        JsonNode properties = this.rootNode.get("properties");
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < properties.size(); ++i) {
            JsonNode property = properties.get(i);
            map.put(property.get("key").asText(), property.get("value").asText());
        }
        return map;
    }

    public ArrayList<Route> getRoutes() {
        if (this.rootNode.get("routes") == null) {
            return null;
        }
        JsonNode routes = this.rootNode.get("routes");
        ArrayList<Route> list = new ArrayList<Route>();
        for (int i = 0; i < routes.size(); ++i) {
            list.add(new Route(routes.get(i)));
        }
        return list;
    }

    public ArrayList<Delegatee> getDelegatees() {
        if (this.rootNode.get("delegatees") == null) {
            return null;
        }
        JsonNode delegatees = this.rootNode.get("delegatees");
        ArrayList<Delegatee> list = new ArrayList<Delegatee>();
        for (int i = 0; i < delegatees.size(); ++i) {
            list.add(new Delegatee(delegatees.get(i)));
        }
        return list;
    }

    public class Route {
        private JsonNode routeNode = null;

        protected Route(JsonNode node) {
            this.routeNode = node;
        }

        public String getId() {
            if (this.routeNode.get("id") == null) {
                return null;
            }
            return this.routeNode.get("id").asText();
        }

        public String getName() {
            if (this.routeNode.get("name") == null) {
                return null;
            }
            return this.routeNode.get("name").asText();
        }

        public Map<String, String> getDestinations() {
            if (this.routeNode.get("destinations") == null) {
                return null;
            }
            JsonNode destinations = this.routeNode.get("destinations");
            HashMap<String, String> map = new HashMap<String, String>();
            for (int i = 0; i < destinations.size(); ++i) {
                JsonNode destination = destinations.get(i);
                map.put(destination.get("id").asText(), destination.get("title").textValue());
            }
            return map;
        }
    }

    public class Delegatee {
        private JsonNode delNode = null;

        protected Delegatee(JsonNode node) {
            this.delNode = node;
        }

        public String getId() {
            if (this.delNode.get("id") == null) {
                return null;
            }
            return this.delNode.get("id").asText();
        }

        public String getName() {
            if (this.delNode.get("name") == null) {
                return null;
            }
            return this.delNode.get("name").asText();
        }

        public String getType() {
            if (this.delNode.get("type") == null) {
                return null;
            }
            return this.delNode.get("type").asText();
        }
    }
}

