/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.JsonClient;
import com.adobe.cq.testing.client.components.AbstractComponent;
import com.adobe.cq.testing.client.components.collab.Ratings;
import com.adobe.cq.testing.client.components.commerce.ShoppingCart;
import com.adobe.cq.testing.client.components.foundation.Carousel;
import com.adobe.cq.testing.client.components.foundation.Chart;
import com.adobe.cq.testing.client.components.foundation.Download;
import com.adobe.cq.testing.client.components.foundation.External;
import com.adobe.cq.testing.client.components.foundation.Flash;
import com.adobe.cq.testing.client.components.foundation.Image;
import com.adobe.cq.testing.client.components.foundation.List;
import com.adobe.cq.testing.client.components.foundation.ParSys;
import com.adobe.cq.testing.client.components.foundation.Reference;
import com.adobe.cq.testing.client.components.foundation.Search;
import com.adobe.cq.testing.client.components.foundation.Sitemap;
import com.adobe.cq.testing.client.components.foundation.Slideshow;
import com.adobe.cq.testing.client.components.foundation.Table;
import com.adobe.cq.testing.client.components.foundation.Text;
import com.adobe.cq.testing.client.components.foundation.TextImage;
import com.adobe.cq.testing.client.components.foundation.Title;
import com.adobe.cq.testing.client.components.foundation.form.Address;
import com.adobe.cq.testing.client.components.foundation.form.Captcha;
import com.adobe.cq.testing.client.components.foundation.form.Checkbox;
import com.adobe.cq.testing.client.components.foundation.form.Dropdown;
import com.adobe.cq.testing.client.components.foundation.form.End;
import com.adobe.cq.testing.client.components.foundation.form.FileUpload;
import com.adobe.cq.testing.client.components.foundation.form.Hidden;
import com.adobe.cq.testing.client.components.foundation.form.ImageButton;
import com.adobe.cq.testing.client.components.foundation.form.ImageUpload;
import com.adobe.cq.testing.client.components.foundation.form.Password;
import com.adobe.cq.testing.client.components.foundation.form.RadioGroup;
import com.adobe.cq.testing.client.components.foundation.form.Start;
import com.adobe.cq.testing.client.components.foundation.parsys.ColCtrl;
import com.adobe.cq.testing.client.components.tagging.TagCloud;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.HashMap;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

public class ComponentClient
extends CQClient {
    private static final String CONFIG_KEY_RELATIVE_LOCATION = "componentDefaultRelativeLocation";
    public static final String ORDER_FIRST = "first";
    public static final String ORDER_LAST = "last";
    public static final String ORDER_BEFORE_PREFIX = "before ";
    public static final String ORDER_AFTER_PREFIX = "after ";
    private static HashMap<String, Class<? extends AbstractComponent>> components = new HashMap();

    public ComponentClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public ComponentClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public <T extends AbstractComponent> T addComponent(Class<T> componentClass, String pagePath, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.addComponent(componentClass, pagePath, null, null, null, expectedStatus);
    }

    public <T extends AbstractComponent> T addComponent(Class<T> componentClass, String pagePath, String order, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.addComponent(componentClass, pagePath, null, null, order, expectedStatus);
    }

    public <T extends AbstractComponent> T addComponent(Class<T> componentClass, String pagePath, String location, String nameHint, String order, int ... expectedStatus) throws ClientException, InterruptedException {
        AbstractComponent component;
        if (location == null) {
            location = this.getValue(CONFIG_KEY_RELATIVE_LOCATION);
        }
        try {
            Constructor<T> cons = componentClass.getConstructor(ComponentClient.class, String.class, String.class, String.class);
            component = (AbstractComponent)cons.newInstance(new Object[]{this, pagePath, location, nameHint});
        }
        catch (Exception e) {
            throw new ClientException("Instantiation failed", (Throwable)e);
        }
        component.create(order, expectedStatus);
        return (T)component;
    }

    public <T extends AbstractComponent> T getComponent(String componentPath, Class<T> compClass) throws ClientException {
        if (!this.exists(componentPath)) {
            return null;
        }
        JsonNode node = ((JsonClient)this.adaptTo(JsonClient.class)).doGetJson(componentPath, 1, new int[0]);
        if (node.get("sling:resourceType").isMissingNode()) {
            throw new ClientException(componentPath + " is not pointing to a foundation component node, no sling:resourceType property was found!");
        }
        return this.initializeComponent(componentPath, compClass);
    }

    public <T extends AbstractComponent> T getComponent(String componentPath) throws ClientException {
        if (!this.exists(componentPath)) {
            return null;
        }
        JsonNode node = ((JsonClient)this.adaptTo(JsonClient.class)).doGetJson(componentPath, 1, new int[0]);
        if (node.get("sling:resourceType").isMissingNode()) {
            throw new ClientException(componentPath + " is not pointing to a foundation component node, no sling:resourceType property was found!");
        }
        Class<? extends AbstractComponent> compClass = this.getCompClassByResourceType(node.get("sling:resourceType").textValue());
        if (compClass == null) {
            return null;
        }
        return (T)this.initializeComponent(componentPath, compClass);
    }

    private <T extends AbstractComponent> T initializeComponent(String componentPath, Class<T> compClass) throws ClientException {
        try {
            Constructor<T> cons = compClass.getConstructor(ComponentClient.class, String.class, String.class, String.class);
            String[] parts = componentPath.split("/jcr:content");
            String location = "/jcr:content" + parts[1].substring(0, parts[1].lastIndexOf("/") + 1);
            String name = componentPath.substring(componentPath.lastIndexOf("/") + 1);
            AbstractComponent comp = (AbstractComponent)cons.newInstance(new Object[]{this, parts[0], location, name});
            comp.getComponentNode();
            return (T)comp;
        }
        catch (Exception e) {
            throw new ClientException("Instantiation failed", (Throwable)e);
        }
    }

    public void registerComponent(String resourceType, Class<? extends AbstractComponent> c) {
        components.put(resourceType, c);
    }

    public Class<? extends AbstractComponent> getCompClassByResourceType(String resourceType) {
        return components.get(resourceType);
    }

    public void deleteComponent(AbstractComponent delComp) throws ClientException {
        this.deleteComponent(delComp.getComponentPath());
    }

    public void deleteComponent(String componentPath) throws ClientException {
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter(":operation", "delete").build();
        this.doPost(componentPath, (HttpEntity)entity, new int[0]);
    }

    public String getDefaultComponentRelativeLocation() {
        return this.getValue(CONFIG_KEY_RELATIVE_LOCATION);
    }

    public void setDefaultComponentRelativeLocation(String defaultComponentRelativeLocation) {
        this.getValues().put(CONFIG_KEY_RELATIVE_LOCATION, defaultComponentRelativeLocation);
    }

    static {
        components.put("foundation/components/carousel", Carousel.class);
        components.put("foundation/components/chart", Chart.class);
        components.put("foundation/components/parsys/colctrl", ColCtrl.class);
        components.put("foundation/components/download", Download.class);
        components.put("foundation/components/external", External.class);
        components.put("foundation/components/flash", Flash.class);
        components.put("foundation/components/image", Image.class);
        components.put("foundation/components/list", List.class);
        components.put("foundation/components/reference", Reference.class);
        components.put("foundation/components/search", Search.class);
        components.put("foundation/components/sitemap", Sitemap.class);
        components.put("foundation/components/slideshow", Slideshow.class);
        components.put("foundation/components/table", Table.class);
        components.put("foundation/components/text", Text.class);
        components.put("foundation/components/textimage", TextImage.class);
        components.put("foundation/components/title", Title.class);
        components.put("cq/tagging/components/tagcloud", TagCloud.class);
        components.put("foundation/components/parsys", ParSys.class);
        components.put("foundation/components/form/start", Start.class);
        components.put("foundation/components/form/end", End.class);
        components.put("foundation/components/form/text", com.adobe.cq.testing.client.components.foundation.form.Text.class);
        components.put("foundation/components/form/address", Address.class);
        components.put("foundation/components/form/captcha", Captcha.class);
        components.put("foundation/components/form/checkbox", Checkbox.class);
        components.put("foundation/components/form/dropdown", Dropdown.class);
        components.put("foundation/components/form/upload", FileUpload.class);
        components.put("foundation/components/form/image", ImageUpload.class);
        components.put("foundation/components/form/hidden", Hidden.class);
        components.put("foundation/components/form/imagebutton", ImageButton.class);
        components.put("foundation/components/form/password", Password.class);
        components.put("foundation/components/form/radio", RadioGroup.class);
        components.put("foundation/components/form/start", Start.class);
        components.put("collab/commons/components/ratings", Ratings.class);
        components.put("foundation/components/form/address", Address.class);
        components.put("commerce/components/shoppingcart", ShoppingCart.class);
    }
}

