/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.fasterxml.jackson.databind.JsonNode;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicationClient
extends CQClient {
    private static final Logger log = LoggerFactory.getLogger(ReplicationClient.class);
    public static final String AUTHOR_GROUP_PATH = "/etc/replication/agents.author";
    public static final String PUBLISH_REPLICATION_DEFAULT_AGENT = "/etc/replication/agents.author/publish";
    public static final String PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT = "/etc/replication/agents.author/publish_reverse";
    private static final String SYSTEM_USE_DISTRIBUTION = "granite.it.useDistribution";
    private static final boolean isDistribution = "true".equals(System.getProperty("granite.it.useDistribution", null));
    public static final String DIST_AGENTS_PATH = "/libs/sling/distribution/services/agents";

    public ReplicationClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public ReplicationClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public SlingHttpResponse activate(String agent, String nodePath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntityBuilder = FormEntityBuilder.create().addParameter("cmd", "Activate").addParameter("_charset_", "utf-8").addParameter("path", nodePath);
        if (StringUtils.isNotBlank((CharSequence)agent)) {
            formEntityBuilder.addParameter("agentId", agent);
        }
        return this.doPost("/bin/replicate.json", (HttpEntity)formEntityBuilder.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse activate(String nodePath, int ... expectedStatus) throws ClientException {
        return this.activate("", nodePath, expectedStatus);
    }

    public SlingHttpResponse deactivate(String agent, String pagePath, int ... expectedStatus) throws ClientException {
        FormEntityBuilder formEntityBuilder = FormEntityBuilder.create().addParameter("cmd", "Deactivate").addParameter("_charset_", "utf-8").addParameter("path", pagePath);
        if (StringUtils.isNotBlank((CharSequence)agent)) {
            formEntityBuilder.addParameter("agentId", agent);
        }
        return this.doPost("/bin/replicate.json", (HttpEntity)formEntityBuilder.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deactivate(String pagePath, int ... expectedStatus) throws ClientException {
        return this.deactivate("", pagePath, expectedStatus);
    }

    public SlingHttpResponse activateLater(String nodePath, long timeMilliseconds, int ... expectedStatus) throws ClientException {
        Calendar now = Calendar.getInstance();
        long currentTime = now.getTimeInMillis();
        long scheduledTime = currentTime + timeMilliseconds;
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("model", "/etc/workflow/models/scheduled_activation/jcr:content/model").addParameter("_charset_", "utf-8").addParameter("absoluteTime", Long.toString(scheduledTime)).addParameter("payload", nodePath).addParameter("payloadType", "JCR_PATH").build();
        return this.doPost("/etc/workflow/instances", (HttpEntity)entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public SlingHttpResponse deactivateLater(String nodePath, long timeMilliseconds, int ... expectedStatus) throws ClientException {
        Calendar now = Calendar.getInstance();
        long currentTime = now.getTimeInMillis();
        long scheduledTime = currentTime + timeMilliseconds;
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addParameter("model", "/etc/workflow/models/scheduled_deactivation/jcr:content/model").addParameter("_charset_", "utf-8").addParameter("absoluteTime", Long.toString(scheduledTime)).addParameter("payload", nodePath).addParameter("payloadType", "JCR_PATH").build();
        return this.doPost("/etc/workflow/instances", (HttpEntity)entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public JsonNode createReplicationAgent(String name, String title, String parentPath, String template, BasicNameValuePair ... properties) throws ClientException, InterruptedException {
        SlingHttpResponse page = this.createPage(name, title, parentPath, template, 201, 200);
        String agentPath = page.getSlingPath();
        return this.adaptReplicationAgent(agentPath, properties);
    }

    public JsonNode adaptReplicationAgent(final String agentPath, BasicNameValuePair ... properties) throws ClientException, InterruptedException {
        if ("".equals(agentPath) || agentPath == null) {
            throw new IllegalArgumentException("agentPath may not be null.");
        }
        UrlEncodedFormEntity entity = FormEntityBuilder.create().addAllParameters(Arrays.asList(properties)).build();
        try {
            new Polling((HttpEntity)entity){
                final /* synthetic */ HttpEntity val$entity;
                {
                    this.val$entity = httpEntity;
                }

                public Boolean call() throws Exception {
                    ReplicationClient.this.doPost(agentPath + "/jcr:content", this.val$entity, new int[]{200});
                    return true;
                }
            }.poll(10000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to adapt replication agent" + agentPath, (Throwable)e);
        }
        return this.doGetJson(agentPath, -1, new int[0]).get("jcr:content");
    }

    public JsonNode getAgentReplicationQueue(String agentPath) throws ClientException, InterruptedException {
        try {
            this.waitExists(agentPath + "/_jcr_content.queue", 5000L, 500L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to retrieve queue for replication agent " + agentPath, (Throwable)e);
        }
        return this.doGetJson(agentPath + "/_jcr_content.queue", -1, new int[]{200}).get("queue");
    }

    public Boolean checkContentDistributionAgentExists(String agent) throws ClientException {
        JsonNode agents = this.doGetJson(DIST_AGENTS_PATH, 3, new int[0]);
        log.info("Replication agents list: {}", (Object)agents);
        if (agents.path(agent).isMissingNode()) {
            log.warn("Default distribution agent {} is missing from the distribution list", (Object)agent);
            return false;
        }
        return true;
    }

    public boolean waitQueueEmptyOfPath(String agentPath, String replicatedPath) throws Exception {
        JsonNode queuesJson = this.doGetJson(agentPath, 2, new int[]{200, 300}).get("queues");
        log.debug("queuesJson for agentPath {} is {}", (Object)agentPath, (Object)queuesJson);
        Set<String> queueIds = ReplicationClient.elementsAsText(queuesJson.get("items"));
        for (String queueId : queueIds) {
            Set<String> paths;
            Set<String> pkgs;
            Iterator<String> iterator;
            JsonNode queueJson = queuesJson.get(queueId);
            boolean isEmpty = queueJson.get("empty").booleanValue();
            log.debug("Queue {} is empty {}", (Object)queueId, (Object)isEmpty);
            if (isEmpty || !(iterator = (pkgs = ReplicationClient.elementsAsText(queueJson.get("items"))).iterator()).hasNext()) continue;
            String pkg = iterator.next();
            JsonNode pkgJson = queueJson.get(pkg);
            if (pkgJson != null && (paths = ReplicationClient.elementsAsText(pkgJson.get("paths"))).contains(replicatedPath)) {
                log.warn("The replication queue {} is blocked by the item {} with paths {} due to {}.", new Object[]{queueId, pkg, paths, pkgJson.get("errorMessage")});
            }
            log.warn("The replication queue {} is blocked by the item {}.", (Object)queueId, (Object)pkg);
            return false;
        }
        return true;
    }

    private static Set<String> elementsAsText(JsonNode queue) {
        return ReplicationClient.elements(queue).map(JsonNode::textValue).collect(Collectors.toSet());
    }

    private static Stream<JsonNode> elements(JsonNode node) {
        if (node == null) {
            return Stream.empty();
        }
        Iterator elementsIt = node.elements();
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(elementsIt, 16), false);
    }

    public JsonNode getPublishReplicationQueue() throws ClientException, InterruptedException {
        return this.getAgentReplicationQueue(PUBLISH_REPLICATION_DEFAULT_AGENT);
    }

    public JsonNode getReverseReplicationQueue() throws ClientException, InterruptedException {
        return this.getAgentReplicationQueue(PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT);
    }

    public void waitAgentReplicationQueueIsEmpty(String agentPath) throws InterruptedException, ClientException {
        try {
            this.getAgentReplicationQueue(agentPath);
        }
        catch (ClientException e) {
            throw new ClientException("Could not access the Queue for Replication Agent " + agentPath, (Throwable)e);
        }
        EmptyReplicationQueuePoller polling = new EmptyReplicationQueuePoller(this, agentPath);
        try {
            polling.poll(TimeUnit.MINUTES.toMillis(1L), 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("The queue for replication agent " + agentPath + "was not empty after " + polling.getWaited() + ". It still contains " + polling.queue.size() + "elements: \n" + polling.queue.toString());
        }
    }

    public void waitPublishReplicationQueueIsEmpty() throws InterruptedException, ClientException {
        this.waitAgentReplicationQueueIsEmpty(PUBLISH_REPLICATION_DEFAULT_AGENT);
    }

    public void waitReversePublishReplicationQueueIsEmpty() throws InterruptedException, ClientException {
        this.waitAgentReplicationQueueIsEmpty(PUBLISH_REVERSE_REPLICATION_DEFAULT_AGENT);
    }

    public boolean isConnectionSuccessful(String agentLocation) throws ClientException {
        SlingHttpResponse exec = this.doGet(agentLocation + ".test.html", new int[]{200});
        return exec.getContent().contains("succeeded");
    }

    public boolean findInLog(String agentLocation, String[] patterns, Date startTime) throws ClientException {
        String[] lines;
        SlingHttpResponse exec = this.doGet(agentLocation + ".log.html", new int[]{200});
        String content = exec.getContent();
        for (String line : lines = content.split("\n")) {
            if (line.length() < 20) continue;
            String time = line.substring(0, 19);
            try {
                SimpleDateFormat logDate = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
                Date convertedLogDate = logDate.parse(time);
                if (!convertedLogDate.equals(startTime) && !convertedLogDate.after(startTime)) continue;
                for (String pattern : patterns) {
                    if (!line.contains(pattern)) continue;
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static class EmptyReplicationQueuePoller
    extends Polling {
        private final ReplicationClient client;
        private final String agentPath;
        private JsonNode queue;

        public EmptyReplicationQueuePoller(ReplicationClient client, String agentPath) {
            this.client = client;
            this.agentPath = agentPath;
        }

        public Boolean call() throws Exception {
            this.queue = this.client.getAgentReplicationQueue(this.agentPath);
            return !this.queue.elements().hasNext();
        }
    }
}

