/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.components;

import com.adobe.cq.testing.client.ComponentClient;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;

public abstract class AbstractComponent {
    protected HashMap<String, String[]> changeProperties = new HashMap();
    @Deprecated
    public static final String DEFAULT_LOCATION = "/jcr:content/par/";
    String parentPath = null;
    String name = null;
    protected ComponentClient client = null;
    protected String componentPath = null;
    protected String pagePath = null;
    protected String location = "/jcr:content/par/";
    protected JsonNode jsonNode = null;

    public AbstractComponent(ComponentClient client, String pagePath, String location, String nameHint) {
        if (location != null) {
            this.location = location;
        }
        this.parentPath = pagePath + this.location;
        this.name = nameHint == null ? this.getClass().getSimpleName().toLowerCase() : nameHint;
        this.componentPath = this.parentPath + this.name;
        this.pagePath = pagePath;
        this.client = client;
    }

    public SlingHttpResponse create(String order, int ... expectedStatus) throws ClientException, InterruptedException {
        SlingHttpResponse exec = this.client.doPost(this.parentPath, (HttpEntity)this.getCreateFormEntity(order).build(), new int[0]);
        String errorMessage = "Creating a '" + this.getClass().getSimpleName() + "' component below " + this.getParentPath() + " failed!";
        HttpUtils.verifyHttpStatus((HttpResponse)exec, (String)errorMessage, (int[])HttpUtils.getExpectedStatus((int)201, (int[])expectedStatus));
        this.componentPath = exec.getSlingPath();
        this.name = this.componentPath.substring(this.componentPath.lastIndexOf("/") + 1);
        this.getComponentNode();
        return exec;
    }

    public FormEntityBuilder getCreateFormEntity(String order) {
        FormEntityBuilder fBuilder = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter("./sling:resourceType", this.getResourceType()).addParameter(":nameHint", this.getName()).addParameter("./jcr:created", "").addParameter("./jcr:createdBy", "").addParameter("./jcr:lastModified", "").addParameter("./jcr:lastModifiedBy", "");
        if (order != null && !order.equals("")) {
            fBuilder.addParameter(":order", order);
        }
        return fBuilder;
    }

    public SlingHttpResponse save(int ... expectedStatus) throws ClientException, InterruptedException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter("_charset_", "utf-8").addParameter("./sling:resourceType", this.getResourceType());
        for (String key : this.changeProperties.keySet()) {
            String[] values;
            for (String value : values = this.changeProperties.get(key)) {
                if (key.startsWith(":")) continue;
                form.addParameter("./" + key, value);
            }
        }
        SlingHttpResponse exec = this.client.doPost(this.componentPath, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        this.getComponentNode();
        return exec;
    }

    public SlingHttpResponse reorder(String order, int ... expectedStatus) throws ClientException, InterruptedException {
        FormEntityBuilder form = FormEntityBuilder.create().addParameter(":order", order);
        SlingHttpResponse exec = this.client.doPost(this.componentPath, (HttpEntity)form.build(), HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        this.getComponentNode();
        return exec;
    }

    public void setProperty(String name, String ... value) {
        this.changeProperties.put(name, value);
    }

    public void setProperty(String name, int value) {
        this.changeProperties.put(name, new String[]{Integer.toString(value)});
    }

    public String getPropertyAsString(String propName) {
        JsonNode propNode = this.getJsonNode(propName);
        if (propNode == null) {
            return null;
        }
        if (propNode.isArray()) {
            ArrayNode array = (ArrayNode)propNode;
            if (array.size() == 0) {
                return null;
            }
            return array.get(0).asText();
        }
        return this.getJsonNode(propName).asText();
    }

    public String[] getPropertyAsStringArray(String propName) {
        return this.getStringArrayFromJsonNode(this.getJsonNode(propName));
    }

    public JsonNode getProperty(String propName) {
        return this.getJsonNode(propName);
    }

    public JsonNode getComponentNode() throws ClientException, InterruptedException {
        try {
            this.client.waitExists(this.getComponentPath(), 60000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Component does not exist " + this.getComponentPath(), (Throwable)e);
        }
        this.jsonNode = this.client.doGetJson(this.getComponentPath(), -1, new int[0]);
        return this.jsonNode;
    }

    private String[] getStringArrayFromJsonNode(JsonNode propNode) {
        if (propNode == null) {
            return null;
        }
        if (!propNode.isArray()) {
            return new String[]{propNode.asText()};
        }
        ArrayNode array = (ArrayNode)propNode;
        if (array.size() == 0) {
            return null;
        }
        String[] values = new String[array.size()];
        for (int i = 0; i < array.size(); ++i) {
            values[i] = array.get(i).asText();
        }
        return values;
    }

    public String getName() {
        return this.name;
    }

    public String getParentPath() {
        return this.parentPath;
    }

    public String getComponentPath() {
        return this.componentPath;
    }

    public String getPagePath() {
        return this.pagePath;
    }

    public String getLocation() {
        return this.location;
    }

    public abstract String getResourceType();

    public ComponentClient getClient() {
        return this.client;
    }

    private JsonNode getJsonNode(String propName) {
        StringTokenizer st = new StringTokenizer(propName, "/");
        JsonNode prop = this.jsonNode;
        while (st.hasMoreElements()) {
            prop = prop.get((String)st.nextElement());
        }
        return prop;
    }

    public <T extends AbstractComponent> T getNext() throws ClientException, InterruptedException {
        String nextPath = this.getNextNodePath();
        if (nextPath == null) {
            return null;
        }
        return this.client.getComponent(nextPath);
    }

    public String getNextNodePath() throws ClientException, InterruptedException {
        try {
            this.client.waitExists(this.getParentPath(), 60000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Parent path does not exist " + this.getComponentPath(), (Throwable)e);
        }
        JsonNode parNode = this.client.doGetJson(this.getParentPath(), 1, new int[0]);
        Iterator it = parNode.fieldNames();
        while (it.hasNext()) {
            String testName = (String)it.next();
            if (!parNode.get(testName).isObject() || !testName.equals(this.getName())) continue;
            if (it.hasNext()) {
                return this.getParentPath() + (String)it.next();
            }
            return null;
        }
        return null;
    }

    public <T extends AbstractComponent> T getFirstChild() throws ClientException, InterruptedException {
        JsonNode parentNode = this.getComponentNode();
        Iterator it = parentNode.fieldNames();
        while (it.hasNext()) {
            String childName = (String)it.next();
            JsonNode child = parentNode.get(childName);
            if (!child.isObject() || child.get("sling:resourceType").isMissingNode()) continue;
            return this.client.getComponent(this.getComponentPath() + "/" + childName);
        }
        return null;
    }

    public <T extends AbstractComponent> T getPrevious() throws ClientException, InterruptedException {
        String prevPath = this.getPreviousNodePath();
        if (prevPath == null) {
            return null;
        }
        return this.client.getComponent(prevPath);
    }

    public String getPreviousNodePath() throws ClientException, InterruptedException {
        try {
            this.client.waitExists(this.getParentPath(), 60000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Component does not exist " + this.getComponentPath(), (Throwable)e);
        }
        JsonNode parNode = this.client.doGetJson(this.getParentPath(), 1, new int[0]);
        String prevNodeName = null;
        Iterator it = parNode.fieldNames();
        while (it.hasNext()) {
            String testName = (String)it.next();
            if (!parNode.get(testName).isObject()) continue;
            if (testName.equals(this.getName())) {
                if (prevNodeName != null) {
                    return this.getParentPath() + prevNodeName;
                }
                return null;
            }
            prevNodeName = testName;
        }
        return null;
    }
}

