/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.jobs;

import com.adobe.cq.testing.client.jobs.JobDescriptor;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class JobsList
extends LinkedList<JobDescriptor> {
    List<JobDescriptor> active;
    List<JobDescriptor> queued;

    public JobsList() {
        this.active = new LinkedList<JobDescriptor>();
        this.queued = new LinkedList<JobDescriptor>();
    }

    public JobsList(List<JobDescriptor> active, List<JobDescriptor> queued) {
        super(active);
        this.addAll(queued);
        this.active = active;
        this.queued = queued;
    }

    public JobsList(Collection<? extends JobDescriptor> c) {
        super(c);
        for (JobDescriptor jobDescriptor : c) {
            if (jobDescriptor.isStarted()) {
                this.active.add(jobDescriptor);
                continue;
            }
            this.queued.add(jobDescriptor);
        }
    }

    @Override
    public boolean add(JobDescriptor jobDescriptor) {
        boolean added = super.add(jobDescriptor);
        if (jobDescriptor.isStarted()) {
            this.active.add(jobDescriptor);
        } else {
            this.queued.add(jobDescriptor);
        }
        return added;
    }

    public List<JobDescriptor> getActive() {
        return this.active;
    }

    public void setActive(List<JobDescriptor> active) {
        this.active = active;
    }

    public List<JobDescriptor> getQueued() {
        return this.queued;
    }

    public void setQueued(List<JobDescriptor> queued) {
        this.queued = queued;
    }
}

