/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.workflow;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class WorkflowModel {
    private JsonNode rootNode = null;

    public WorkflowModel(JsonNode rootNode) {
        this.rootNode = rootNode;
    }

    public String getId() {
        if (this.rootNode.get("id") == null) {
            return null;
        }
        return this.rootNode.get("id").asText();
    }

    public String getTitle() {
        if (this.rootNode.get("title") == null) {
            return null;
        }
        return this.rootNode.get("title").asText();
    }

    public String getDescription() {
        if (this.rootNode.get("description") == null) {
            return null;
        }
        return this.rootNode.get("description").asText();
    }

    public String getVersion() {
        if (this.rootNode.get("version") == null) {
            return null;
        }
        return this.rootNode.get("version").asText();
    }

    public int getVersionMajor() {
        if (this.getVersion() == null) {
            return -1;
        }
        return Integer.parseInt(this.getVersion().split("\\.")[0]);
    }

    public int getVersionMinor() {
        if (this.getVersion() == null) {
            return -1;
        }
        return Integer.parseInt(this.getVersion().split("\\.")[1]);
    }

    public Map getMetaData() {
        return this.getFieldsMap(this.rootNode.get("metaData"));
    }

    public Map<String, Node> getNodes() {
        if (this.rootNode.get("nodes") == null) {
            return null;
        }
        HashMap<String, Node> map = new HashMap<String, Node>();
        JsonNode nodes = this.rootNode.get("nodes");
        for (int i = 0; i < nodes.size(); ++i) {
            JsonNode n = nodes.get(i);
            map.put(n.get("id").asText(), new Node(n));
        }
        return map;
    }

    public Node getNodeById(String nodeId) {
        if (this.rootNode.get("nodes") == null) {
            return null;
        }
        JsonNode nodes = this.rootNode.get("nodes");
        for (int i = 0; i < nodes.size(); ++i) {
            if (!nodes.get(i).get("id").asText().equals(nodeId)) continue;
            return new Node(nodes.get(i));
        }
        return null;
    }

    public ArrayList<Transition> getTransitions() {
        if (this.rootNode.get("transitions") == null) {
            return null;
        }
        ArrayList<Transition> list = new ArrayList<Transition>();
        JsonNode transitions = this.rootNode.get("transitions");
        for (int i = 0; i < transitions.size(); ++i) {
            list.add(new Transition(transitions.get(i)));
        }
        return list;
    }

    protected Map<String, String> getFieldsMap(JsonNode node) {
        if (node == null) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Iterator it = node.fieldNames();
        while (it.hasNext()) {
            String key = (String)it.next();
            map.put(key, node.get(key).asText());
        }
        return map;
    }

    public class Transition {
        private JsonNode transitionNode;

        protected Transition(JsonNode node) {
            this.transitionNode = node;
        }

        public String getFrom() {
            if (this.transitionNode.get("from") == null) {
                return null;
            }
            return this.transitionNode.get("from").asText();
        }

        public String getTo() {
            if (this.transitionNode.get("to") == null) {
                return null;
            }
            return this.transitionNode.get("to").asText();
        }

        public String getRule() {
            if (this.transitionNode.get("rule") == null) {
                return null;
            }
            return this.transitionNode.get("rule").asText();
        }

        public Map getMetaData() {
            if (this.transitionNode.get("metaData") == null) {
                return null;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            JsonNode metaData = this.transitionNode.get("metaData");
            Iterator it = metaData.fieldNames();
            while (it.hasNext()) {
                String key = (String)it.next();
                map.put(key, metaData.get(key).asText());
            }
            return map;
        }
    }

    public class Node {
        private JsonNode nodeNode = null;

        protected Node(JsonNode node) {
            this.nodeNode = node;
        }

        public String getId() {
            if (this.nodeNode.get("id") == null) {
                return null;
            }
            return this.nodeNode.get("id").asText();
        }

        public String getType() {
            if (this.nodeNode.get("type") == null) {
                return null;
            }
            return this.nodeNode.get("type").asText();
        }

        public String getTitle() {
            if (this.nodeNode.get("title") == null) {
                return null;
            }
            return this.nodeNode.get("title").asText();
        }

        public String getDescription() {
            if (this.nodeNode.get("description") == null) {
                return null;
            }
            return this.nodeNode.get("description").asText();
        }

        public Map<String, String> getMetaData() {
            return WorkflowModel.this.getFieldsMap(this.nodeNode.get("metaData"));
        }
    }
}

