/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import com.adobe.cq.testing.junit.rules.OsgiConfigRestoreRule;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.osgi.OsgiConsoleClient;
import org.apache.sling.testing.clients.osgi.OsgiInstanceConfig;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;
import org.apache.sling.testing.clients.util.config.impl.InstanceConfigCacheImpl;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.apache.sling.testing.junit.rules.instance.Instance;
import org.junit.Assert;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogTracerRule
extends ExternalResource {
    private final Logger logger = LoggerFactory.getLogger(OsgiConfigRestoreRule.class);
    private final String pid = "org.apache.sling.tracer.internal.LogTracer";
    private final Instance quickstartRule;
    private OsgiConsoleClient client;
    private InstanceConfigCacheImpl configs;
    private int recordingCacheSizeInMB = 50;
    private int recordingCacheDurationInSecs = 900;
    private List<Header> tracerHeaders = Arrays.asList(new BasicHeader("Sling-Tracer-Record", "true"), new BasicHeader("Sling-Tracer-Config", "com.day;level=error,com.adobe;level=error,org.apache;level=error"));

    public LogTracerRule(Instance quickstartRule) {
        this.quickstartRule = quickstartRule;
    }

    public LogTracerRule(Instance quickstartRule, int recordingCacheSizeInMB, int recordingCacheDurationInSecs) {
        this.quickstartRule = quickstartRule;
        this.recordingCacheSizeInMB = recordingCacheSizeInMB;
        this.recordingCacheDurationInSecs = recordingCacheDurationInSecs;
    }

    public List<Header> getTracerHeaders() {
        return this.tracerHeaders;
    }

    public void setTracerHeaders(List<Header> headers) {
        this.tracerHeaders = headers;
    }

    protected void before() throws ClientException, InstanceConfigException, InterruptedException {
        this.client = (OsgiConsoleClient)this.quickstartRule.getAdminClient(OsgiConsoleClient.class);
        this.configs = new InstanceConfigCacheImpl();
        this.configs.add((InstanceConfig)new OsgiInstanceConfig((SlingClient)this.client, this.pid));
        Map config = new HashMap<String, String>();
        config.put("enabled", "true");
        config.put("servletEnabled", "true");
        config.put("recordingCacheSizeInMB", String.valueOf(this.recordingCacheSizeInMB));
        config.put("recordingCacheDurationInSecs", String.valueOf(this.recordingCacheDurationInSecs));
        try {
            this.client.waitEditConfiguration(30000L, this.pid, null, config, new int[]{302});
            config = this.client.waitGetConfiguration(30000L, this.pid, new int[]{200});
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed editing configuration for " + this.pid, (Throwable)e);
        }
        Assert.assertEquals(config.get("enabled"), (Object)"true");
        Assert.assertEquals(config.get("servletEnabled"), (Object)"true");
    }

    protected void after() {
        try {
            this.configs.restore();
        }
        catch (InterruptedException | InstanceConfigException e) {
            this.logger.error("Could not restore OSGi config.", e);
        }
    }

    public JsonNode getTracerReport(SlingHttpResponse response) throws ClientException, InterruptedException {
        Header requestIdHeader = response.getFirstHeader("Sling-Tracer-Request-Id");
        if (requestIdHeader == null) {
            this.logger.warn("Request did not include Sling-Tracer-Request-Id header.");
            return new ObjectMapper().createObjectNode();
        }
        String requestId = requestIdHeader.getValue();
        LogReportPoller poller = new LogReportPoller(requestId, (SlingClient)this.client);
        try {
            poller.poll(2000L, 100L);
        }
        catch (TimeoutException e) {
            throw new ClientException("Failed to retrieve logs", (Throwable)e);
        }
        return poller.logJson;
    }

    public JsonNode getLogs(SlingHttpResponse response) throws ClientException, InterruptedException {
        JsonNode report = this.getTracerReport(response);
        if (report.get("logs") == null) {
            return new ObjectMapper().createObjectNode();
        }
        return report.get("logs");
    }

    public void verifyLog(SlingHttpResponse response) throws ClientException, InterruptedException {
        JsonNode report = this.getTracerReport(response);
        if (report.get("logs") == null) {
            return;
        }
        JsonNode logs = report.get("logs");
        if (logs.isArray() && logs.size() > 0) {
            Assert.fail((String)("Found error in log: " + logs.get(0)));
        }
    }

    private class LogReportPoller
    extends Polling {
        public String requestId;
        public SlingClient client;
        public JsonNode logJson;

        public LogReportPoller(String requestId, SlingClient client) {
            this.requestId = requestId;
            this.client = client;
        }

        public Boolean call() throws ClientException {
            SlingHttpResponse logResponse = this.client.doGet("/system/console/tracer/" + this.requestId + ".json", new int[]{200});
            this.logJson = JsonUtils.getJsonNodeFromString((String)logResponse.getContent());
            return this.logJson.get("logs") != null;
        }
    }
}

