/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.assets.DirectBinaryAccessSupport;
import com.adobe.cq.testing.client.assets.Util;
import com.adobe.cq.testing.client.assets.dto.FailedRendition;
import com.adobe.cq.testing.client.assets.dto.InitiateUploadFile;
import com.adobe.cq.testing.client.assets.dto.InitiateUploadResponse;
import com.adobe.cq.testing.client.assets.dto.ProcessedAsset;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.EntityTemplate;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.SystemPropertiesConfig;
import org.apache.sling.testing.clients.interceptors.DelayRequestInterceptor;
import org.apache.sling.testing.clients.interceptors.TestDescriptionInterceptor;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.JsonUtils;
import org.apache.sling.testing.clients.util.ResourceUtil;
import org.apache.sling.testing.clients.util.ServerErrorRetryStrategy;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQAssetsClient
extends CQClient {
    private static Logger LOG = LoggerFactory.getLogger(CQAssetsClient.class);
    private static final String ACP_REL_CREATE = "http://ns.adobe.com/adobecloud/rel/create";
    private static final String ACP_LINK_HREF = "href";
    private static final String ACP_LINK_TYPE = "type";
    private static final String ACP_LINK_TYPE_DIRECT = "direct";
    private static final String ACP_LINKS = "_links";
    private static final String ACP_LIST_CONTENT_DAM_FOLDER = "/platform/content/dam";
    private static final String DAM_ASSET_STATE = "dam:assetState";
    private static final String DAM_ASSET_STATE_PROCESSED = "processed";
    private static final String DBA_CONTENT_DAM_INITIATE_UPLOAD = "/content/dam.initiateUpload.json";
    private final DirectBinaryAccessSupport binaryAccessSupport = new DirectBinaryAccessSupport();
    private final CloseableHttpClient storageClient = HttpClientBuilder.create().useSystemProperties().setUserAgent("Java").setMaxConnPerRoute(10).setMaxConnTotal(100).addInterceptorLast((HttpRequestInterceptor)new TestDescriptionInterceptor()).addInterceptorLast((HttpRequestInterceptor)new DelayRequestInterceptor(SystemPropertiesConfig.getHttpDelay())).setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new ServerErrorRetryStrategy()).build();
    protected static final long ASSET_PROCESSED_TIMEOUT = 30000L;
    protected static final long ASSET_PROCESSED_DELAY = 500L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectBinaryAccessSupported() throws ClientException {
        DirectBinaryAccessSupport directBinaryAccessSupport = this.binaryAccessSupport;
        synchronized (directBinaryAccessSupport) {
            if (this.binaryAccessSupport.isUnknown()) {
                this.binaryAccessSupport.setSupported(this.checkDirectBinaryAccessSupport());
            }
            return this.binaryAccessSupport.isSupported();
        }
    }

    public SlingHttpResponse uploadAsset(String fileName, String resourcePath, String mimeType, String parentPath, int ... expectedStatus) throws ClientException {
        if (this.isDirectBinaryAccessSupported()) {
            LOG.info("Using Direct Binary Access for upload");
            return this.uploadAssetDBA(fileName, resourcePath, mimeType, parentPath);
        }
        LOG.info("Using the Create Asset Servlet for upload");
        return this.uploadAssetViaServlet(fileName, resourcePath, mimeType, parentPath, expectedStatus);
    }

    public ProcessedAsset waitAssetProcessed(String assetPath) throws ClientException, TimeoutException, InterruptedException {
        return this.waitAssetProcessed(assetPath, 30000L, 500L);
    }

    public ProcessedAsset waitAssetProcessed(final String assetPath, long timeout, long delay) throws ClientException, TimeoutException, InterruptedException {
        ProcessedAsset processedAsset = new ProcessedAsset();
        processedAsset.setAssetPath(assetPath);
        Polling p = new Polling(){
            private String assetStatus;

            public Boolean call() throws Exception {
                String currentStatus = CQAssetsClient.this.getAssetStatus(assetPath);
                if (!StringUtils.equals((CharSequence)this.assetStatus, (CharSequence)currentStatus)) {
                    LOG.info("Waiting on " + assetPath + ", status: " + currentStatus);
                }
                this.assetStatus = currentStatus;
                return CQAssetsClient.DAM_ASSET_STATE_PROCESSED.equals(this.assetStatus);
            }

            protected String message() {
                return "Asset " + assetPath + " has not been processed after %1$d ms";
            }
        };
        p.poll(timeout, delay);
        processedAsset.setFailedRenditions(this.getAssetProcessingFailures(assetPath));
        processedAsset.setProcessedRenditions(this.getAssetsProcessedRenditions(assetPath));
        return processedAsset;
    }

    public String getAssetStatus(String assetPath) throws ClientException {
        String requestPath = assetPath + "/jcr:content";
        JsonNode node = this.doGetJson(requestPath, 1, new int[]{200});
        JsonNode assetStateNode = node.get(DAM_ASSET_STATE);
        if (assetStateNode == null) {
            throw new ClientException("Property not found: " + requestPath + "/dam:assetState");
        }
        return assetStateNode.textValue();
    }

    public List<FailedRendition> getAssetProcessingFailures(String assetPath) throws ClientException {
        ArrayList<FailedRendition> failedRenditionList = new ArrayList<FailedRendition>();
        String requestPath = assetPath + "/jcr:content/dam:failedRenditions.2.json";
        SlingHttpResponse response = this.doGet(requestPath, new int[]{200, 404});
        if (response.getStatusLine().getStatusCode() == 200) {
            JsonNode failedRenditions = JsonUtils.getJsonNodeFromString((String)response.getContent());
            Iterator fieldNames = failedRenditions.fieldNames();
            while (fieldNames.hasNext()) {
                String message;
                String name = (String)fieldNames.next();
                JsonNode n = failedRenditions.get(name);
                String reason = n.get("reason") != null ? n.get("reason").textValue() : null;
                String string = message = n.get("message") != null ? n.get("message").textValue() : null;
                if (reason == null || message == null) continue;
                failedRenditionList.add(new FailedRendition(name, message, reason));
            }
        }
        return failedRenditionList;
    }

    public List<String> getAssetsProcessedRenditions(String assetPath) throws ClientException {
        ArrayList<String> processedRenditionList = new ArrayList<String>();
        String requestPath = assetPath + "/jcr:content/renditions.2.json";
        SlingHttpResponse response = this.doGet(requestPath, new int[]{200, 404});
        if (response.getStatusLine().getStatusCode() == 200) {
            JsonNode processedRenditions = JsonUtils.getJsonNodeFromString((String)response.getContent());
            Iterator fieldNames = processedRenditions.fieldNames();
            while (fieldNames.hasNext()) {
                String name = (String)fieldNames.next();
                JsonNode n = processedRenditions.get(name);
                String primaryType = n.get("jcr:primaryType") != null ? n.get("jcr:primaryType").textValue() : null;
                if (primaryType == null) continue;
                processedRenditionList.add(name);
            }
        }
        return processedRenditionList;
    }

    public CQAssetsClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    private boolean checkDirectBinaryAccessSupport() throws ClientException {
        SlingHttpResponse response = this.doGet(ACP_LIST_CONTENT_DAM_FOLDER, new int[]{200, 404});
        if (response.getStatusLine().getStatusCode() == 404) {
            return false;
        }
        JsonNode root = JsonUtils.getJsonNodeFromString((String)response.getContent());
        JsonNode createLink = Util.getJsonChildNode(root, ACP_LINKS, ACP_REL_CREATE);
        if (createLink != null) {
            String href = createLink.path(ACP_LINK_HREF).textValue();
            String type = createLink.path(ACP_LINK_TYPE).textValue();
            return DBA_CONTENT_DAM_INITIATE_UPLOAD.equals(href) && ACP_LINK_TYPE_DIRECT.equals(type);
        }
        return false;
    }

    private SlingHttpResponse uploadAssetDBA(String fileName, String resourcePath, String mimeType, String parentPath) throws ClientException {
        long fileSize = Util.getResourceSize(resourcePath);
        long startTime = System.currentTimeMillis();
        InitiateUploadResponse r = this.initiateUpload(fileName, parentPath, fileSize);
        if (r.getCompleteURI().isEmpty()) {
            throw new ClientException("InitiateUpload response is missing the complete URI: " + String.valueOf(r));
        }
        if (r.getFiles().size() != 1) {
            throw new ClientException("InitiateUpload response doesn't contain exactly 1 file: " + String.valueOf(r));
        }
        InitiateUploadFile uploadFile = r.getFiles().get(0);
        List<String> uploadURIs = uploadFile.getUploadURIs();
        if (r.getFiles().size() < 1) {
            throw new ClientException("InitiateUpload response must contain at least 1 url: " + String.valueOf(r));
        }
        long partSize = fileSize / (long)uploadURIs.size();
        if (partSize > uploadFile.getMaxPartSize()) {
            throw new ClientException("InitiateUpload response requires a partSize that's larger than maxPartSize: " + String.valueOf(r) + ", fileSize: " + fileSize);
        }
        long index = 0L;
        for (String uri : uploadURIs) {
            long size = Math.min(partSize, fileSize - index);
            this.uploadAssetPart(resourcePath, mimeType, URI.create(uri), index, size);
            index += size;
        }
        long uploadDuration = System.currentTimeMillis() - startTime;
        return this.completeUpload(r.getCompleteURI(), fileName, uploadFile.getUploadToken(), mimeType, uploadDuration, fileSize);
    }

    private InitiateUploadResponse initiateUpload(String fileName, String parentPath, long fileSize) throws ClientException {
        String requestPath = parentPath + ".initiateUpload.json";
        try {
            HttpEntity entity = MultipartEntityBuilder.create().addTextBody("fileName", fileName).addTextBody("fileSize", Long.toString(fileSize)).setCharset(StandardCharsets.UTF_8).build();
            SlingHttpResponse response = this.doPost(requestPath, entity, new int[]{200});
            ObjectMapper mapper = new ObjectMapper();
            return (InitiateUploadResponse)mapper.readValue(response.getContent(), InitiateUploadResponse.class);
        }
        catch (IOException e) {
            throw new ClientException("Unable to parse JSON response for initiateUpload -  requestPath: " + requestPath + ", fileName: " + fileName + ", fileSize: " + fileSize, (Throwable)e);
        }
    }

    private void uploadAssetPart(String resourcePath, String mimeType, URI targetUri, long start, final long size) throws ClientException {
        HttpPut request = new HttpPut(targetUri);
        request.setHeader("Content-Type", mimeType);
        request.setEntity((HttpEntity)new EntityTemplate(out -> {
            InputStream in = ResourceUtil.getResourceAsStream((String)resourcePath);
            IOUtils.copyLarge((InputStream)in, (OutputStream)out, (long)start, (long)size);
        }){

            public long getContentLength() {
                return size;
            }
        });
        try {
            this.doStorageClientRequest((HttpUriRequest)request, 201);
        }
        catch (IOException e) {
            throw new ClientException("Unable to upload asset part: " + resourcePath + " (start=" + start + ", length=" + size + ")", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doStorageClientRequest(HttpUriRequest request, int ... expectedStatus) throws IOException, ClientException {
        try (CloseableHttpResponse response = this.storageClient.execute(request);){
            if (expectedStatus != null && expectedStatus.length > 0) {
                HttpUtils.verifyHttpStatus((HttpResponse)response, null, (int[])expectedStatus);
            }
            response.getEntity();
        }
    }

    private SlingHttpResponse completeUpload(String completeUri, String fileName, String uploadToken, String mimeType, long uploadDuration, long fileSize) throws ClientException {
        HttpEntity entity = MultipartEntityBuilder.create().addTextBody("fileName", fileName).addTextBody("uploadToken", uploadToken).addTextBody("mimeType", mimeType).addTextBody("uploadDuration", Long.toString(uploadDuration)).addTextBody("fileSize", Long.toString(fileSize)).setCharset(StandardCharsets.UTF_8).build();
        return this.doPost(completeUri, entity, new int[]{200});
    }

    private SlingHttpResponse uploadAssetViaServlet(String fileName, String resourcePath, String mimeType, String parentPath, int ... expectedStatus) throws ClientException {
        HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody("file", ResourceUtil.getResourceAsStream((String)resourcePath), ContentType.create((String)mimeType), fileName).addTextBody("fileName", fileName).setCharset(Charset.forName("utf-8")).build();
        return this.doPost(parentPath + ".createasset.html", entity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }
}

