/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.AuthorizableManager;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.User;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClientConfig;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;

public class SecurityClient
extends CQClient {
    protected static final String LOGIN_URL = "/libs/granite/core/content/login.html";
    protected static final String ADMIN_URL = "/libs/granite/security/content/admin.html";
    private AuthorizableManager authorizableMgr = new AuthorizableManager(this);

    public SecurityClient(CloseableHttpClient http, SlingClientConfig config) throws ClientException {
        super(http, config);
    }

    public SecurityClient(URI serverUrl, String user, String password) throws ClientException {
        super(serverUrl, user, password);
    }

    public String getLoginUrl() {
        return LOGIN_URL;
    }

    public String getAdminUrl() {
        return ADMIN_URL;
    }

    public AuthorizableManager getManager() {
        return this.authorizableMgr;
    }

    public void deleteAuthorizables(Authorizable[] authorizables, int ... expectedStatus) throws ClientException {
        if (authorizables == null) {
            return;
        }
        for (Authorizable authorizable : authorizables) {
            authorizable.delete(expectedStatus);
        }
    }

    public User createUser(String userId, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.createUser(userId, userId, null, null, null, expectedStatus);
    }

    public User createUser(String userId, String intermediatePath, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.createUser(userId, userId, intermediatePath, null, null, expectedStatus);
    }

    public <T extends Group> User createUser(String userId, String password, T[] assignedGroups, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.createUser(userId, password, null, null, (Group[])assignedGroups, expectedStatus);
    }

    public <T extends Group> User createUser(String userId, String password, String intermediatePath, Map<String, String> profileMap, T[] assignedGroups, int ... expectedStatus) throws ClientException, InterruptedException {
        User user = User.createUser(this, userId, password, intermediatePath, profileMap, expectedStatus);
        if (assignedGroups != null) {
            for (T assignedGroup : assignedGroups) {
                ((Group)assignedGroup).addMembers(new Authorizable[]{user}, 200);
            }
        }
        return user;
    }

    @Deprecated
    public <T extends Group> User createUser(String userId, String password, String intermediatePath, Map<String, String> profileMap, boolean waitForIndexing, T[] assignedGroups, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.createUser(userId, password, intermediatePath, profileMap, (Group[])assignedGroups, expectedStatus);
    }

    public Group createGroup(String groupId, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.createGroup(groupId, null, null, null, null, expectedStatus);
    }

    public Group createGroup(String groupId, String intermediatePath, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.createGroup(groupId, intermediatePath, groupId, null, null, expectedStatus);
    }

    public Group createGroup(String groupId, Group[] assignedGroups, int ... expectedStatus) throws ClientException, InterruptedException {
        return this.createGroup(groupId, null, null, null, assignedGroups, expectedStatus);
    }

    public Group createGroup(String groupId, String intermediatePath, String givenName, String aboutMe, Group[] assignedGroups, int ... expectedStatus) throws ClientException, InterruptedException {
        Group group = Group.createGroup(this, groupId, intermediatePath, givenName, aboutMe, expectedStatus);
        if (null != assignedGroups) {
            group.addMembers(assignedGroups, 200);
        }
        return group;
    }

    public String getLoginTokenCookie(int ... expectedStatus) throws ClientException {
        String postPath = this.getLoginUrl() + "/j_security_check";
        UrlEncodedFormEntity feb = FormEntityBuilder.create().addParameter("j_username", this.getUser()).addParameter("j_password", this.getPassword()).addParameter("resource", "/").addParameter("_charset_", "utf-8").addParameter("contextPath", "").build();
        List<Header> headers = Arrays.asList(new BasicHeader("Content-Type", "application/x-www-form-urlencoded"), new BasicHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8"));
        SlingHttpResponse response = this.doPost(postPath, (HttpEntity)feb, headers, HttpUtils.getExpectedStatus((int)302, (int[])expectedStatus));
        String cookie = response.getHeaders("Set-Cookie")[0].getValue();
        cookie = cookie.substring(0, cookie.indexOf(";"));
        return cookie;
    }
}

