/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.assets;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.ResourceUtil;

public class Util {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getResourceSize(String resourcePath) throws ClientException {
        try (InputStream in = ResourceUtil.getResourceAsStream((String)resourcePath);){
            byte[] buffer = new byte[100000];
            long size = 0L;
            while (true) {
                int bytesRead;
                if ((bytesRead = in.read(buffer)) < 0) {
                    long l = size;
                    return l;
                }
                size += (long)bytesRead;
            }
        }
        catch (IOException e) {
            throw new ClientException("Unable to get size of resource: " + resourcePath);
        }
    }

    public static void checkContentLength(SlingHttpResponse response, long expected) throws ClientException {
        long contentLength = response.getEntity().getContentLength();
        if (contentLength != expected) {
            throw new ClientException(String.valueOf(response) + " has wrong content length (" + contentLength + "). Expected " + expected);
        }
    }

    public static void checkContentDisposition(SlingHttpResponse response, String expected) throws ClientException {
        Object[] headers = response.getHeaders("Content-Disposition");
        if (headers == null || headers.length == 0) {
            throw new ClientException(String.valueOf(response) + " has no content disposition. Expected " + expected);
        }
        if (headers.length > 1) {
            throw new ClientException(String.valueOf(response) + " has more than 1 content disposition (" + Arrays.toString(headers) + "). Expected " + expected);
        }
        String contentDisposition = headers[0].getValue();
        if (!expected.equals(contentDisposition)) {
            throw new ClientException(String.valueOf(response) + " has wrong content disposition (" + contentDisposition + "). Expected " + expected);
        }
    }

    public static JsonNode getJsonChildNode(JsonNode parent, String ... children) {
        JsonNode node;
        int i = 0;
        for (node = parent; node != null && i < children.length; node = node.get(children[i++])) {
        }
        return node;
    }

    public static long getJsonLongValue(JsonNode parent, String fieldName) {
        JsonNode field = parent.get(fieldName);
        return field != null ? field.longValue() : 0L;
    }

    private Util() {
    }
}

