/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.components.foundation;

import com.adobe.cq.testing.client.ComponentClient;
import com.adobe.cq.testing.client.components.foundation.AbstractFoundationComponent;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingHttpResponse;
import org.apache.sling.testing.clients.util.FormEntityBuilder;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.apache.sling.testing.clients.util.ResourceUtil;

public class Image
extends AbstractFoundationComponent {
    public static final String RESOURCE_TYPE = "foundation/components/image";
    public static final String PROP_FILE_REFERENCE = "fileReference";
    public static final String PROP_UNDO_BLOBS = ":cq:undoblobs";
    public static final String PROP_FILE = "file";
    public static final String PROP_FILE_TMP = "file.sftmp";
    public static final String PROP_FILE_NAME = "fileName";
    public static final String PROP_WIDTH = "width";
    public static final String PROP_HEIGHT = "height";
    public static final String PROP_IMAGE_CROP = "imageCrop";
    public static final String PROP_IMAGE_ROTATE = "imageRotate";
    public static final String PROP_IMAGE_MAP = "imageMap";
    public static final String PROP_TITLE = "jcr:title";
    public static final String PROP_ALT_TEXT = "alt";
    public static final String PROP_DESCRIPTION = "jcr:description";
    public static final String PROP_LINK_URL = "linkURL";
    public static final String PROP_FILE_MOVE_FROM = "file@MoveFrom";

    public Image(ComponentClient client, String pagePath, String location, String nameHint) {
        super(client, pagePath, location, nameHint);
    }

    public SlingHttpResponse uploadImage(String mimeType, String imageName, String resourcePath, int ... expectedStatus) throws ClientException {
        HttpEntity uploadEntity = MultipartEntityBuilder.create().addBinaryBody("./file.sftmp", ResourceUtil.getResourceAsStream((String)resourcePath), ContentType.create((String)mimeType), imageName).addTextBody("_charset_", "utf-8").build();
        this.client.doPost(this.componentPath, uploadEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
        UrlEncodedFormEntity saveEntity = FormEntityBuilder.create().addParameter("./file@MoveFrom", this.componentPath + "/file.sftmp").addParameter(PROP_UNDO_BLOBS, this.componentPath + "/file").build();
        return this.client.doPost(this.componentPath, (HttpEntity)saveEntity, HttpUtils.getExpectedStatus((int)200, (int[])expectedStatus));
    }

    public void setImageReference(String imageReference) {
        this.setProperty(PROP_FILE_REFERENCE, imageReference);
        this.setProperty(PROP_UNDO_BLOBS, "update:" + this.componentPath + "/file");
    }

    public void setDeleteImage() {
        this.setProperty("file@Delete", "true");
        this.setProperty(PROP_UNDO_BLOBS, "update:" + this.componentPath + "/file");
    }

    @Override
    public String getResourceType() {
        return RESOURCE_TYPE;
    }
}

