/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.CQPermissions;
import com.adobe.cq.testing.client.security.PermissionConfig;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.util.concurrent.TimeoutException;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedCQPermissions
extends CQPermissions {
    private static final Logger LOG = LoggerFactory.getLogger(ExtendedCQPermissions.class);

    public <T extends SecurityClient> ExtendedCQPermissions(T client) {
        super(client);
    }

    public JsonNode changePermissionsWithRetry(final PermissionConfig config, long timeout, long delay, final int ... expectedStatus) throws ClientException, InterruptedException {
        class ChangePermissionsPolling
        extends Polling {
            JsonNode permissions = JsonNodeFactory.instance.objectNode();

            ChangePermissionsPolling() {
            }

            public Boolean call() throws Exception {
                try {
                    this.permissions = ExtendedCQPermissions.this.changePermissions(config.getAuthorizableId(), config.getPath(), config.isRead(), config.isModify(), config.isCreate(), config.isDelete(), config.isAclRead(), config.isAclEdit(), config.isReplicate(), expectedStatus);
                    LOG.info("new set permission response string for {} at {}: {}", new Object[]{config.getAuthorizableId(), config.getPath(), this.permissions});
                    return true;
                }
                catch (Exception e) {
                    LOG.warn("Error on change permission -> retry:  {}", (Object)e.getLocalizedMessage(), (Object)e);
                    throw e;
                }
            }
        }
        ChangePermissionsPolling createPolling = new ChangePermissionsPolling();
        try {
            createPolling.poll(timeout, delay);
        }
        catch (TimeoutException e) {
            String errorMsg = String.format("Failed to change permission for {} at {} in {}", config.getAuthorizableId(), config.getPath(), createPolling.getWaited());
            throw new ClientException(errorMsg, (Throwable)e);
        }
        return createPolling.permissions;
    }

    public JsonNode getPermissionsWithRetry(final String authorizableId, final String path, final int depth, long timeout, long delay, final int ... expectedStatus) throws ClientException, InterruptedException {
        class GetPermissionsPolling
        extends Polling {
            JsonNode permissions = JsonNodeFactory.instance.objectNode();

            GetPermissionsPolling() {
            }

            public Boolean call() throws Exception {
                try {
                    this.permissions = ExtendedCQPermissions.this.getPermissions(authorizableId, path, depth, expectedStatus);
                    LOG.info("get permission response string for {} at {} with depth {}: {}", new Object[]{authorizableId, path, depth, this.permissions});
                    return true;
                }
                catch (Exception e) {
                    LOG.warn("Error on get permission -> retry:  {}", (Object)e.getLocalizedMessage(), (Object)e);
                    throw e;
                }
            }
        }
        GetPermissionsPolling createPolling = new GetPermissionsPolling();
        try {
            createPolling.poll(timeout, delay);
        }
        catch (TimeoutException e) {
            String errorMsg = String.format("Failed to get permission for {} at {} with depth {} in {}", authorizableId, path, depth, createPolling.getWaited());
            throw new ClientException(errorMsg, (Throwable)e);
        }
        return createPolling.permissions;
    }
}

