/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.client.security;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.Group;
import com.adobe.cq.testing.client.security.User;
import java.util.Random;
import java.util.UUID;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.config.InstanceConfig;
import org.apache.sling.testing.clients.util.config.InstanceConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewRandomUserInstanceConfig
implements InstanceConfig {
    private static final Logger LOG = LoggerFactory.getLogger(NewRandomUserInstanceConfig.class);
    private final Group[] assignedGroups;
    private final SecurityClient client;
    String username;
    String password;
    private User user;

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public NewRandomUserInstanceConfig(SecurityClient client, Group[] assignedGroups) {
        this.client = client;
        this.assignedGroups = assignedGroups;
    }

    public InstanceConfig save() throws InstanceConfigException, InterruptedException {
        this.username = "testuser-" + String.valueOf(UUID.randomUUID());
        this.password = this.randomPass(30);
        try {
            this.user = this.client.createUser(this.username, this.password, this.assignedGroups, new int[0]);
        }
        catch (ClientException e) {
            throw new InstanceConfigException((Exception)((Object)e));
        }
        return this;
    }

    public InstanceConfig restore() throws InstanceConfigException, InterruptedException {
        try {
            if (null == this.user && User.exists(this.client, this.username)) {
                LOG.info("Deleting user {} (operation failed, but the user is present on the instance)", (Object)this.username);
                this.user = new User(this.client, this.username);
            }
        }
        catch (ClientException e) {
            throw new InstanceConfigException((Exception)((Object)e));
        }
        try {
            this.client.deleteAuthorizables(new Authorizable[]{this.user}, new int[0]);
            LOG.info("Deleted user {}", (Object)this.username);
        }
        catch (ClientException e) {
            throw new InstanceConfigException((Exception)((Object)e));
        }
        return this;
    }

    private String randomPass(int length) {
        return new Random().ints(97, 123).limit(length).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
    }
}

