/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.assertion;

import com.adobe.cq.testing.client.CQClient;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.http.HttpResponse;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.util.HttpUtils;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraniteAssert {
    private static final Logger LOG = LoggerFactory.getLogger(GraniteAssert.class);

    public static void assertRegExMatch(String toValidate, String pattern) {
        GraniteAssert.assertRegExMatch(null, toValidate, pattern);
    }

    public static void assertRegExMatch(String message, String toValidate, String pattern) {
        GraniteAssert.assertRegExMatch(message, toValidate, Pattern.compile(pattern, 32));
    }

    public static void assertRegExMatch(String toValidate, Pattern pattern) {
        GraniteAssert.assertRegExMatch(null, toValidate, pattern);
    }

    public static void assertRegExMatch(String message, String toValidate, Pattern pattern) {
        Assert.assertNotNull((String)"the string to validate must not be null", (Object)toValidate);
        Assert.assertNotNull((String)"the pattern to test the string against must not be null", (Object)pattern);
        Assert.assertTrue((String)message, (boolean)pattern.matcher(toValidate).matches());
    }

    public static void assertRegExNoMatch(String message, String toValidate, Pattern pattern) {
        Assert.assertNotNull((String)"the string to validate must not be null", (Object)toValidate);
        Assert.assertNotNull((String)"the pattern to test the string against must not be null", (Object)pattern);
        Assert.assertFalse((String)message, (boolean)pattern.matcher(toValidate).matches());
    }

    public static void assertRegExFind(String toValidate, String pattern) {
        GraniteAssert.assertRegExFind(null, toValidate, pattern);
    }

    public static void assertRegExFind(String message, String toValidate, String pattern) {
        GraniteAssert.assertRegExFind(message, toValidate, Pattern.compile(pattern, 32));
    }

    public static void assertRegExFind(String toValidate, Pattern pattern) {
        GraniteAssert.assertRegExFind(null, toValidate, pattern);
    }

    public static void assertRegExFind(String message, String toValidate, Pattern pattern) {
        Assert.assertNotNull((String)"the string to validate must not be null", (Object)toValidate);
        Assert.assertNotNull((String)"the pattern to test the string against must not be null", (Object)pattern);
        Assert.assertTrue((String)message, (boolean)pattern.matcher(toValidate).find());
    }

    public static void assertRegExNoFind(String message, String toValidate, Pattern pattern) {
        Assert.assertNotNull((String)"the string to validate must not be null", (Object)toValidate);
        Assert.assertNotNull((String)"the pattern to test the string against must not be null", (Object)pattern);
        Assert.assertFalse((String)message, (boolean)pattern.matcher(toValidate).find());
    }

    public static void assertStatusCode(HttpResponse httpResponse, int statusCode) {
        GraniteAssert.assertStatusCode(null, httpResponse, new int[]{statusCode});
    }

    public static void assertStatusCode(String message, HttpResponse httpResponse, int statusCode) {
        GraniteAssert.assertStatusCode(null, httpResponse, new int[]{statusCode});
    }

    public static void assertStatusCode(HttpResponse httpResponse, int[] statusCodes) {
        GraniteAssert.assertStatusCode(null, httpResponse, statusCodes);
    }

    public static void assertStatusCode(String message, HttpResponse httpResponse, int[] statusCodes) {
        Assert.assertNotNull((String)"the http response to test for return codes must not be null", (Object)httpResponse);
        Assert.assertNotNull((String)"the codes to test the response against must not be null", (Object)statusCodes);
        try {
            HttpUtils.verifyHttpStatus((HttpResponse)httpResponse, (String)message, (int[])statusCodes);
        }
        catch (ClientException e) {
            throw new AssertionError("Unexpected response code", e);
        }
    }

    public static void assertJsonEquals(String jsonString1, String jsonString2, List<String> ignoreProperties) {
        GraniteAssert.assertJsonEquals(jsonString1, jsonString2, ignoreProperties, null);
    }

    public static void assertJsonEquals(String jsonStringExpected, String jsonStringActual, List<String> ignoreProperties, List<String> ignoreNodes) {
        GraniteAssert.assertJsonEquals(jsonStringExpected, jsonStringActual, ignoreProperties, ignoreNodes, true);
    }

    public static void assertJsonEquals(String jsonStringExpected, String jsonStringActual, List<String> ignoreProperties, List<String> ignoreNodes, boolean ignoreOrderOfProperties) {
        JsonNode jsonTree2;
        JsonNode jsonTree1;
        Assert.assertNotNull((String)"the expected json to compare for equality must not be null", (Object)jsonStringExpected);
        Assert.assertNotNull((String)"the actual json to compare for equality must not be null", (Object)jsonStringActual);
        ObjectMapper mapper = new ObjectMapper();
        try {
            jsonTree1 = mapper.readTree(jsonStringExpected);
            jsonTree2 = mapper.readTree(jsonStringActual);
        }
        catch (IOException e) {
            throw new AssertionError("Failed reading JSON string", e);
        }
        GraniteAssert.removeProperties(jsonTree1, ignoreProperties);
        GraniteAssert.removeProperties(jsonTree2, ignoreProperties);
        GraniteAssert.removeNodes(jsonTree1, ignoreNodes);
        GraniteAssert.removeNodes(jsonTree2, ignoreNodes);
        if (ignoreOrderOfProperties) {
            List<String> failures = GraniteAssert.compareJson(jsonTree1, jsonTree2, new ArrayList<String>());
            if (failures.size() != 0) {
                for (String failure : failures) {
                    LOG.error(failure);
                }
                try {
                    Assert.assertEquals((String)"This json strings are not equal:", (Object)GraniteAssert.prettyPrint(mapper, jsonTree1), (Object)GraniteAssert.prettyPrint(mapper, jsonTree2));
                }
                catch (IOException e) {
                    throw new AssertionError("Failed reading JSON string", e);
                }
            }
        } else {
            Assert.assertEquals((String)"The jsons are not equal", (Object)jsonTree1, (Object)jsonTree2);
        }
    }

    private static List<String> compareJson(JsonNode expected, JsonNode actual, List<String> failures) {
        if (expected.isValueNode() && actual.isValueNode() && !expected.equals((Object)actual)) {
            failures.add("Value nodes are not the same: Expected: " + String.valueOf(expected) + " // Actual: " + String.valueOf(actual));
        }
        if (expected.isArray() && actual.isArray()) {
            if (expected.size() == actual.size()) {
                for (int i = 0; i < expected.size(); ++i) {
                    GraniteAssert.compareJson(expected.get(i), actual.get(i), failures);
                }
            } else {
                failures.add("Arrays of different size: Expected: " + String.valueOf(expected) + " // Actual: " + String.valueOf(actual));
            }
        }
        if (expected.isObject() && actual.isObject()) {
            Set<String> actualFields;
            Set<String> expectedFields = GraniteAssert.getFieldNames(expected);
            if (expectedFields.equals(actualFields = GraniteAssert.getFieldNames(actual))) {
                for (String name : expectedFields) {
                    GraniteAssert.compareJson(expected.get(name), actual.get(name), failures);
                }
            } else {
                failures.add("Object with different properties: Expected: " + String.valueOf(expected) + " // Actual: " + String.valueOf(actual));
            }
        }
        return failures;
    }

    private static Set<String> getFieldNames(JsonNode object) {
        HashSet<String> names = new HashSet<String>();
        Iterator i = object.fieldNames();
        while (i.hasNext()) {
            names.add((String)i.next());
        }
        return names;
    }

    private static String prettyPrint(ObjectMapper mapper, JsonNode node) throws IOException {
        StringWriter w = new StringWriter();
        JsonGenerator g = mapper.getFactory().createGenerator((Writer)w);
        g.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        mapper.writeTree(g, node);
        return w.toString();
    }

    public static void assertJsonEquals(String jsonString1, String jsonString2) {
        GraniteAssert.assertJsonEquals(jsonString1, jsonString2, null, null);
    }

    private static void removeProperties(JsonNode baseNode, List<String> ignoreProperties) {
        if (ignoreProperties == null) {
            return;
        }
        for (String ignoreProperty : ignoreProperties) {
            JsonNode ignoreNode = baseNode.get(ignoreProperty);
            if (ignoreNode == null) continue;
            ((ObjectNode)baseNode).remove(ignoreProperty);
        }
        for (JsonNode node : baseNode) {
            if (!(node instanceof ContainerNode)) continue;
            GraniteAssert.removeProperties(node, ignoreProperties);
        }
    }

    private static void removeNodes(JsonNode baseNode, List<String> ignoreNodes) {
        if (ignoreNodes == null) {
            return;
        }
        for (String ignoreNodeName : ignoreNodes) {
            JsonNode ignoreNode = baseNode.get(ignoreNodeName);
            if (ignoreNode == null) continue;
            ((ObjectNode)baseNode).remove(ignoreNodeName);
        }
        for (JsonNode node : baseNode) {
            if (!(node instanceof ContainerNode)) continue;
            GraniteAssert.removeNodes(node, ignoreNodes);
        }
    }

    public static void assertIsAgentEnabled(CQClient client, String agentPath) {
        JsonNode node;
        try {
            node = client.doGetJson(agentPath, 1, new int[0]);
        }
        catch (ClientException e) {
            throw new AssertionError("Requesting " + agentPath + ".1.json failed!: ", e);
        }
        node = node.get("jcr:content");
        Assert.assertFalse((String)("Missing " + agentPath + "/jcr:content !"), (boolean)node.isMissingNode());
        node = node.get("enabled");
        Assert.assertFalse((String)("Missing " + agentPath + "/jcr:content/enabled !"), (boolean)node.isMissingNode());
        Assert.assertEquals((String)("Agent " + agentPath + " is not enabled!"), (Object)"true", (Object)node.asText());
    }
}

