/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.client.CQSecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.CQPermissions;
import com.adobe.cq.testing.client.security.Group;
import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;
import org.apache.sling.testing.clients.util.poller.Polling;
import org.junit.rules.ExternalResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemporaryContentAuthorGroup
extends ExternalResource {
    private static final Logger LOG = LoggerFactory.getLogger(TemporaryContentAuthorGroup.class);
    private static final long DEFAULT_TIMEOUT = Duration.ofSeconds(30L).toMillis();
    private static final long DEFAULT_RETRY_DELAY = Duration.ofSeconds(1L).toMillis();
    private static final String CONTENT_NODE = "/content";
    private final Supplier<SlingClient> creatorSupplier;
    private final String groupName;
    private final ThreadLocal<CQClient> groupClient;

    public TemporaryContentAuthorGroup(Supplier<SlingClient> creatorSupplier) {
        if (creatorSupplier == null) {
            throw new IllegalArgumentException("creatorSupplier is null");
        }
        this.creatorSupplier = creatorSupplier;
        this.groupName = this.createUniqueAuthorizableId("testGroup");
        this.groupClient = new ThreadLocal();
    }

    public CQClient getClient() {
        return this.groupClient.get();
    }

    public String getGroupName() {
        return this.groupName;
    }

    public Supplier<SlingClient> getClientSupplier() {
        return this::getClient;
    }

    protected void before() throws Throwable {
        final CQSecurityClient securityClient = (CQSecurityClient)this.creatorSupplier.get().adaptTo(CQSecurityClient.class);
        final CQPermissions permissionsObj = new CQPermissions(securityClient);
        class CreateGroupPolling
        extends Polling {
            Group group;

            CreateGroupPolling() {
            }

            public Boolean call() throws Exception {
                this.group = securityClient.createGroup(TemporaryContentAuthorGroup.this.groupName, 201);
                permissionsObj.changePermissions(this.group.getId(), TemporaryContentAuthorGroup.CONTENT_NODE, true, true, true, false, false, false, false, 200);
                return true;
            }
        }
        CreateGroupPolling p = new CreateGroupPolling();
        try {
            p.poll(DEFAULT_TIMEOUT, TimeUnit.SECONDS.toMillis(DEFAULT_RETRY_DELAY));
        }
        catch (TimeoutException e) {
            LOG.error("Timeout of " + DEFAULT_TIMEOUT + " seconds reached while trying to create group. List of exceptions: " + String.valueOf(p.getExceptions()), (Throwable)e);
            this.deleteGroup();
            throw e;
        }
        LOG.info("Created group {}", (Object)this.groupName);
    }

    protected void after() {
        this.deleteGroup();
    }

    protected void deleteGroup() {
        CQSecurityClient securityClient;
        try {
            securityClient = (CQSecurityClient)this.creatorSupplier.get().adaptTo(CQSecurityClient.class);
        }
        catch (ClientException e) {
            LOG.warn("Unable to delete group", (Throwable)e);
            return;
        }
        try {
            if (Group.exists(securityClient, this.groupName)) {
                Group grouptoDelete = new Group(securityClient, this.groupName);
                new Polling(() -> {
                    securityClient.deleteAuthorizables(new Authorizable[]{grouptoDelete}, new int[0]);
                    return true;
                }).poll(DEFAULT_TIMEOUT, TimeUnit.SECONDS.toMillis(DEFAULT_RETRY_DELAY));
                LOG.info("Deleted group {}", (Object)this.groupName);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to delete group {}, but error is ignored", (Object)this.groupName);
        }
    }

    protected String createUniqueAuthorizableId(String authorizableId) {
        return authorizableId + String.valueOf(UUID.randomUUID());
    }
}

