/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.junit.rules.logfile;

import com.adobe.cq.testing.junit.rules.logfile.LogFileRule;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.runners.model.Statement;

public class LogFileRuleStatement
extends Statement {
    private LogFileRule logFileRule;
    private Statement baseStatement;

    public LogFileRuleStatement(LogFileRule logFileRule, Statement baseStatement) {
        this.logFileRule = logFileRule;
        this.baseStatement = baseStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void evaluate() throws Throwable {
        ArrayList<String> errors = new ArrayList<String>();
        try {
            this.logFileRule.setErrors(new ArrayList<String>());
            List<File> logFiles = this.getLogFiles();
            for (File logFile : logFiles) {
                this.testLogFile(errors, logFile);
            }
        }
        finally {
            this.logFileRule.setErrors(errors);
            this.baseStatement.evaluate();
            this.logFileRule.setErrors(new ArrayList<String>());
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<File> getLogFiles() {
        String[] dirs;
        ArrayList<File> logFiles = new ArrayList<File>();
        String folders = System.getProperty(this.logFileRule.getRuleConfig().quickstartFolderProperty(), "target/author/crx-quickstart");
        for (String string : dirs = folders.split(File.pathSeparator)) {
            File quickstart;
            if (this.logFileRule.getRuleConfig().readLogFileFromTestResources()) {
                void var7_7;
                if (!string.startsWith("/")) {
                    String string2 = "/" + string;
                }
                URL url = ((Object)((Object)this)).getClass().getResource((String)var7_7);
                quickstart = new File(url.getFile());
            } else {
                quickstart = new File(string);
            }
            File logs = new File(quickstart, "logs");
            Assert.assertTrue((String)"logs is not a directory", (boolean)logs.isDirectory());
            File[] files = logs.listFiles();
            for (File file : files != null ? files : new File[]{}) {
                if (file == null || !this.isFileUnderTest(file.getName())) continue;
                logFiles.add(file);
            }
        }
        return logFiles;
    }

    private void testLogFile(List<String> errors, File logFile) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(logFile));){
            String endMarker = this.logFileRule.getEndMarkerForLogFile(logFile.getName());
            String logLine = reader.readLine();
            while (logLine != null) {
                if (endMarker != null && logLine.contains(endMarker)) {
                    break;
                }
                if (this.logLineHasErrors(logLine)) {
                    errors.add(logFile.getName() + " contains the unexpected line: " + logLine);
                    if (this.logFileRule.getRuleConfig().stopAtError()) {
                        return;
                    }
                }
                logLine = reader.readLine();
            }
        }
    }

    private boolean logLineHasErrors(String line) {
        return this.isErrorLine(line) && !this.isKnownIssue(line);
    }

    private boolean isErrorLine(String line) {
        for (String errorMarker : this.logFileRule.getRuleConfig().errorMarkers()) {
            if (!line.contains(errorMarker)) continue;
            return true;
        }
        return false;
    }

    private boolean isKnownIssue(String line) {
        for (String pattern : this.logFileRule.getRuleConfig().knownIssues()) {
            if (!line.contains(pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isFileUnderTest(String fileName) {
        for (String currentFileName : this.logFileRule.getRuleConfig().fileNames()) {
            if (!fileName.equals(currentFileName)) continue;
            return true;
        }
        return false;
    }
}

