/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.util;

import com.adobe.cq.testing.client.CQClient;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.sling.testing.clients.AbstractSlingClient;
import org.apache.sling.testing.clients.util.FormEntityBuilder;

public class LoginUtil {
    public static final String FORM_AUTH_URL = "/libs/crx/core/content/login.html/j_security_check";

    public static HttpResponse doGetWithLoginToken(String loginToken, CQClient cqClient, String testPage) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
        HttpGet get = new HttpGet(cqClient.getUrl(testPage));
        get.addHeader("Cookie", loginToken);
        get.addHeader("Referer", "about:blank");
        return client.execute((HttpUriRequest)get);
    }

    public static <T extends AbstractSlingClient> String getLoginToken(T graniteClient, String targetPage) throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().useSystemProperties().build();
        HttpPost post = LoginUtil.buildFormAuthPost(graniteClient, graniteClient.getUser(), graniteClient.getPassword(), targetPage);
        HttpResponse response = client.execute((HttpUriRequest)post);
        EntityUtils.consume((HttpEntity)response.getEntity());
        Header[] setCookie = response.getHeaders("Set-Cookie");
        String loginToken = setCookie[0].getValue();
        return loginToken.split(";")[0];
    }

    public static <T extends AbstractSlingClient> HttpPost buildFormAuthPost(T graniteClient, String user, String pass, String page) {
        HttpPost post = new HttpPost(graniteClient.getUrl(FORM_AUTH_URL));
        FormEntityBuilder formPartEntity = FormEntityBuilder.create();
        formPartEntity.addParameter("j_username", user);
        formPartEntity.addParameter("j_password", pass);
        formPartEntity.addParameter("resource", graniteClient.getUrl(page).getPath());
        formPartEntity.addParameter("_charset_", "UTF-8");
        formPartEntity.addParameter("contextPath", "");
        post.setEntity((HttpEntity)formPartEntity.build());
        post.setHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
        post.setHeader("Accept", "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8");
        post.setHeader("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64; rv:8.0) Gecko/20100101 Firefox/8.0");
        post.setHeader("Referer", "about:blank");
        return post;
    }
}

