/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.junit.extensions;

import com.adobe.cq.testing.selenium.junit.extensions.SlingClientExtension;
import com.adobe.cq.testing.selenium.utils.Coverage;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.WebDriverRunner;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.testing.clients.SlingClient;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JSCoverageExtension
implements AfterTestExecutionCallback {
    private static final Logger LOG = LoggerFactory.getLogger(JSCoverageExtension.class);

    public void afterTestExecution(ExtensionContext ec) {
        SlingClient client = SlingClientExtension.Store.getInstance().getOrCompute(ec, "author", null, null, false);
        Coverage coverage = new Coverage(client);
        if (client != null && coverage.isConfigPresent() && coverage.isJSCoverAvailable()) {
            WebDriver webDriver = WebDriverRunner.getWebDriver();
            Set windowHandles = webDriver.getWindowHandles();
            windowHandles.forEach(h -> {
                webDriver.switchTo().window(h);
                this.storeCoverage(coverage);
            });
        }
    }

    private void storeCoverage(Coverage coverage) {
        try {
            boolean isCoverageEnabled = (Boolean)Selenide.executeJavaScript((String)"return typeof jscoverage_serializeCoverageToJSON === 'function'", (Object[])new Object[0]);
            if (isCoverageEnabled) {
                Object returnedValue = Selenide.executeJavaScript((String)"return jscoverage_serializeCoverageToJSON();", (Object[])new Object[0]);
                coverage.storeCoverage(returnedValue.toString());
                Object localStorageValue = Selenide.executeJavaScript((String)"return localStorage[\"jscover\"]", (Object[])new Object[0]);
                if (localStorageValue != null) {
                    if (!StringUtils.equals((CharSequence)returnedValue.toString(), (CharSequence)localStorageValue.toString())) {
                        coverage.storeCoverage(localStorageValue.toString());
                    } else {
                        LOG.info("LocalStorage JSCover same as current window value, skip saving...");
                    }
                    Selenide.executeJavaScript((String)"delete localStorage[\"jscover\"]", (Object[])new Object[0]);
                    LOG.info("LocalStorage JSCover detected, saved, then cleaned");
                } else {
                    LOG.info("No LocalStorage JSCover detected.");
                }
            }
        }
        catch (Exception e) {
            LOG.warn("Issue while collecting coverage on current page due to {}", (Object)e.getMessage());
        }
    }
}

