/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject;

import com.adobe.cq.testing.selenium.pageobject.EditorPage;
import com.adobe.cq.testing.selenium.pagewidgets.cq.TimewarpDialog;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import java.net.URI;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PageEditorPage
extends EditorPage {
    private static final Logger LOG = LoggerFactory.getLogger(PageEditorPage.class);
    private SelenideElement editModeButton = Selenide.$((String)"button[is='coral-buttonlist-item'][data-layer='Edit']");
    private SelenideElement editLayerButton = Selenide.$((String)"button.editor-GlobalBar-item[data-layer='Edit']");
    private SelenideElement layoutModeButton = Selenide.$((String)"button[is='coral-buttonlist-item'][data-layer='Layouting']");
    private SelenideElement layoutLayerButton = Selenide.$((String)"button.editor-GlobalBar-item[data-layer='Layouting']");
    private SelenideElement developerModeButton = Selenide.$((String)"button[is='coral-buttonlist-item'][data-layer='Developer']");
    private SelenideElement developerLayerButton = Selenide.$((String)"button.editor-GlobalBar-item[data-layer='Developer']");
    private SelenideElement timewarpModeButton = Selenide.$((String)"button[is='coral-buttonlist-item'][data-layer='Timewarp']");
    private SelenideElement timewarpLayerButton = Selenide.$((String)"button.editor-GlobalBar-item[data-layer='Timewarp']");
    private SelenideElement annotateButton = Selenide.$((String)"button.editor-GlobalBar-item[data-layer='Annotate']");
    private SelenideElement annotateCloseButton = Selenide.$((String)"button.editor-GlobalBar-badge");
    private SelenideElement annotationAddButton = Selenide.$((String)"button.editor-GlobalBar-item[data-action='ENTER_ANNOTATE_MODE_ADD']");
    private SelenideElement lockButton = Selenide.$((String)"button#unlock-page-trigger");
    private SelenideElement resourceStatusBar = Selenide.$((String)".editor-StatusBar-status");
    private TimewarpDialog timewarpDialog;

    public PageEditorPage(URI base, String pagePath) {
        super(base, pagePath);
    }

    public PageEditorPage(String pagePath) {
        super(pagePath);
    }

    public SelenideElement getLockButton() {
        return this.lockButton;
    }

    public SelenideElement getResourceStatusBar() {
        return this.resourceStatusBar;
    }

    public PageEditorPage enterEditMode() throws TimeoutException {
        return (PageEditorPage)this.enterMode(this.editModeButton, this.editLayerButton);
    }

    public PageEditorPage enterLayoutMode() throws TimeoutException {
        return (PageEditorPage)this.enterMode(this.layoutModeButton, this.layoutLayerButton);
    }

    public PageEditorPage enterDeveloperMode() throws TimeoutException {
        return (PageEditorPage)this.enterMode(this.developerModeButton, this.developerLayerButton);
    }

    public PageEditorPage enterTimewarpMode() throws TimeoutException {
        return (PageEditorPage)this.enterMode(this.timewarpModeButton, this.timewarpLayerButton);
    }

    public PageEditorPage enterAnnotateMode() {
        if (this.annotateButton.isDisplayed()) {
            ElementUtils.clickableClick(this.annotateButton);
            this.selectModeButton.shouldNotBe(new Condition[]{Condition.visible});
        }
        return this;
    }

    public PageEditorPage leaveAnnotateMode() {
        if (this.annotateCloseButton.isDisplayed()) {
            ElementUtils.clickableClick(this.annotateCloseButton);
            this.selectModeButton.shouldBe(new Condition[]{Condition.visible});
            this.annotateButton.shouldBe(new Condition[]{Condition.visible});
        }
        return this;
    }

    public TimewarpDialog getTimewarpDialog() throws TimeoutException {
        if (!this.isInTimewarpMode()) {
            this.enterTimewarpMode();
        }
        return this.timewarpDialog == null ? (this.timewarpDialog = new TimewarpDialog()) : this.timewarpDialog;
    }

    public boolean isInEditMode() {
        return ElementUtils.hasWithPolling(this.editLayerButton, Condition.visible) && ElementUtils.hasWithPolling(this.getOverlayWrapper(), Condition.visible) && !this.getOverlayWrapper().is(Condition.cssClass((String)"is-hidden"));
    }

    public boolean isInLayoutMode() {
        return ElementUtils.hasWithPolling(this.layoutLayerButton, Condition.visible) && ElementUtils.hasWithPolling(this.getOverlayWrapper(), Condition.visible) && !this.getOverlayWrapper().is(Condition.cssClass((String)"is-hidden"));
    }

    public boolean isInDeveloperMode() {
        return ElementUtils.hasWithPolling(this.developerLayerButton, Condition.visible) && ElementUtils.hasWithPolling(this.getOverlayWrapper(), Condition.visible) && !this.getOverlayWrapper().is(Condition.cssClass((String)"is-hidden"));
    }

    public boolean isInTimewarpMode() {
        return ElementUtils.hasWithPolling(this.timewarpLayerButton, Condition.visible) && ElementUtils.hasWithPolling(this.getOverlayWrapper(), Condition.hidden) && this.getOverlayWrapper().is(Condition.cssClass((String)"is-hidden"));
    }
}

