/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pageobject.cq.sites;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralPopOver;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelect;
import com.adobe.cq.testing.selenium.pagewidgets.coral.CoralSelectList;
import com.adobe.cq.testing.selenium.pagewidgets.cq.FormField;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Collection;
import com.adobe.cq.testing.selenium.pagewidgets.granite.Wizard;
import com.adobe.cq.testing.selenium.pagewidgets.granite.columnview.ColumnView;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;

public class RestoreVersionWizard
extends Wizard {
    private static final String RESTORE_VERSION_WIZARD_URL = "/mnt/overlay/wcm/core/content/sites/restoreversionwizard.html";
    private static final SelenideElement TITLE_FIELD = new FormField("wizardTitle").getFullyDecoratedElement("coral-panel.is-selected input", new String[0]);
    private static final ColumnView LIST_VIEW = new ColumnView("coral-panel.is-selected .cq-sites-restoreversion-sourcepages");
    private static final SelenideElement COLLECTION_STATUS = new AEMBaseComponent(".cq-common-collectionstatus").element();

    public boolean isOpened() {
        return WebDriverRunner.url().contains(RESTORE_VERSION_WIZARD_URL);
    }

    public SelenideElement title() {
        return TITLE_FIELD;
    }

    public Collection collection() {
        return LIST_VIEW;
    }

    public SelenideElement collectionStatus() {
        return COLLECTION_STATUS;
    }

    public void selectVersion(String uuid, int index) {
        CoralSelect select = new CoralSelect("uuid='" + uuid + "'");
        select.click();
        CoralPopOver popOver = CoralPopOver.firstOpened();
        popOver.waitVisible();
        CoralSelectList list = new CoralSelectList(popOver.element());
        list.selectByIndex(index);
    }

    public static RestoreVersionWizard open(String parent, String source) {
        return (RestoreVersionWizard)new RestoreVersionWizard().open(String.format("%s%s?%s", RESTORE_VERSION_WIZARD_URL, parent, source));
    }
}

