/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets;

import com.adobe.cq.testing.client.CQClient;
import com.adobe.cq.testing.selenium.pagewidgets.common.ActionComponent;
import com.adobe.cq.testing.selenium.pagewidgets.common.BaseComponent;
import com.adobe.cq.testing.selenium.pagewidgets.coral.Dialog;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.Selenide;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.WebDriverRunner;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.MissingNode;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.net.URLCodec;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Point;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Helpers {
    private static final Logger LOG = LoggerFactory.getLogger(Helpers.class);
    private static final String JS_NETWORK_IDLE = "let resources = performance.getEntriesByType(\"resource\");if (resources.find(e => { return e.responseEnd <= 0 })) { return -1;} else { return resources.filter(e => { return e.name.indexOf(\"/pulse.data.json\") < 0 && e.name.indexOf(\"/token.json\") < 0; }).length;}";
    private static final String JS_METRICS_IDLE = "return performance.getEntriesByName(arguments[0]).length";
    private static final String JS_FCP = "return performance.getEntriesByType(\"paint\").length";
    private static final String CK_AFFINITY = "affinity";
    private static final String CK_SUDO = "sling.sudo";
    private static final String US_AEM_FRAME = "Main Content";
    private static final SelenideElement AEM_FRAME = Selenide.$((String)String.format("iframe[name='%s']", "Main Content"));

    private Helpers() {
    }

    public static boolean waitForAlert(int timeout) {
        boolean hasAlert = false;
        try {
            Selenide.Wait().withTimeout(Duration.ofMillis(timeout)).until(webDriver -> webDriver.switchTo().alert().getText() != null);
            hasAlert = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hasAlert;
    }

    public static void waitForElementAnimationFinished(String selector) {
        Helpers.waitForElementAnimationFinished(Selenide.$((String)selector).shouldBe(new Condition[]{Condition.visible}));
    }

    public static void waitForElementAnimationFinished(SelenideElement target) {
        AtomicReference<Point> atomicPoint = new AtomicReference<Point>(new Point(0, 0));
        Selenide.Wait().withTimeout(Duration.ofMillis(3000L)).until(webDriver -> {
            Point currentLocation = target.getLocation();
            Point previousLocation = atomicPoint.getAndSet(currentLocation);
            return previousLocation.getX() == currentLocation.getX() && previousLocation.getY() == currentLocation.getY();
        });
    }

    public static List<String> listOpenURLs() {
        WebDriver webDriver = WebDriverRunner.getWebDriver();
        String currentWindowHandle = webDriver.getWindowHandle();
        Set windowHandles = webDriver.getWindowHandles();
        ArrayList listURLs = new ArrayList();
        windowHandles.forEach(h -> {
            webDriver.switchTo().window(h);
            listURLs.add(webDriver.getCurrentUrl());
        });
        webDriver.switchTo().window(currentWindowHandle);
        return Collections.unmodifiableList(listURLs);
    }

    public static void assertHasOpenedURL(String url) {
        Optional<String> any = Helpers.listOpenURLs().stream().filter(u -> u.contains(url)).findAny();
        assert (any.isPresent()) : "Expected " + url + " to be opened";
    }

    public static boolean switchToURL(String expectedUrl, boolean disableExpectedURLRewriting) {
        WebDriver webDriver = WebDriverRunner.getWebDriver();
        String currentWindowHandle = webDriver.getWindowHandle();
        Set windowHandles = webDriver.getWindowHandles();
        boolean found = false;
        if (!disableExpectedURLRewriting) {
            expectedUrl = Helpers.getExpectedURL(expectedUrl);
        }
        for (String h : windowHandles) {
            webDriver.switchTo().window(h);
            found = webDriver.getCurrentUrl().contains(expectedUrl);
            if (!found) continue;
            break;
        }
        if (!found) {
            webDriver.switchTo().window(currentWindowHandle);
        }
        return found;
    }

    public static boolean switchToURL(String expectedUrl) {
        return Helpers.switchToURL(expectedUrl, false);
    }

    public static String getExpectedURL(String url) {
        if (Helpers.isUnifiedShellFrame() && !url.contains("/ui#/aem/")) {
            url = url.replace(".adobeaemcloud.com/", ".adobeaemcloud.com/ui#/aem/");
            url = url.replace(".adobeaemcloud.net/", ".adobeaemcloud.net/ui#/aem/");
        }
        return url;
    }

    public static void waitForOpen() {
        Helpers.waitForElementAnimationFinished("coral-dialog[open]");
    }

    public static void clickActionButton(String buttonLabel) {
        String btnSelector = "coral-dialog[open] coral-dialog-footer";
        Selenide.$((String)"coral-dialog[open] coral-dialog-footer").$("button*=" + buttonLabel).shouldBe(new Condition[]{Condition.visible, Condition.enabled}).click();
    }

    public static <T extends Dialog> T clickDialogAction(SelenideElement button, T dialog) {
        ElementUtils.clickableClick(button);
        dialog.waitVisible();
        return dialog;
    }

    public static <T extends Dialog> T clickDialogAction(ActionComponent<T> button) {
        return (T)((Dialog)Helpers.clickBaseComponentAction(button));
    }

    public static <T extends BaseComponent> T clickBaseComponentAction(ActionComponent<T> actionComponent) {
        BaseComponent returnComponent = (BaseComponent)actionComponent.perform();
        returnComponent.waitVisible();
        return (T)returnComponent;
    }

    public static boolean waitForListSizeChange(int originalSize, ElementsCollection list, int timeout) {
        boolean listSizeChanged = false;
        try {
            Selenide.Wait().withTimeout(Duration.ofMillis(timeout)).until(webDriver -> originalSize != list.size());
            listSizeChanged = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return listSizeChanged;
    }

    public static void dragOnPage(SelenideElement dragElement, SelenideElement targetElement) {
        dragElement.shouldBe(new Condition[]{Condition.visible});
        targetElement.shouldBe(new Condition[]{Condition.visible});
        Selenide.actions().dragAndDrop((WebElement)dragElement, (WebElement)targetElement).perform();
    }

    public static boolean isElementTopMost(String selector) {
        String elementTopMostJS = "        let selector = arguments[0];\n        // Execute on browser the detection\n        // eslint-disable-next-line no-undef\n        let element = document.querySelector(selector);\n        if (!element) {\n            return false;\n        }\n        let clientRect = element.getBoundingClientRect();\n        let elementX = clientRect.left;\n        let elementY = clientRect.top;\n        // eslint-disable-next-line no-undef\n        let visibleElementAtPosition = document.elementFromPoint(elementX, elementY);\n        return element === visibleElementAtPosition;\n";
        return (Boolean)Selenide.executeJavaScript((String)"        let selector = arguments[0];\n        // Execute on browser the detection\n        // eslint-disable-next-line no-undef\n        let element = document.querySelector(selector);\n        if (!element) {\n            return false;\n        }\n        let clientRect = element.getBoundingClientRect();\n        let elementX = clientRect.left;\n        let elementY = clientRect.top;\n        // eslint-disable-next-line no-undef\n        let visibleElementAtPosition = document.elementFromPoint(elementX, elementY);\n        return element === visibleElementAtPosition;\n", (Object[])new Object[]{selector});
    }

    private static boolean assertFCP() {
        return (Long)Selenide.executeJavaScript((String)JS_FCP, (Object[])new Object[0]) == 2L;
    }

    public static void waitFirstContentPaint() {
        Selenide.Wait().until(webdriver -> Helpers.assertFCP());
    }

    private static boolean assertNetworkIdled(long pollingInterval) {
        long initialCount = (Long)Selenide.executeJavaScript((String)JS_NETWORK_IDLE, (Object[])new Object[0]);
        boolean asserted = false;
        if (initialCount >= 0L) {
            Selenide.sleep((long)pollingInterval);
            long afterCount = (Long)Selenide.executeJavaScript((String)JS_NETWORK_IDLE, (Object[])new Object[0]);
            if (afterCount >= 0L) {
                asserted = initialCount == afterCount;
            } else {
                LOG.info("Network busy#2");
            }
        } else {
            LOG.info("Network busy#1");
        }
        return asserted;
    }

    private static boolean assertMetricsIdled(long pollingInterval, String name) {
        long initialCount = (Long)Selenide.executeJavaScript((String)JS_METRICS_IDLE, (Object[])new Object[]{name});
        Selenide.sleep((long)pollingInterval);
        long afterCount = (Long)Selenide.executeJavaScript((String)JS_METRICS_IDLE, (Object[])new Object[]{name});
        return initialCount == afterCount;
    }

    private static boolean assertDOMIdled(long pollingInterval) {
        String previousHTML = WebDriverRunner.source();
        Selenide.sleep((long)pollingInterval);
        boolean same = WebDriverRunner.source().equals(previousHTML);
        if (!same) {
            LOG.info("DOM Changed detected !");
        }
        return same;
    }

    public static void waitNetworkIdled(long pollingInterval) {
        LOG.info("waitNetworkIdled with polling interval={}ms", (Object)pollingInterval);
        Selenide.Wait().until(webdriver -> Helpers.assertNetworkIdled(pollingInterval));
    }

    public static void waitDocumentLoadCompleted() {
        LOG.info("waitDocumentLoadComleted");
        Selenide.Wait().until(driver -> ((JavascriptExecutor)driver).executeScript("return document.readyState", new Object[0]).equals("complete"));
    }

    public static void waitDOMIdled(long pollingInterval) {
        LOG.info("waitDOMIdled with polling interval={}ms", (Object)pollingInterval);
        Selenide.Wait().until(webdriver -> Helpers.assertDOMIdled(pollingInterval));
    }

    public static void waitMetricsIdled(long pollingInterval, String name) {
        Selenide.Wait().until(webdriver -> Helpers.assertMetricsIdled(pollingInterval, name));
    }

    public static void setAffinityCookie(CQClient client) {
        client.getCookieStore().getCookies().stream().filter(cookie -> cookie.getName().equals(CK_AFFINITY)).findFirst().ifPresent(c -> Helpers.setAffinityCookie(c.getValue()));
    }

    public static void setAffinityCookie(String affinity) {
        Cookie existingCookie;
        if (affinity != null && (existingCookie = Helpers.getCookie(CK_AFFINITY)) != null && !existingCookie.getValue().equals(affinity)) {
            LOG.info("Client affinity cookie and browser cookie have different value, synching ...");
            Cookie newCookie = new Cookie.Builder(CK_AFFINITY, affinity).domain(existingCookie.getDomain()).expiresOn(existingCookie.getExpiry()).isHttpOnly(existingCookie.isHttpOnly()).isSecure(existingCookie.isSecure()).path(existingCookie.getPath()).build();
            WebDriverRunner.getWebDriver().manage().deleteCookieNamed(CK_AFFINITY);
            WebDriverRunner.getWebDriver().manage().addCookie(newCookie);
            LOG.info("Setting browser affinity cookie with value {}", (Object)newCookie.getValue());
        }
    }

    public static Cookie getCookie(String cookieName) {
        return WebDriverRunner.getWebDriver().manage().getCookieNamed(cookieName);
    }

    public static JsonNode getCookieValue(String cookieName) {
        MissingNode result = MissingNode.getInstance();
        Cookie cookie = Helpers.getCookie(cookieName);
        if (cookie != null) {
            try {
                String value = cookie.getValue();
                String decodedValue = new URLCodec().decode(value);
                result = new ObjectMapper().readTree(decodedValue);
            }
            catch (IOException | DecoderException e) {
                LOG.error("Error while getting cookie value: " + e.getMessage());
            }
        }
        return result;
    }

    public static void setImpersonateCookie(String impUser) {
        if (impUser != null) {
            Cookie existingCookie = Helpers.getCookie(CK_AFFINITY);
            Cookie newCookie = new Cookie.Builder(CK_SUDO, impUser).domain(existingCookie.getDomain()).expiresOn(existingCookie.getExpiry()).isHttpOnly(existingCookie.isHttpOnly()).isSecure(existingCookie.isSecure()).path(existingCookie.getPath()).build();
            WebDriverRunner.getWebDriver().manage().addCookie(newCookie);
            LOG.info("Setting browser impersonate cookie with value {}", (Object)newCookie.getValue());
        }
    }

    public static void removeImpersonateCookie() {
        WebDriverRunner.getWebDriver().manage().deleteCookieNamed(CK_SUDO);
    }

    public static void switchToAemContentFrame() {
        Selenide.switchTo().defaultContent();
        if (Helpers.isUnifiedShellFrame() && AEM_FRAME.exists()) {
            Selenide.switchTo().frame(US_AEM_FRAME);
        }
    }

    public static boolean isUnifiedShellFrame() {
        String currentURL = WebDriverRunner.getWebDriver().getCurrentUrl();
        LOG.info("isUnifiedShellFrame {}", (Object)currentURL);
        return currentURL.contains("/ui#/aem/");
    }

    public static boolean waitIfPresentAtMost(SelenideElement element, long pacing, long maxRetries) {
        boolean present = false;
        int i = 0;
        while ((long)i < maxRetries) {
            if (element.exists()) {
                present = true;
                break;
            }
            Selenide.sleep((long)pacing);
            ++i;
        }
        return present;
    }

    public static void executeIfPresent(SelenideElement element, long pacing, long maxRetries, Runnable runnableCode) {
        if (Helpers.waitIfPresentAtMost(element, pacing, maxRetries) && runnableCode != null) {
            runnableCode.run();
        }
    }
}

