/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.pagewidgets.coral;

import com.adobe.cq.testing.selenium.pagewidgets.common.AEMBaseComponent;
import com.adobe.cq.testing.selenium.utils.ElementUtils;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

public final class CoralButtonList
extends AEMBaseComponent {
    private static final String BUTTON_ITEM_ELEMENT = "button[is=\"coral-buttonlist-item\"]";

    public CoralButtonList(SelenideElement parent) {
        super(parent.find("coral-buttonlist"));
    }

    public CoralButtonList(String selector) {
        super(selector);
    }

    public ElementsCollection items() {
        return this.element().$$(BUTTON_ITEM_ELEMENT);
    }

    public SelenideElement getItemByValue(String value) {
        return this.element().$(String.format("%s[value=\"%s\"]", BUTTON_ITEM_ELEMENT, value));
    }

    public SelenideElement getItemByText(String text) {
        return this.element().$$(BUTTON_ITEM_ELEMENT).findBy(Condition.text((String)text));
    }

    public void selectByValue(String value) {
        SelenideElement item = this.getItemByValue(value);
        if (item != null) {
            ElementUtils.clickableClick(item);
        }
    }

    public boolean hasItemByValue(String value) {
        return this.getItemByValue(value) != null;
    }
}

