/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.cq.testing.selenium.utils;

import com.adobe.cq.testing.client.SecurityClient;
import com.adobe.cq.testing.client.security.Authorizable;
import com.adobe.cq.testing.client.security.CQAuthorizableManager;
import com.adobe.cq.testing.client.security.CQPreferences;
import com.adobe.cq.testing.client.security.User;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicNameValuePair;
import org.apache.sling.testing.clients.ClientException;
import org.apache.sling.testing.clients.SlingClient;

public final class DisableTour {
    static final String[] DEFAULT_TOURS = new String[]{"cq.authoring.editor.page.showTour62", "cq.authoring.editor.page.showOnboarding62", "cq.authoring.editor.template.showTour", "cq.authoring.editor.template.showOnboarding", "granite.shell.showonboarding620"};
    private final SlingClient client;
    private final User adminUser;
    private JsonNode originalPreferences;

    public DisableTour(SlingClient c) throws ClientException {
        this.client = c;
        SecurityClient securityClient = (SecurityClient)this.client.adaptTo(SecurityClient.class);
        String user = securityClient.getUser();
        CQAuthorizableManager authorizableManager = new CQAuthorizableManager(securityClient);
        this.adminUser = authorizableManager.getUser(user);
        CQPreferences cqPreferences = new CQPreferences((Authorizable)this.adminUser);
        this.originalPreferences = cqPreferences.getJson(new int[]{200});
    }

    public void disableTours(String ... tourProperties) throws ClientException, UnsupportedEncodingException {
        ArrayList parameters = new ArrayList();
        Arrays.stream(tourProperties).forEach(tourProperty -> parameters.add(new BasicNameValuePair(tourProperty, "false")));
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters);
        this.client.doPost(this.adminUser.getHomePath() + "/" + "preferences", (HttpEntity)entity, new int[]{200, 201});
    }

    public void disableDefaultTours() throws UnsupportedEncodingException, ClientException {
        this.disableTours(DEFAULT_TOURS);
    }

    public void restoreDefaults() throws ClientException {
        StringEntity jsonEntity = new StringEntity(this.originalPreferences.toString(), ContentType.APPLICATION_JSON);
        this.client.doPost(this.adminUser.getHomePath() + "/" + "preferences", (HttpEntity)jsonEntity, new int[]{200, 201});
    }
}

