/*
 * Copyright 2021 Adobe Systems Incorporated
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.adobe.cq.testing.selenium.pagewidgets;

import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.SelenideElement;

import java.util.ArrayList;
import java.util.List;

import static com.codeborne.selenide.Selenide.$;

public final class DesignPicker {
    private SelenideElement wcmDesignPicker = $("#wcm-ui-designfield-picker-collection");

    public SelenideElement getDesignPickerMainElement() {
        return wcmDesignPicker;
    }

    public List<String> getRoots() {
        List<String> actualRoots = new ArrayList<>();
        ElementsCollection rootsElements = wcmDesignPicker.$$("coral-columnview-item");
        rootsElements.stream()
                .forEach(se -> actualRoots.add(se.getAttribute("data-foundation-collection-item-id")));
        return actualRoots;
    }
}
